/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.TokenCertificate;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SigningCertificateWidget
extends SimpleWidgetDataContributor {
    protected Listener statusListener_;
    protected Text certPath;
    protected TokenCertificate certificate;
    protected Button useCertificate;
    protected Button browse;
    protected Group trustGroup;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        final Composite theParent = parent;
        this.useCertificate = WSSecurityUIPlugin.getUiUtils().createCheckbox(parent, WSSecurityUIPlugin.getMessage("LABEL_CERTIFICATE"), null, null);
        this.useCertificate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SigningCertificateWidget.this.setEnabled(SigningCertificateWidget.this.useCertificate.getSelection());
                SigningCertificateWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.trustGroup = WSSecurityUIPlugin.getUiUtils().createGroup(parent, WSSecurityUIPlugin.getMessage("%LABEL_CERTIFICATE_INFO"), null, null, 3, -1, -1);
        this.certPath = WSSecurityUIPlugin.getUiUtils().createText((Composite)this.trustGroup, ATKWASUIPlugin.getMessage((String)"%LABEL_X509CERTIFICATE"), null, null, 2048);
        this.browse = WSSecurityUIPlugin.getUiUtils().createPushButton((Composite)this.trustGroup, WSSecurityUIPlugin.getMessage("%BUTTON_BROWSE"), null, null);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(theParent.getShell());
                fileDialog.setFilterExtensions(new String[]{"*.cer"});
                String certPathText = fileDialog.open();
                if (certPathText != null) {
                    SigningCertificateWidget.this.certPath.setText(certPathText);
                }
            }
        });
        this.setEnabled(this.useCertificate.getSelection());
        return this;
    }

    protected void setEnabled(boolean enabled) {
        this.trustGroup.setEnabled(enabled);
        this.certPath.setEnabled(enabled);
        this.browse.setEnabled(enabled);
    }

    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    public TokenCertificate getCertificate() {
        if (this.useCertificate.getSelection()) {
            this.certificate.setPath(this.certPath.getText());
            return this.certificate;
        }
        return null;
    }

    public void setCertificate(TokenCertificate newCertificate) {
        if (this.certificate == null) {
            this.certificate = newCertificate;
            if (this.certificate != null) {
                this.certPath.setText(this.certificate.getPath());
            }
        }
    }
}

