/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.KeyStoreInformation;
import com.ibm.ast.ws.security.ui.common.TokenCertificate;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.widgets.KeyStoreWidget;
import com.ibm.ast.ws.security.ui.widgets.SigningCertificateWidget;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class OptionalSigningCertificateWidget
extends SigningCertificateWidget {
    private Button trustAny;
    private Button useCert;
    private KeyStoreWidget keyStoreWidget;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.trustAny = WSSecurityUIPlugin.getUiUtils().createRadioButton(parent, ATKWASUIPlugin.getMessage((String)"%LABEL_TRUST_ANY_CERTIFICATE"), null, null);
        this.trustAny.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalSigningCertificateWidget.this.enableCertificateGroup(false);
                OptionalSigningCertificateWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.useCert = WSSecurityUIPlugin.getUiUtils().createRadioButton(parent, WSSecurityUIPlugin.getMessage("%LABEL_TRUST_CERT"), null, null);
        this.useCert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalSigningCertificateWidget.this.enableCertificateGroup(true);
                OptionalSigningCertificateWidget.this.statusListener_.handleEvent(null);
            }
        });
        this.keyStoreWidget = new KeyStoreWidget();
        this.keyStoreWidget.addControls(parent, statusListener);
        super.addControls(parent, statusListener);
        this.trustAny.setSelection(true);
        return this;
    }

    public IStatus getStatus() {
        if (this.trustAny.getSelection()) {
            return Status.OK_STATUS;
        }
        return this.keyStoreWidget.getStatus();
    }

    public void setCertificate(TokenCertificate certificate) {
        super.setCertificate(certificate);
        this.enableCertificateGroup(!this.trustAny.getSelection());
    }

    protected void enableCertificateGroup(boolean enable) {
        this.useCertificate.setEnabled(enable);
        if (!enable) {
            this.useCertificate.setSelection(enable);
            this.setEnabled(enable);
        }
        this.keyStoreWidget.setEnabled(enable);
    }

    public KeyStoreInformation getKeyStore() {
        return this.trustAny.getSelection() ? null : this.keyStoreWidget.getKeyStore();
    }

    public void setKeyStore(KeyStoreInformation keyStore) {
        this.keyStoreWidget.setKeyStore(keyStore);
    }
}

