/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.KeyStoreInformation;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class KeyStoreWidget
extends SimpleWidgetDataContributor {
    protected Listener statusListener_;
    private Text keyStorePass_;
    private Text keyStorePath_;
    private Combo keyStoreType_;
    private KeyStoreInformation keyStore;
    private Button browsePath;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        final Composite theParent = parent;
        Group keyInfoGroup = WSSecurityUIPlugin.getUiUtils().createGroup(parent, WSSecurityUIPlugin.getMessage("LABEL_KEY_STORE_GROUP"), null, null);
        keyInfoGroup.setLayout((Layout)new GridLayout(3, false));
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        TextModifyListener modifyListener = new TextModifyListener();
        int style = WSUIPlugin.getInstance().getWASSecurityContext().isStarPassword() ? 0x400844 : 2116;
        this.keyStorePass_ = WSSecurityUIPlugin.getUiUtils().createText((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEYSTORE_PASS"), null, null, style);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyStorePass_.setLayoutData((Object)gd);
        this.keyStorePass_.addModifyListener((ModifyListener)modifyListener);
        this.keyStorePath_ = WSSecurityUIPlugin.getUiUtils().createText((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEYSTORE_PATH"), null, null, 2048);
        this.keyStorePath_.setLayoutData((Object)new GridData(768));
        this.browsePath = WSSecurityUIPlugin.getUiUtils().createPushButton((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%BUTTON_BROWSE"), null, null);
        this.browsePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(theParent.getShell());
                String keyStorePathText = fileDialog.open();
                if (keyStorePathText != null) {
                    KeyStoreWidget.this.keyStorePath_.setText(keyStorePathText);
                }
            }
        });
        this.keyStorePath_.addModifyListener((ModifyListener)modifyListener);
        this.keyStoreType_ = WSSecurityUIPlugin.getUiUtils().createCombo((Composite)keyInfoGroup, WSSecurityUIPlugin.getMessage("%LABEL_KEYSTORE_TYPE"), null, null, 2060);
        this.keyStoreType_.setItems(atkWasUiConstants.getKeyStoreTypes());
        this.keyStoreType_.select(1);
        this.keyStoreType_.setLayoutData((Object)gd);
        this.keyStoreType_.addModifyListener((ModifyListener)modifyListener);
        return this;
    }

    public IStatus getStatus() {
        if (this.keyStorePass_.getText().equals("")) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("%ERROR_KEYSTORE_PASS"), null);
        }
        if (this.keyStorePath_.getText().equals("")) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("%ERROR_KEYSTORE_PATH"), null);
        }
        if (this.keyStoreType_.getText().equals("")) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("%ERROR_KEYSTORE_TYPE"), null);
        }
        return Status.OK_STATUS;
    }

    public boolean canFinish() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.keyStoreType_.setEnabled(enabled);
        this.keyStorePass_.setEnabled(enabled);
        this.keyStorePath_.setEnabled(enabled);
        this.browsePath.setEnabled(enabled);
    }

    public void setKeyStore(KeyStoreInformation newKeyStore) {
        if (this.keyStore == null) {
            this.keyStore = newKeyStore;
            this.keyStoreType_.setText(this.keyStore.getKeyStoreType());
            this.keyStorePass_.setText(this.keyStore.getKeyStoreStorePass());
            this.keyStorePath_.setText(this.keyStore.getKeyStorePath());
        }
    }

    public KeyStoreInformation getKeyStore() {
        this.keyStore.setKeyStore(this.keyStorePass_.getText(), this.keyStorePath_.getText(), this.keyStoreType_.getText());
        this.keyStore.setKey(null);
        return this.keyStore;
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            KeyStoreWidget.this.statusListener_.handleEvent(null);
        }
    }
}

