/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.common.SignatureInformation;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.widgets.KeyInformationWidget;
import com.ibm.ast.ws.security.ui.widgets.MessagePartsTableWidget;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class ConsumerSignatureWidget
extends SimpleWidgetDataContributor {
    private KeyInformationWidget keyInfoWidget;
    private Combo signMethod;
    private Text canonicalizationMethod;
    private Text digestMethod;
    private Text transformAlgorithm;
    private SignatureInformation signInfo;
    private MessagePartsTableWidget messageParts;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        UIUtils uiUtils = WSSecurityUIPlugin.getUiUtils();
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        Composite root = uiUtils.createComposite((Composite)scroller, 1);
        scroller.setContent((Control)root);
        Group group = uiUtils.createGroup(root, WSSecurityUIPlugin.getMessage("%LABEL_INTEGRITY_GROUP"), null, null);
        this.messageParts = new MessagePartsTableWidget();
        this.messageParts.addControls((Composite)group, statusListener);
        this.keyInfoWidget = new KeyInformationWidget(true);
        this.keyInfoWidget.addControls(root, statusListener);
        Group signatureGroup = uiUtils.createGroup(root, WSSecurityUIPlugin.getMessage("%LABEL_SIGN_GROUP"), null, null);
        signatureGroup.setLayout((Layout)new GridLayout(2, false));
        this.signMethod = uiUtils.createCombo((Composite)signatureGroup, ATKWASUIPlugin.getMessage((String)"%LABEL_SIGNATURE_METHOD_ALGORITHM"), null, null, 2060);
        this.signMethod.setItems(atkWasUiConstants.getSigningInfoSignatureMethods(false));
        this.signMethod.select(0);
        this.canonicalizationMethod = uiUtils.createText((Composite)signatureGroup, ATKWASUIPlugin.getMessage((String)"%LABEL_CANONICALIZATION_METHOD_ALGORITHM"), null, null, 2124);
        this.canonicalizationMethod.setText("http://www.w3.org/2001/10/xml-exc-c14n#");
        this.digestMethod = uiUtils.createText((Composite)signatureGroup, ATKWASUIPlugin.getMessage((String)"%LABEL_DIGEST_METHOD_ALGORITHM"), null, null, 2124);
        this.digestMethod.setText("http://www.w3.org/2000/09/xmldsig#sha1");
        this.transformAlgorithm = uiUtils.createText((Composite)signatureGroup, WSSecurityUIPlugin.getMessage("LABEL_TRANSFORM_ALGORITHM"), null, null, 2124);
        this.transformAlgorithm.setText("http://www.w3.org/2001/10/xml-exc-c14n#");
        Point size = root.computeSize(-1, -1);
        scroller.setMinSize(size);
        root.setSize(size);
        scroller.setLayoutData((Object)new GridData(1808));
        return this;
    }

    public IStatus getStatus() {
        return this.messageParts.getStatus();
    }

    public SignatureInformation getSignatureInfo() {
        this.signInfo.setCanonicalizationMethod(this.canonicalizationMethod.getText());
        this.signInfo.setDigestMethod(this.digestMethod.getText());
        this.signInfo.setKeyInfo(this.keyInfoWidget.getKeyInfo());
        this.signInfo.setSignMethod(this.signMethod.getText());
        this.signInfo.setMessageParts(this.messageParts.getMessageParts());
        this.signInfo.setTransformAlgorithm(this.transformAlgorithm.getText());
        return this.signInfo;
    }

    public void setSignatureInfo(SignatureInformation signInfo) {
        this.signInfo = signInfo;
        this.canonicalizationMethod.setText(signInfo.getCanonicalizationMethod());
        this.digestMethod.setText(signInfo.getDigestMethod());
        this.keyInfoWidget.setKeyInfo(signInfo.getKeyInfo());
        this.signMethod.setText(signInfo.getSignMethod());
        this.transformAlgorithm.setText(signInfo.getTransformAlgorithm());
        this.messageParts.setMessageParts(signInfo.getMessageParts());
    }

    public void setProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        if (facetedProject != null && WASRuntimeUtil.isWASv61Runtime((IRuntime)FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedProject.getRuntime()))) {
            this.messageParts.setKeywords(ATKWASUIConstants.getIntegrityKeywords7());
        } else {
            this.messageParts.setKeywords(ATKWASUIConstants.getIntegrityKeywords6());
        }
    }
}

