/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.widgets;

import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ClientSideAuthenticationWidget
extends SimpleWidgetDataContributor {
    private Listener statusListener_;
    private Composite parent_;
    private Combo type_;
    private Text uri_;
    private Composite compositeForLocalName_;
    private StackLayout compositeForLocalNameStackLayout;
    private Combo localNameCombo_;
    private Text localNameText_;
    private Combo callBackHandler_;
    private AuthenticationToken token_;
    private AuthenticationToken[] clientSideAuthenticationTokens;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.parent_ = parent;
        this.statusListener_ = statusListener;
        Composite composite = WSSecurityUIPlugin.getUiUtils().createComposite(this.parent_, 2);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        this.type_ = this.createComboBox(composite, ATKWASUIPlugin.getMessage((String)"%LABEL_EXT_TYPE"));
        this.type_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientSideAuthenticationWidget.this.fillValuesForSelectedToken();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ClientSideAuthenticationWidget.this.fillValuesForSelectedToken();
            }
        });
        this.uri_ = this.createText(composite, ATKWASUIPlugin.getMessage((String)"%LABEL_EXT_URI"));
        this.createControlForLocalName(composite, ATKWASUIPlugin.getMessage((String)"%LABEL_EXT_LOCALNAME"));
        this.callBackHandler_ = this.createComboBox(composite, ATKWASUIPlugin.getMessage((String)"%LABEL_CALLBACK_HANDLER_CLASSNAME"));
        return this;
    }

    private void fillValuesForSelectedToken() {
        this.token_ = this.clientSideAuthenticationTokens[this.type_.getSelectionIndex()];
        this.uri_.setText(this.token_.getTokenURI());
        this.uri_.setEditable(this.token_.isEnableURIEditing());
        this.fillLocalNameControl(this.token_.getTokenLocalNamesList());
        this.localNameText_.setEditable(this.token_.isEnableLocalNameEditing());
        this.callBackHandler_.setItems(this.token_.getCallBackHandlers());
        this.callBackHandler_.setText(this.token_.getTokenCallBackHandler());
        this.statusListener_.handleEvent(null);
    }

    private void fillLocalNameControl(String[] list) {
        if (list != null && list.length > 0) {
            this.localNameCombo_.setItems(list);
            this.localNameCombo_.setText(this.token_.getTokenLocalName());
            this.compositeForLocalNameStackLayout.topControl = this.localNameCombo_;
            this.compositeForLocalName_.layout();
        } else {
            this.localNameCombo_.setItems(new String[0]);
            this.localNameText_.setText(this.token_.getTokenLocalName());
            this.compositeForLocalNameStackLayout.topControl = this.localNameText_;
            this.compositeForLocalName_.layout();
        }
    }

    public boolean canFinish() {
        return true;
    }

    private void createControlForLocalName(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        GridData gridData = new GridData(256);
        label.setLayoutData((Object)gridData);
        this.compositeForLocalName_ = new Composite(parent, 0);
        this.compositeForLocalName_.setLayoutData((Object)new GridData(768));
        this.compositeForLocalNameStackLayout = new StackLayout();
        this.compositeForLocalName_.setLayout((Layout)this.compositeForLocalNameStackLayout);
        this.localNameCombo_ = new Combo(this.compositeForLocalName_, 2060);
        this.localNameCombo_.setLayoutData((Object)new GridData(768));
        this.localNameText_ = new Text(this.compositeForLocalName_, 2116);
        this.localNameText_.setLayoutData((Object)new GridData(768));
    }

    private Combo createComboBox(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
        Combo combo = new Combo(parent, 2060);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private Text createText(Composite parent, String message) {
        Label label = new Label(parent, 72);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
        Text text = new Text(parent, 2116);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    public AuthenticationToken getToken() {
        this.token_.setTokenCallBackHandler(this.callBackHandler_.getText());
        if (this.compositeForLocalNameStackLayout.topControl == this.localNameCombo_) {
            this.token_.setTokenLocalName(this.localNameCombo_.getText());
        } else {
            this.token_.setTokenLocalName(this.localNameText_.getText());
        }
        this.token_.setTokenURI(this.uri_.getText());
        this.token_.setValueType(this.type_.getText());
        return this.token_;
    }

    public void setSecurityTokens(AuthenticationToken[] serverSideAuthenticationTokens) {
        this.clientSideAuthenticationTokens = serverSideAuthenticationTokens;
        this.type_.removeAll();
        int i = 0;
        while (i < serverSideAuthenticationTokens.length) {
            this.type_.add(serverSideAuthenticationTokens[i].getTokenName());
            ++i;
        }
        this.type_.select(0);
        this.fillValuesForSelectedToken();
    }

    public void setToken(AuthenticationToken token_) {
        this.token_ = token_;
        this.type_.setText(token_.getTokenName());
        this.fillValuesForSelectedToken();
    }
}

