/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.tokens;

import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.security.ui.tokens.StandaloneAuthenticationToken;
import com.ibm.ast.ws.security.ui.tokens.X509AuthenticationToken;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactoryFactory;
import org.eclipse.wst.command.internal.env.core.registry.CommandRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetRegistry;

public class TokenRegistry
implements CommandRegistry {
    private static TokenRegistry instance = null;
    private Vector authenticationTokens;
    private StandaloneAuthenticationToken[] standAloneSecurityTokens;
    private AuthenticationToken[] digitalSignatureSecurityTokens;
    private DataMappingRegistry dataMappingRegistry_;
    private WidgetRegistry widgetRegistry_;
    private CanFinishRegistry canFinishRegistry_;

    public static TokenRegistry getInstance() {
        if (instance == null) {
            instance = TokenRegistry.getNewInstance();
        }
        return instance;
    }

    public static TokenRegistry getNewInstance() {
        instance = new TokenRegistry();
        instance.load();
        return instance;
    }

    private void load() {
        try {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ast.ws.security.ui.AuthenticationTokenType");
            this.authenticationTokens = new Vector();
            int i = 0;
            while (i < elements.length) {
                Object tokenObject = elements[i].createExecutableExtension("class");
                AuthenticationToken token = (AuthenticationToken)tokenObject;
                this.authenticationTokens.add(token);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StandaloneAuthenticationToken[] getStandAloneSecurityTokens() {
        if (this.standAloneSecurityTokens == null) {
            Vector tokens = new Vector();
            int i = 0;
            while (i < this.authenticationTokens.size()) {
                if (this.authenticationTokens.get(i) instanceof StandaloneAuthenticationToken) {
                    tokens.add(this.authenticationTokens.get(i));
                }
                ++i;
            }
            this.standAloneSecurityTokens = new StandaloneAuthenticationToken[tokens.size()];
            tokens.copyInto(this.standAloneSecurityTokens);
        }
        return this.standAloneSecurityTokens;
    }

    public AuthenticationToken[] getDigitalSignatureSecurityTokens() {
        if (this.digitalSignatureSecurityTokens == null) {
            Vector tokens = new Vector();
            int i = 0;
            while (i < this.authenticationTokens.size()) {
                Object aToken = this.authenticationTokens.get(i);
                if (aToken instanceof X509AuthenticationToken) {
                    tokens.add(aToken);
                }
                ++i;
            }
            this.digitalSignatureSecurityTokens = new AuthenticationToken[tokens.size()];
            tokens.copyInto(this.digitalSignatureSecurityTokens);
        }
        return this.digitalSignatureSecurityTokens;
    }

    public CommandFragmentFactoryFactory getFactoryFactory(String[] ids) {
        CommandWidgetBinding binding = null;
        String tokenType = ids[0];
        boolean serviceSide = ids[1].equals("SERVICE_SIDE");
        this.standAloneSecurityTokens = this.getStandAloneSecurityTokens();
        int i = 0;
        while (i < this.standAloneSecurityTokens.length) {
            if (this.standAloneSecurityTokens[i].getTokenName().equals(tokenType)) {
                binding = serviceSide ? this.standAloneSecurityTokens[i].getServerSideBinding() : this.standAloneSecurityTokens[i].getClientSideBinding();
                break;
            }
            ++i;
        }
        binding.registerDataMappings(this.dataMappingRegistry_);
        if (this.widgetRegistry_ != null) {
            binding.registerWidgetMappings(this.widgetRegistry_);
            binding.registerCanFinish(this.canFinishRegistry_);
        }
        return binding;
    }

    public void setDataMappingRegistry(DataMappingRegistry registry) {
        this.dataMappingRegistry_ = registry;
    }

    public void setWidgetRegistry(WidgetRegistry registry) {
        this.widgetRegistry_ = registry;
    }

    public void setCanFinishRegistry(CanFinishRegistry registry) {
        this.canFinishRegistry_ = registry;
    }
}

