/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.common;

import com.ibm.etools.webservice.was.utils.J2EEUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ServiceReferenceObject {
    public static final String EJB_MODULE = "ejbModule";
    public static final String APPCLIENT_MODULE = "appClientModule";
    public static final String WEB_MODULE = "WebContent";
    private IProject project;
    private ServiceRef serviceRef;
    private String WSDLURI;
    private String portName;

    public ServiceReferenceObject(ServiceRef ref) {
        this.serviceRef = ref;
        this.project = ProjectUtilities.getProject((EObject)this.serviceRef);
        this.WSDLURI = this.getWSDLURL(this.serviceRef);
        this.portName = this.getPortNameFromWSDL();
    }

    public IProject getClientProject() {
        return this.project;
    }

    public String getWSDLURL() {
        return this.WSDLURI;
    }

    public String getDisplayName() {
        return String.valueOf(this.project.getName()) + ": " + this.getServiceName();
    }

    public String getServiceName() {
        return this.serviceRef.getServiceRefName();
    }

    private String getWSDLURL(ServiceRef serviceImpl) {
        String moduleRoot = null;
        if (J2EEUtils.isWebProject((IProject)this.project)) {
            moduleRoot = WEB_MODULE;
        } else if (J2EEUtils.isEJBProject((IProject)this.project)) {
            moduleRoot = EJB_MODULE;
        } else if (J2EEUtils.isAppClientProject((IProject)this.project)) {
            moduleRoot = APPCLIENT_MODULE;
        }
        IPath path = this.project.getLocation().addTrailingSeparator();
        path = path.append(moduleRoot).addTrailingSeparator();
        path = path.append(serviceImpl.getWsdlFile());
        File file = new File(path.toString());
        try {
            URL url = file.toURL();
            return url.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String getPortNameFromWSDL() {
        String serviceRefLink = this.serviceRef.getServiceRefName();
        String portQnameLocalNameLink = null;
        if (serviceRefLink.lastIndexOf(47) != -1) {
            serviceRefLink = serviceRefLink.substring(serviceRefLink.lastIndexOf(47) + 1);
        }
        WebServicesParser wsParser = new WebServicesParser();
        Definition wsdlDefinition = wsParser.getWSDLDefinition(this.WSDLURI);
        Service service = (Service)wsdlDefinition.getServices().values().iterator().next();
        Port port = (Port)service.getPorts().values().iterator().next();
        portQnameLocalNameLink = port.getName();
        ArrayList wsdlServices = new ArrayList();
        wsdlServices.addAll(wsdlDefinition.getServices().values());
        int ws = 0;
        while (ws < wsdlServices.size()) {
            service = (Service)wsdlServices.get(ws);
            if (serviceRefLink.equals(service.getQName().getLocalPart())) {
                port = (Port)service.getPorts().values().iterator().next();
                portQnameLocalNameLink = port.getName();
            }
            ++ws;
        }
        return portQnameLocalNameLink;
    }

    public String getPortName() {
        return this.portName;
    }
}

