/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.security.ui.tokens.KerberosAuthenticationToken;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class TokensFilterer {
    public static AuthenticationToken[] filterToken(AuthenticationToken[] tokens, IProject targetProject) {
        Vector<AuthenticationToken> tokensVector = new Vector<AuthenticationToken>();
        int i = 0;
        while (i < tokens.length) {
            if (TokensFilterer.hasWAS7Facet(targetProject) || !(tokens[i] instanceof KerberosAuthenticationToken)) {
                tokensVector.add(tokens[i]);
            }
            ++i;
        }
        Object[] result = new AuthenticationToken[tokensVector.size()];
        tokensVector.copyInto(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasWAS7Facet(IProject targetProject) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)targetProject);
            if (facetedProject == null) return false;
            boolean websphereExtendedFacet = false;
            boolean websphereCoexistenceFacet = false;
            Iterator iterator = facetedProject.getProjectFacets().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (!websphereCoexistenceFacet || !websphereExtendedFacet) return false;
                    return true;
                }
                IProjectFacetVersion pfv = (IProjectFacetVersion)iterator.next();
                String id = pfv.getProjectFacet().getId();
                if (id.equals(IFacetConstants.EJB_EXTENDED_FACET_ID) && pfv.getVersionString().equals("7.0")) {
                    return true;
                }
                if ((id.equals(IFacetConstants.WEB_EXTENDED_FACET_ID) || id.equals(IFacetConstants.APPCLIENT_EXTENDED_FACET_ID)) && pfv.getVersionString().equals("7.0")) {
                    websphereExtendedFacet = true;
                }
                if (!id.equals(IFacetConstants.WEB_COEXISTENCE_FACET_ID) && !id.equals(IFacetConstants.APPCLIENT_COEXISTENCE_FACET_ID) || !pfv.getVersionString().equals("7.0")) continue;
                websphereCoexistenceFacet = true;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

