/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.command.TokensFilterer;
import com.ibm.ast.ws.security.ui.common.SignatureInformation;
import com.ibm.ast.ws.security.ui.common.SignedCertificateToken;
import com.ibm.ast.ws.security.ui.common.StrRefKeyInformation;
import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.security.ui.tokens.TokenRegistry;
import com.ibm.ast.ws.security.ui.tokens.X509AuthenticationToken;
import com.ibm.etools.webservice.WebServiceWASInit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SignatureDefaultingCommand
extends AbstractDataModelOperation {
    private SignatureInformation consumerSignatureInfo;
    private SignedCertificateToken tokenConsumer;
    private SignatureInformation generatorSignatureInfo;
    private SignedCertificateToken tokenGenerator;
    private AuthenticationToken[] digitalSignatureSecurityTokens;
    private IProject targetProject;
    private String defaultOrder;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        WebServiceWASInit.init();
        this.consumerSignatureInfo = new SignatureInformation();
        this.consumerSignatureInfo.setKeyInfo(new StrRefKeyInformation());
        this.consumerSignatureInfo.setUsageType("Required");
        this.tokenConsumer = new SignedCertificateToken();
        this.tokenConsumer.setToken(new X509AuthenticationToken());
        this.generatorSignatureInfo = new SignatureInformation();
        this.generatorSignatureInfo.setKeyInfo(new StrRefKeyInformation());
        this.generatorSignatureInfo.getKeyInfo().setLocatorClass("com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator");
        this.generatorSignatureInfo.setOrder(this.defaultOrder);
        this.tokenGenerator = new SignedCertificateToken();
        this.tokenGenerator.setToken(new X509AuthenticationToken());
        this.digitalSignatureSecurityTokens = TokenRegistry.getNewInstance().getDigitalSignatureSecurityTokens();
        this.digitalSignatureSecurityTokens = TokensFilterer.filterToken(this.digitalSignatureSecurityTokens, this.targetProject);
        return Status.OK_STATUS;
    }

    public void setTargetProject(IProject p) {
        this.targetProject = p;
    }

    public SignedCertificateToken getTokenConsumer() {
        return this.tokenConsumer;
    }

    public SignedCertificateToken getTokenGenerator() {
        return this.tokenGenerator;
    }

    public SignatureInformation getConsumerSignatureInfo() {
        return this.consumerSignatureInfo;
    }

    public SignatureInformation getGeneratorSignatureInfo() {
        return this.generatorSignatureInfo;
    }

    public AuthenticationToken[] getDigitalSignatureSecurityTokens() {
        return this.digitalSignatureSecurityTokens;
    }

    public void setDefaultOrder(String order) {
        this.defaultOrder = order;
    }
}

