/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.ServiceObject;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;

public class FindWebServicesCommand
extends AbstractDataModelOperation {
    private Vector services;
    private IProject selectedProject = null;
    private String selectedServiceName;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.services = new Vector();
        List service = WebServicesManager.getInstance().getAllWSDLServices();
        int i = 0;
        while (i < service.size()) {
            ServiceImpl serviceImpl = (ServiceImpl)service.get(i);
            String serviceName = serviceImpl.getQName().getLocalPart();
            IProject serviceProject = ProjectUtilities.getProject((EObject)serviceImpl);
            if ((serviceProject != this.selectedProject || !this.selectedServiceName.equals(serviceName)) && this.isSecuredWebServicesServer(serviceProject, serviceName)) {
                this.services.add(new ServiceObject(serviceImpl, serviceProject));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSecuredWebServicesServer(IProject serviceProject, String serviceName) {
        WsextArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForRead((IProject)serviceProject);
            EList wsDescExts = artifactEdit.getWsExtension().getWsDescExt();
            int i = 0;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public Vector getServices() {
        return this.services;
    }

    public void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    public void setSelectedServiceName(String serviceName) {
        this.selectedServiceName = serviceName;
    }
}

