/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.EncryptionInformation;
import com.ibm.ast.ws.security.ui.common.MessagePartItem;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseGeneratorBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestConsumerServiceConfig;
import com.ibm.etools.webservice.wsext.SecurityResponseGeneratorServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import com.ibm.etools.webservice.wsext.impl.WsextFactoryImpl;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddServerSideEncryptionCommand
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private IProject serviceProject;
    private EncryptionInformation consumerEncryptionInfo;
    private EncryptionInformation generatorEncryptionInfo;
    private IProgressMonitor monitor;
    private String wsNameLink = null;
    private String pcNameLink = null;
    private String serviceName;
    private IPath ibmWebServicesXMLPath = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject wsXmlProject = this.serviceProject;
        this.monitor = monitor;
        this.getWSDDFilePath(wsXmlProject);
        if (this.ibmWebServicesXMLPath == null) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_WEBSERVICES_XML_NOT_FOUND"), null);
        }
        try {
            this.getNamesFromWebServicesXML(wsXmlProject);
            this.updateWsBndENC(wsXmlProject);
            this.updateWsExtENC(wsXmlProject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEBSERVICES_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNamesFromWebServicesXML(IProject ddProject) {
        WSDDArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)ddProject);
            WebServices webservices = artifactEdit.getWebServices();
            EList wsDescriptions = webservices.getWebServiceDescriptions();
            if (wsDescriptions.size() < 1) {
                return;
            }
            WebServiceDescription wsDescription = null;
            int i = 0;
            while (i < wsDescriptions.size()) {
                if (((WebServiceDescription)wsDescriptions.get(i)).getWebServiceDescriptionName().equals(this.serviceName)) {
                    wsDescription = (WebServiceDescription)wsDescriptions.get(i);
                }
                ++i;
            }
            this.wsNameLink = wsDescription.getWebServiceDescriptionName();
            EList portComponents = wsDescription.getPortComponents();
            if (portComponents.size() < 1) {
                return;
            }
            PortComponent portComponent = (PortComponent)portComponents.get(0);
            this.pcNameLink = portComponent.getPortComponentName();
            return;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtENC(IProject ddProject) {
        WsextArtifactEdit artifactEdit = null;
        try {
            SecurityRequestConsumerServiceConfig secReqConServiceConfig;
            artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ddProject);
            WsExtension wsext = artifactEdit.getWsExtension();
            WsextFactoryImpl wsextfactory = new WsextFactoryImpl();
            WsDescExt wsDescExt = null;
            PcBinding pcBinding = null;
            EList wsDescExts = wsext.getWsDescExt();
            int i = 0;
            while (i < wsDescExts.size()) {
                WsDescExt tmpWsDescExt = (WsDescExt)wsDescExts.get(i);
                if (tmpWsDescExt.getWsDescNameLink() != null && tmpWsDescExt.getWsDescNameLink().equals(this.wsNameLink)) {
                    wsDescExt = tmpWsDescExt;
                    break;
                }
                ++i;
            }
            if (wsDescExt == null) {
                wsDescExt = wsextfactory.createWsDescExt();
                wsDescExt.setWsDescNameLink(this.wsNameLink);
                wsext.getWsDescExt().add((Object)wsDescExt);
            }
            EList pcBnds = wsDescExt.getPcBinding();
            int i2 = 0;
            while (i2 < pcBnds.size()) {
                PcBinding pcBnd = (PcBinding)pcBnds.get(i2);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.pcNameLink)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++i2;
            }
            if (pcBinding == null) {
                pcBinding = wsextfactory.createPcBinding();
                pcBinding.setPcNameLink(this.pcNameLink);
                wsDescExt.getPcBinding().add((Object)pcBinding);
            }
            WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
            ServerServiceConfig serverserviceconfig = pcBinding.getServerServiceConfig();
            if (serverserviceconfig == null) {
                serverserviceconfig = wsextfactory.createServerServiceConfig();
                pcBinding.setServerServiceConfig(serverserviceconfig);
            }
            if ((secReqConServiceConfig = serverserviceconfig.getSecurityRequestConsumerServiceConfig()) == null) {
                secReqConServiceConfig = wsextfactory.createSecurityRequestConsumerServiceConfig();
                serverserviceconfig.setSecurityRequestConsumerServiceConfig(secReqConServiceConfig);
            }
            RequiredConfidentiality requiredConfidentiality = wscommonextfactory.createRequiredConfidentiality();
            requiredConfidentiality.setName(this.consumerEncryptionInfo.getId());
            requiredConfidentiality.setUsage(UsageType.get((String)this.consumerEncryptionInfo.getUsageType()));
            Vector parts = this.consumerEncryptionInfo.getMessageParts();
            int i3 = 0;
            while (i3 < parts.size()) {
                MessageParts messagePart = wscommonextfactory.createMessageParts();
                MessagePartItem item = (MessagePartItem)parts.get(i3);
                messagePart.setDialect(item.getDialect());
                messagePart.setKeyword(item.getKeyword());
                requiredConfidentiality.getMessageParts().add((Object)messagePart);
                ++i3;
            }
            secReqConServiceConfig.getRequiredConfidentiality().add((Object)requiredConfidentiality);
            SecurityResponseGeneratorServiceConfig secResGenServiceConfig = serverserviceconfig.getSecurityResponseGeneratorServiceConfig();
            if (secResGenServiceConfig == null) {
                secResGenServiceConfig = wsextfactory.createSecurityResponseGeneratorServiceConfig();
                serverserviceconfig.setSecurityResponseGeneratorServiceConfig(secResGenServiceConfig);
            }
            Confidentiality confidentiality = wscommonextfactory.createConfidentiality();
            confidentiality.setName(this.generatorEncryptionInfo.getId());
            confidentiality.setOrder(this.generatorEncryptionInfo.getOrder());
            parts = this.generatorEncryptionInfo.getMessageParts();
            int i4 = 0;
            while (i4 < parts.size()) {
                MessageParts messagePart = wscommonextfactory.createMessageParts();
                MessagePartItem item = (MessagePartItem)parts.get(i4);
                messagePart.setDialect(item.getDialect());
                messagePart.setKeyword(item.getKeyword());
                confidentiality.getMessageParts().add((Object)messagePart);
                ++i4;
            }
            secResGenServiceConfig.getConfidentiality().add((Object)confidentiality);
            artifactEdit.saveIfNecessary(this.monitor);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsBndENC(IProject ddProject) {
        WsbndArtifactEdit artifactEdit = null;
        try {
            artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ddProject);
            WSBinding wsbnd = artifactEdit.getWSBinding();
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            WSDescBinding wsDescBinding = null;
            PCBinding pcBinding = null;
            EList wscbindings = wsbnd.getWsdescBindings();
            int i = 0;
            while (i < wscbindings.size()) {
                WSDescBinding wsDscBnd = (WSDescBinding)wscbindings.get(i);
                if (wsDscBnd.getWsDescNameLink() != null && wsDscBnd.getWsDescNameLink().equals(this.wsNameLink)) {
                    wsDescBinding = wsDscBnd;
                    break;
                }
                ++i;
            }
            if (wsDescBinding == null) {
                wsDescBinding = wsbndfactory.createWSDescBinding();
                wsDescBinding.setWsDescNameLink(this.wsNameLink);
                wsbnd.getWsdescBindings().add((Object)wsDescBinding);
            }
            EList pcBindings = wsDescBinding.getPcBindings();
            int j = 0;
            while (j < pcBindings.size()) {
                PCBinding pcBnd = (PCBinding)pcBindings.get(j);
                if (pcBnd.getPcNameLink() != null && pcBnd.getPcNameLink().equals(this.pcNameLink)) {
                    pcBinding = pcBnd;
                    break;
                }
                ++j;
            }
            if (pcBinding == null) {
                pcBinding = wsbndfactory.createPCBinding();
                pcBinding.setPcNameLink(this.pcNameLink);
                wsDescBinding.getPcBindings().add((Object)pcBinding);
            }
            WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
            SecurityRequestConsumerBindingConfig secReqConBndConfig = pcBinding.getSecurityRequestConsumerBindingConfig();
            if (secReqConBndConfig == null) {
                secReqConBndConfig = wsbndfactory.createSecurityRequestConsumerBindingConfig();
                pcBinding.setSecurityRequestConsumerBindingConfig(secReqConBndConfig);
            }
            EncryptionInfo encryptionInfo = wscommonbndfactory.createEncryptionInfo();
            encryptionInfo.setName("RequestConsumerEncryptInfo" + System.currentTimeMillis());
            DataEncryptionMethod encryptionMethod = wscommonbndfactory.createDataEncryptionMethod();
            encryptionMethod.setAlgorithm(this.consumerEncryptionInfo.getDataEncryptionMethod());
            encryptionInfo.setEncryptionMethod(encryptionMethod);
            String keyMethod = this.consumerEncryptionInfo.getKeyEncryptionMethod();
            if (keyMethod != null && !keyMethod.equals(ATKWASUIPlugin.getMessage((String)"%ENCRYPTION_INFO_KEY_ENCRYPTION_NONE"))) {
                KeyEncryptionMethod keyEncryptionMethod = wscommonbndfactory.createKeyEncryptionMethod();
                keyEncryptionMethod.setAlgorithm(keyMethod);
                encryptionInfo.setKeyEncryptionMethod(keyEncryptionMethod);
            }
            EncryptionKeyInfo encryptionKeyInfo = wscommonbndfactory.createEncryptionKeyInfo();
            encryptionKeyInfo.setKeyinfoRef(this.consumerEncryptionInfo.getKeyInfo().getId());
            encryptionInfo.getEncryptionKeyInfo().add((Object)encryptionKeyInfo);
            PartReference partReference = wscommonbndfactory.createPartReference();
            partReference.setPart(this.consumerEncryptionInfo.getId());
            encryptionInfo.setPartReference(partReference);
            secReqConBndConfig.getEncryptionInfo().add((Object)encryptionInfo);
            KeyInfo keyInfo = wscommonbndfactory.createKeyInfo();
            keyInfo.setName(this.consumerEncryptionInfo.getKeyInfo().getId());
            keyInfo.setType(this.consumerEncryptionInfo.getKeyInfo().getType());
            keyInfo.setClassname(this.consumerEncryptionInfo.getKeyInfo().getConsumerClassName());
            KeyLocatorMapping keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
            keyLocatorMapping.setLocatorRef(this.consumerEncryptionInfo.getKeyInfo().getId());
            keyLocatorMapping.setKeynameRef(this.consumerEncryptionInfo.getKeyStore().getKeyName());
            keyInfo.setKeyLocatorMapping(keyLocatorMapping);
            secReqConBndConfig.getKeyInfo().add((Object)keyInfo);
            KeyLocator keyLocator = wscommonbndfactory.createKeyLocator();
            keyLocator.setName(this.consumerEncryptionInfo.getKeyInfo().getId());
            keyLocator.setClassname(this.consumerEncryptionInfo.getKeyInfo().getLocatorClass());
            KeyStore keyStore = wscommonbndfactory.createKeyStore();
            keyStore.setStorepass(this.consumerEncryptionInfo.getKeyStore().getKeyStoreStorePass());
            keyStore.setPath(this.consumerEncryptionInfo.getKeyStore().getKeyStorePath());
            keyStore.setType(this.consumerEncryptionInfo.getKeyStore().getKeyStoreType());
            keyLocator.setKeyStore(keyStore);
            Key key = wscommonbndfactory.createKey();
            key.setAlias(this.consumerEncryptionInfo.getKeyStore().getKeyAlias());
            key.setKeypass(this.consumerEncryptionInfo.getKeyStore().getKeyPass());
            key.setName(this.consumerEncryptionInfo.getKeyStore().getKeyName());
            keyLocator.getKeys().add((Object)key);
            secReqConBndConfig.getKeyLocator().add((Object)keyLocator);
            SecurityResponseGeneratorBindingConfig secResGenBndConfig = pcBinding.getSecurityResponseGeneratorBindingConfig();
            if (secResGenBndConfig == null) {
                secResGenBndConfig = wsbndfactory.createSecurityResponseGeneratorBindingConfig();
                pcBinding.setSecurityResponseGeneratorBindingConfig(secResGenBndConfig);
            }
            encryptionInfo = wscommonbndfactory.createEncryptionInfo();
            encryptionInfo.setName("ResponseGeneratorEncryptInfo" + System.currentTimeMillis());
            encryptionMethod = wscommonbndfactory.createDataEncryptionMethod();
            encryptionMethod.setAlgorithm(this.generatorEncryptionInfo.getDataEncryptionMethod());
            encryptionInfo.setEncryptionMethod(encryptionMethod);
            keyMethod = this.generatorEncryptionInfo.getKeyEncryptionMethod();
            if (keyMethod != null && !keyMethod.equals(ATKWASUIPlugin.getMessage((String)"%ENCRYPTION_INFO_KEY_ENCRYPTION_NONE"))) {
                KeyEncryptionMethod keyEncryptionMethod = wscommonbndfactory.createKeyEncryptionMethod();
                keyEncryptionMethod.setAlgorithm(keyMethod);
                encryptionInfo.setKeyEncryptionMethod(keyEncryptionMethod);
            }
            encryptionKeyInfo = wscommonbndfactory.createEncryptionKeyInfo();
            encryptionKeyInfo.setKeyinfoRef(this.generatorEncryptionInfo.getKeyInfo().getId());
            encryptionInfo.getEncryptionKeyInfo().add((Object)encryptionKeyInfo);
            partReference = wscommonbndfactory.createPartReference();
            partReference.setPart(this.generatorEncryptionInfo.getId());
            encryptionInfo.setPartReference(partReference);
            secResGenBndConfig.getEncryptionInfo().add((Object)encryptionInfo);
            keyInfo = wscommonbndfactory.createKeyInfo();
            keyInfo.setName(this.generatorEncryptionInfo.getKeyInfo().getId());
            keyInfo.setType(this.generatorEncryptionInfo.getKeyInfo().getType());
            keyInfo.setClassname(this.generatorEncryptionInfo.getKeyInfo().getGeneratorClassName());
            keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
            keyLocatorMapping.setLocatorRef(this.generatorEncryptionInfo.getKeyInfo().getId());
            keyLocatorMapping.setKeynameRef(this.generatorEncryptionInfo.getKeyStore().getKeyName());
            keyInfo.setKeyLocatorMapping(keyLocatorMapping);
            secResGenBndConfig.getKeyInfo().add((Object)keyInfo);
            keyLocator = wscommonbndfactory.createKeyLocator();
            keyLocator.setName(this.generatorEncryptionInfo.getKeyInfo().getId());
            keyLocator.setClassname(this.generatorEncryptionInfo.getKeyInfo().getLocatorClass());
            keyStore = wscommonbndfactory.createKeyStore();
            keyStore.setStorepass(this.generatorEncryptionInfo.getKeyStore().getKeyStoreStorePass());
            keyStore.setPath(this.generatorEncryptionInfo.getKeyStore().getKeyStorePath());
            keyStore.setType(this.generatorEncryptionInfo.getKeyStore().getKeyStoreType());
            keyLocator.setKeyStore(keyStore);
            key = wscommonbndfactory.createKey();
            key.setAlias(this.generatorEncryptionInfo.getKeyStore().getKeyAlias());
            key.setKeypass(this.generatorEncryptionInfo.getKeyStore().getKeyPass());
            key.setName(this.generatorEncryptionInfo.getKeyStore().getKeyName());
            keyLocator.getKeys().add((Object)key);
            secResGenBndConfig.getKeyLocator().add((Object)keyLocator);
            artifactEdit.saveIfNecessary(this.monitor);
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = component.getRootFolder().getFolder("WEB-INF");
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = component.getRootFolder().getFolder("META-INF");
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.ibmWebServicesXMLPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setConsumerEncryptionInfo(EncryptionInformation consumerEncryptionInfo) {
        this.consumerEncryptionInfo = consumerEncryptionInfo;
    }

    public void setGeneratorEncryptionInfo(EncryptionInformation generatorEncryptionInfo) {
        this.generatorEncryptionInfo = generatorEncryptionInfo;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

