/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.MessagePartItem;
import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.common.SignatureInformation;
import com.ibm.ast.ws.security.ui.common.SignedCertificateToken;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.impl.WscbndFactoryImpl;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscext.impl.WscextFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.JAASConfig;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddClientSideSignatureCommand
extends AbstractDataModelOperation {
    private IProgressMonitor monitor;
    private ServiceReferenceObject serviceReference;
    private SignatureInformation generatorSignatureInfo;
    private SignatureInformation consumerSignatureInfo;
    private SignedCertificateToken tokenGenerator;
    private SignedCertificateToken tokenConsumer;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.monitor = monitor;
        try {
            this.updateWsBndSIG();
            this.updateWsExtSIG();
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void updateWsBndSIG() throws IOException {
        WscbndArtifactEdit artifactEdit = null;
        try {
            try {
                CertPathSettings certPathSettings;
                artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                ClientBinding wscbnd = artifactEdit.getClientBinding();
                WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();
                ServiceRef serviceRef = null;
                PortQnameBinding portQNameBinding = null;
                EList serviceRefs = wscbnd.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
                    if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = serRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscbndfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int j = 0;
                while (j < portQnameBindings.size()) {
                    PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQNameBinding = pqBnd;
                        break;
                    }
                    ++j;
                }
                if (portQNameBinding == null) {
                    portQNameBinding = wscbndfactory.createPortQnameBinding();
                    portQNameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQNameBinding);
                }
                WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
                SecurityRequestGeneratorBindingConfig secReqGenBndConfig = portQNameBinding.getSecurityRequestGeneratorBindingConfig();
                if (secReqGenBndConfig == null) {
                    secReqGenBndConfig = wscbndfactory.createSecurityRequestGeneratorBindingConfig();
                    portQNameBinding.setSecurityRequestGeneratorBindingConfig(secReqGenBndConfig);
                }
                SigningInfo signingInfo = wscommonbndfactory.createSigningInfo();
                signingInfo.setName("RequestGeneratorSigningInfo" + System.currentTimeMillis());
                SignatureMethod signatureMethod = wscommonbndfactory.createSignatureMethod();
                signatureMethod.setAlgorithm(this.generatorSignatureInfo.getSignMethod());
                signingInfo.setSignatureMethod(signatureMethod);
                CanonicalizationMethod canonicalizationMethod = wscommonbndfactory.createCanonicalizationMethod();
                canonicalizationMethod.setAlgorithm(this.generatorSignatureInfo.getCanonicalizationMethod());
                signingInfo.setCanonicalizationMethod(canonicalizationMethod);
                PartReference partReference = wscommonbndfactory.createPartReference();
                partReference.setName("RequestGeneratorSignaturePartRef" + System.currentTimeMillis());
                partReference.setPart(this.generatorSignatureInfo.getId());
                Transform transform = wscommonbndfactory.createTransform();
                transform.setName("RequestGeneratorSignatureTransform" + System.currentTimeMillis());
                transform.setAlgorithm(this.generatorSignatureInfo.getTransformAlgorithm());
                partReference.getTransform().add((Object)transform);
                DigestMethod digestMethod = wscommonbndfactory.createDigestMethod();
                digestMethod.setAlgorithm(this.generatorSignatureInfo.getDigestMethod());
                partReference.setDigestMethod(digestMethod);
                signingInfo.getPartReference().add((Object)partReference);
                SigningKeyInfo signingKeyInfo = wscommonbndfactory.createSigningKeyInfo();
                signingKeyInfo.setKeyinfoRef(this.generatorSignatureInfo.getKeyInfo().getId());
                signingInfo.getSigningKeyInfo().add((Object)signingKeyInfo);
                secReqGenBndConfig.getSigningInfo().add((Object)signingInfo);
                KeyInfo keyInfo = wscommonbndfactory.createKeyInfo();
                keyInfo.setName(this.generatorSignatureInfo.getKeyInfo().getId());
                keyInfo.setType(this.generatorSignatureInfo.getKeyInfo().getType());
                keyInfo.setClassname(this.generatorSignatureInfo.getKeyInfo().getGeneratorClassName());
                KeyLocatorMapping keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
                keyLocatorMapping.setLocatorRef(this.tokenGenerator.getKeyStore().getId());
                if (this.tokenGenerator.getKeyStore().getKey() != null) {
                    keyLocatorMapping.setKeynameRef(this.tokenGenerator.getKeyStore().getKeyName());
                }
                keyInfo.setKeyLocatorMapping(keyLocatorMapping);
                TokenReference tokenReference = wscommonbndfactory.createTokenReference();
                tokenReference.setTokenRef(this.tokenGenerator.getToken().getId());
                keyInfo.setTokenReference(tokenReference);
                secReqGenBndConfig.getKeyInfo().add((Object)keyInfo);
                KeyLocator keyLocator = wscommonbndfactory.createKeyLocator();
                keyLocator.setName(this.tokenGenerator.getKeyStore().getId());
                keyLocator.setClassname(this.generatorSignatureInfo.getKeyInfo().getLocatorClass());
                KeyStore keyStore = wscommonbndfactory.createKeyStore();
                keyStore.setStorepass(this.tokenGenerator.getKeyStore().getKeyStoreStorePass());
                keyStore.setPath(this.tokenGenerator.getKeyStore().getKeyStorePath());
                keyStore.setType(this.tokenGenerator.getKeyStore().getKeyStoreType());
                keyLocator.setKeyStore(keyStore);
                if (this.tokenGenerator.getKeyStore().getKey() != null) {
                    Key key = wscommonbndfactory.createKey();
                    key.setAlias(this.tokenGenerator.getKeyStore().getKeyAlias());
                    key.setKeypass(this.tokenGenerator.getKeyStore().getKeyPass());
                    key.setName(this.tokenGenerator.getKeyStore().getKeyName());
                    keyLocator.getKeys().add((Object)key);
                }
                secReqGenBndConfig.getKeyLocator().add((Object)keyLocator);
                TokenGenerator tokenGeneratorModel = wscommonbndfactory.createTokenGenerator();
                tokenGeneratorModel.setName(this.tokenGenerator.getToken().getId());
                tokenGeneratorModel.setClassname(this.tokenGenerator.getToken().getGeneratorClassName());
                ValueType valueType = wscommonbndfactory.createValueType();
                valueType.setLocalName(this.tokenGenerator.getToken().getTokenLocalName());
                valueType.setUri(this.tokenGenerator.getToken().getTokenURI());
                valueType.setName(this.tokenGenerator.getToken().getValueType());
                tokenGeneratorModel.setValueType(valueType);
                CallbackHandler callbackHandler = wscommonbndfactory.createCallbackHandler();
                callbackHandler.setClassname(this.tokenGenerator.getToken().getTokenCallBackHandler());
                keyStore = wscommonbndfactory.createKeyStore();
                keyStore.setStorepass(this.tokenGenerator.getKeyStore().getKeyStoreStorePass());
                keyStore.setPath(this.tokenGenerator.getKeyStore().getKeyStorePath());
                keyStore.setType(this.tokenGenerator.getKeyStore().getKeyStoreType());
                callbackHandler.setKeyStore(keyStore);
                if (this.tokenGenerator.getKeyStore().getKey() != null) {
                    Key key = wscommonbndfactory.createKey();
                    key.setAlias(this.tokenGenerator.getKeyStore().getKeyAlias());
                    key.setKeypass(this.tokenGenerator.getKeyStore().getKeyPass());
                    key.setName(this.tokenGenerator.getKeyStore().getKeyName());
                    callbackHandler.getKey().add((Object)key);
                }
                tokenGeneratorModel.setCallbackHandler(callbackHandler);
                if (this.tokenGenerator.getCertificate() != null) {
                    CertStoreList certStoreList = wscommonbndfactory.createCertStoreList();
                    CollectionCertStore collectionCertStore = wscommonbndfactory.createCollectionCertStore();
                    collectionCertStore.setName(this.tokenGenerator.getCertificate().getCertName());
                    collectionCertStore.setProvider(this.tokenGenerator.getCertificate().getProvider());
                    X509Certificate x509Certificate = wscommonbndfactory.createX509Certificate();
                    x509Certificate.setPath(this.tokenGenerator.getCertificate().getPath());
                    collectionCertStore.getX509Certificates().add((Object)x509Certificate);
                    certStoreList.getCollectionCertStores().add((Object)collectionCertStore);
                    secReqGenBndConfig.setCertStoreList(certStoreList);
                    certPathSettings = wscommonbndfactory.createCertPathSettings();
                    CertStoreRef certStoreRef = wscommonbndfactory.createCertStoreRef();
                    certStoreRef.setRef(this.tokenGenerator.getCertificate().getCertName());
                    certPathSettings.setCertStoreRef(certStoreRef);
                    tokenGeneratorModel.setCertPathSettings(certPathSettings);
                }
                secReqGenBndConfig.getTokenGenerator().add((Object)tokenGeneratorModel);
                SecurityResponseConsumerBindingConfig secResConBndConfig = portQNameBinding.getSecurityResponseConsumerBindingConfig();
                if (secResConBndConfig == null) {
                    secResConBndConfig = wscbndfactory.createSecurityResponseConsumerBindingConfig();
                    portQNameBinding.setSecurityResponseConsumerBindingConfig(secResConBndConfig);
                }
                signingInfo = wscommonbndfactory.createSigningInfo();
                signingInfo.setName("ResponseConsumerSigningInfo" + System.currentTimeMillis());
                signatureMethod = wscommonbndfactory.createSignatureMethod();
                signatureMethod.setAlgorithm(this.consumerSignatureInfo.getSignMethod());
                signingInfo.setSignatureMethod(signatureMethod);
                canonicalizationMethod = wscommonbndfactory.createCanonicalizationMethod();
                canonicalizationMethod.setAlgorithm(this.consumerSignatureInfo.getCanonicalizationMethod());
                signingInfo.setCanonicalizationMethod(canonicalizationMethod);
                partReference = wscommonbndfactory.createPartReference();
                partReference.setName("ResponseConsumerSignaturePartRef" + System.currentTimeMillis());
                partReference.setPart(this.consumerSignatureInfo.getId());
                transform = wscommonbndfactory.createTransform();
                transform.setName("ResponseConsumerSignatureTransform" + System.currentTimeMillis());
                transform.setAlgorithm(this.consumerSignatureInfo.getTransformAlgorithm());
                partReference.getTransform().add((Object)transform);
                digestMethod = wscommonbndfactory.createDigestMethod();
                digestMethod.setAlgorithm(this.consumerSignatureInfo.getDigestMethod());
                partReference.setDigestMethod(digestMethod);
                signingInfo.getPartReference().add((Object)partReference);
                signingKeyInfo = wscommonbndfactory.createSigningKeyInfo();
                signingKeyInfo.setKeyinfoRef(this.consumerSignatureInfo.getKeyInfo().getId());
                signingInfo.getSigningKeyInfo().add((Object)signingKeyInfo);
                secResConBndConfig.getSigningInfo().add((Object)signingInfo);
                keyInfo = wscommonbndfactory.createKeyInfo();
                keyInfo.setName(this.consumerSignatureInfo.getKeyInfo().getId());
                keyInfo.setType(this.consumerSignatureInfo.getKeyInfo().getType());
                keyInfo.setClassname(this.consumerSignatureInfo.getKeyInfo().getConsumerClassName());
                keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
                keyLocatorMapping.setLocatorRef(this.consumerSignatureInfo.getKeyInfo().getId());
                keyInfo.setKeyLocatorMapping(keyLocatorMapping);
                tokenReference = wscommonbndfactory.createTokenReference();
                tokenReference.setTokenRef(this.tokenConsumer.getToken().getId());
                keyInfo.setTokenReference(tokenReference);
                secResConBndConfig.getKeyInfo().add((Object)keyInfo);
                keyLocator = wscommonbndfactory.createKeyLocator();
                keyLocator.setName(this.consumerSignatureInfo.getKeyInfo().getId());
                keyLocator.setClassname(this.consumerSignatureInfo.getKeyInfo().getLocatorClass());
                secResConBndConfig.getKeyLocator().add((Object)keyLocator);
                TokenConsumer tokenConsumerModel = wscommonbndfactory.createTokenConsumer();
                tokenConsumerModel.setName(this.tokenConsumer.getToken().getId());
                tokenConsumerModel.setClassname(this.tokenConsumer.getToken().getConsumerClassName());
                valueType = wscommonbndfactory.createValueType();
                valueType.setLocalName(this.tokenConsumer.getToken().getTokenLocalName());
                valueType.setUri(this.tokenConsumer.getToken().getTokenURI());
                valueType.setName(this.tokenConsumer.getToken().getValueType());
                tokenConsumerModel.setValueType(valueType);
                JAASConfig jAASConfig = wscommonbndfactory.createJAASConfig();
                jAASConfig.setConfigName(this.tokenConsumer.getToken().getJAASConfigName());
                tokenConsumerModel.setJAASConfig(jAASConfig);
                certPathSettings = wscommonbndfactory.createCertPathSettings();
                if (this.tokenConsumer.getKeyStore() == null) {
                    TrustAnyCertificate trustAnyCertificate = wscommonbndfactory.createTrustAnyCertificate();
                    certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
                } else {
                    TrustAnchor trustAnchor = wscommonbndfactory.createTrustAnchor();
                    trustAnchor.setName(this.tokenConsumer.getTrustAnchor());
                    keyStore = wscommonbndfactory.createKeyStore();
                    keyStore.setStorepass(this.tokenConsumer.getKeyStore().getKeyStoreStorePass());
                    keyStore.setPath(this.tokenConsumer.getKeyStore().getKeyStorePath());
                    keyStore.setType(this.tokenConsumer.getKeyStore().getKeyStoreType());
                    trustAnchor.setKeyStore(keyStore);
                    secResConBndConfig.getTrustAnchor().add((Object)trustAnchor);
                    TrustAnchorRef trustAnchorRef = wscommonbndfactory.createTrustAnchorRef();
                    trustAnchorRef.setRef(this.tokenConsumer.getTrustAnchor());
                    certPathSettings.setTrustAnchorRef(trustAnchorRef);
                    if (this.tokenConsumer.getCertificate() != null) {
                        CertStoreList certStoreList = wscommonbndfactory.createCertStoreList();
                        CollectionCertStore collectionCertStore = wscommonbndfactory.createCollectionCertStore();
                        collectionCertStore.setName(this.tokenConsumer.getCertificate().getCertName());
                        collectionCertStore.setProvider(this.tokenConsumer.getCertificate().getProvider());
                        X509Certificate x509Certificate = wscommonbndfactory.createX509Certificate();
                        x509Certificate.setPath(this.tokenConsumer.getCertificate().getPath());
                        collectionCertStore.getX509Certificates().add((Object)x509Certificate);
                        certStoreList.getCollectionCertStores().add((Object)collectionCertStore);
                        secResConBndConfig.setCertStoreList(certStoreList);
                        CertStoreRef certStoreRef = wscommonbndfactory.createCertStoreRef();
                        certStoreRef.setRef(this.tokenConsumer.getCertificate().getCertName());
                        certPathSettings.setCertStoreRef(certStoreRef);
                    }
                }
                tokenConsumerModel.setCertPathSettings(certPathSettings);
                secResConBndConfig.getTokenConsumer().add((Object)tokenConsumerModel);
                artifactEdit.saveIfNecessary(this.monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtSIG() throws IOException {
        WscextArtifactEdit artifactEdit = null;
        try {
            try {
                SecurityRequestGeneratorServiceConfig secReqGenServiceConfig;
                artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                WsClientExtension wscext = artifactEdit.getWsClientExtension();
                WscextFactoryImpl wscextfactory = new WscextFactoryImpl();
                com.ibm.etools.webservice.wscext.ServiceRef serviceRef = null;
                com.ibm.etools.webservice.wscext.PortQnameBinding portQnameBinding = null;
                EList serviceRefs = wscext.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    com.ibm.etools.webservice.wscext.ServiceRef tmpSerRef = (com.ibm.etools.webservice.wscext.ServiceRef)serviceRefs.get(i);
                    if (tmpSerRef.getServiceRefLink() != null && tmpSerRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = tmpSerRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscextfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int i2 = 0;
                while (i2 < portQnameBindings.size()) {
                    com.ibm.etools.webservice.wscext.PortQnameBinding pqBnd = (com.ibm.etools.webservice.wscext.PortQnameBinding)portQnameBindings.get(i2);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQnameBinding = pqBnd;
                        break;
                    }
                    ++i2;
                }
                if (portQnameBinding == null) {
                    portQnameBinding = wscextfactory.createPortQnameBinding();
                    portQnameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQnameBinding);
                }
                WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
                ClientServiceConfig clientServiceconfig = portQnameBinding.getClientServiceConfig();
                if (clientServiceconfig == null) {
                    clientServiceconfig = wscextfactory.createClientServiceConfig();
                    portQnameBinding.setClientServiceConfig(clientServiceconfig);
                }
                if ((secReqGenServiceConfig = clientServiceconfig.getSecurityRequestGeneratorServiceConfig()) == null) {
                    secReqGenServiceConfig = wscextfactory.createSecurityRequestGeneratorServiceConfig();
                    clientServiceconfig.setSecurityRequestGeneratorServiceConfig(secReqGenServiceConfig);
                }
                Integrity confidentiality = wscommonextfactory.createIntegrity();
                confidentiality.setName(this.generatorSignatureInfo.getId());
                confidentiality.setOrder(this.generatorSignatureInfo.getOrder());
                Vector parts = this.generatorSignatureInfo.getMessageParts();
                int i3 = 0;
                while (i3 < parts.size()) {
                    MessageParts messagePart = wscommonextfactory.createMessageParts();
                    MessagePartItem item = (MessagePartItem)parts.get(i3);
                    messagePart.setDialect(item.getDialect());
                    messagePart.setKeyword(item.getKeyword());
                    confidentiality.getMessageParts().add((Object)messagePart);
                    ++i3;
                }
                secReqGenServiceConfig.getIntegrity().add((Object)confidentiality);
                SecurityResponseConsumerServiceConfig secResConServiceConfig = clientServiceconfig.getSecurityResponseConsumerServiceConfig();
                if (secResConServiceConfig == null) {
                    secResConServiceConfig = wscextfactory.createSecurityResponseConsumerServiceConfig();
                    clientServiceconfig.setSecurityResponseConsumerServiceConfig(secResConServiceConfig);
                }
                RequiredIntegrity requiredIntegrity = wscommonextfactory.createRequiredIntegrity();
                requiredIntegrity.setName(this.consumerSignatureInfo.getId());
                requiredIntegrity.setUsage(UsageType.get((String)this.consumerSignatureInfo.getUsageType()));
                parts = this.consumerSignatureInfo.getMessageParts();
                int i4 = 0;
                while (i4 < parts.size()) {
                    MessageParts messagePart = wscommonextfactory.createMessageParts();
                    MessagePartItem item = (MessagePartItem)parts.get(i4);
                    messagePart.setDialect(item.getDialect());
                    messagePart.setKeyword(item.getKeyword());
                    requiredIntegrity.getMessageParts().add((Object)messagePart);
                    ++i4;
                }
                secResConServiceConfig.getRequiredIntegrity().add((Object)requiredIntegrity);
                artifactEdit.saveIfNecessary(this.monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public void setConsumerSignatureInfo(SignatureInformation consumerSignatureInfo) {
        this.consumerSignatureInfo = consumerSignatureInfo;
    }

    public void setGeneratorSignatureInfo(SignatureInformation generatorSignatureInfo) {
        this.generatorSignatureInfo = generatorSignatureInfo;
    }

    public void setTokenConsumer(SignedCertificateToken tokenConsumer) {
        this.tokenConsumer = tokenConsumer;
    }

    public void setTokenGenerator(SignedCertificateToken tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setServiceReference(ServiceReferenceObject serviceReference) {
        this.serviceReference = serviceReference;
    }
}

