/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.EncryptionInformation;
import com.ibm.ast.ws.security.ui.common.MessagePartItem;
import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.impl.WscbndFactoryImpl;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscext.impl.WscextFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKeyInfo;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.UsageType;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddClientSideEncryptionCommand
extends AbstractDataModelOperation {
    private EncryptionInformation generatorEncryptionInfo;
    private EncryptionInformation consumerEncryptionInfo;
    private IProgressMonitor monitor;
    private ServiceReferenceObject serviceReference;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.monitor = monitor;
        try {
            this.updateWsBndENC();
            this.updateWsExtENC();
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void updateWsBndENC() throws IOException {
        WscbndArtifactEdit artifactEdit = null;
        try {
            try {
                artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                ClientBinding wscbnd = artifactEdit.getClientBinding();
                WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();
                ServiceRef serviceRef = null;
                PortQnameBinding portQNameBinding = null;
                EList serviceRefs = wscbnd.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
                    if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = serRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscbndfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int j = 0;
                while (j < portQnameBindings.size()) {
                    PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQNameBinding = pqBnd;
                        break;
                    }
                    ++j;
                }
                if (portQNameBinding == null) {
                    portQNameBinding = wscbndfactory.createPortQnameBinding();
                    portQNameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQNameBinding);
                }
                WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
                SecurityRequestGeneratorBindingConfig secReqGenBndConfig = portQNameBinding.getSecurityRequestGeneratorBindingConfig();
                if (secReqGenBndConfig == null) {
                    secReqGenBndConfig = wscbndfactory.createSecurityRequestGeneratorBindingConfig();
                    portQNameBinding.setSecurityRequestGeneratorBindingConfig(secReqGenBndConfig);
                }
                EncryptionInfo encryptionInfo = wscommonbndfactory.createEncryptionInfo();
                encryptionInfo.setName("RequestGeneratorEncryptInfo" + System.currentTimeMillis());
                DataEncryptionMethod encryptionMethod = wscommonbndfactory.createDataEncryptionMethod();
                encryptionMethod.setAlgorithm(this.generatorEncryptionInfo.getDataEncryptionMethod());
                encryptionInfo.setEncryptionMethod(encryptionMethod);
                String keyMethod = this.generatorEncryptionInfo.getKeyEncryptionMethod();
                if (keyMethod != null && !keyMethod.equals(ATKWASUIPlugin.getMessage((String)"%ENCRYPTION_INFO_KEY_ENCRYPTION_NONE"))) {
                    KeyEncryptionMethod keyEncryptionMethod = wscommonbndfactory.createKeyEncryptionMethod();
                    keyEncryptionMethod.setAlgorithm(keyMethod);
                    encryptionInfo.setKeyEncryptionMethod(keyEncryptionMethod);
                }
                EncryptionKeyInfo encryptionKeyInfo = wscommonbndfactory.createEncryptionKeyInfo();
                encryptionKeyInfo.setKeyinfoRef(this.generatorEncryptionInfo.getKeyInfo().getId());
                encryptionInfo.getEncryptionKeyInfo().add((Object)encryptionKeyInfo);
                PartReference partReference = wscommonbndfactory.createPartReference();
                partReference.setPart(this.generatorEncryptionInfo.getId());
                encryptionInfo.setPartReference(partReference);
                secReqGenBndConfig.getEncryptionInfo().add((Object)encryptionInfo);
                KeyInfo keyInfo = wscommonbndfactory.createKeyInfo();
                keyInfo.setName(this.generatorEncryptionInfo.getKeyInfo().getId());
                keyInfo.setType(this.generatorEncryptionInfo.getKeyInfo().getType());
                keyInfo.setClassname(this.generatorEncryptionInfo.getKeyInfo().getGeneratorClassName());
                KeyLocatorMapping keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
                keyLocatorMapping.setLocatorRef(this.generatorEncryptionInfo.getKeyInfo().getId());
                keyLocatorMapping.setKeynameRef(this.generatorEncryptionInfo.getKeyStore().getKeyName());
                keyInfo.setKeyLocatorMapping(keyLocatorMapping);
                secReqGenBndConfig.getKeyInfo().add((Object)keyInfo);
                KeyLocator keyLocator = wscommonbndfactory.createKeyLocator();
                keyLocator.setName(this.generatorEncryptionInfo.getKeyInfo().getId());
                keyLocator.setClassname(this.generatorEncryptionInfo.getKeyInfo().getLocatorClass());
                KeyStore keyStore = wscommonbndfactory.createKeyStore();
                keyStore.setStorepass(this.generatorEncryptionInfo.getKeyStore().getKeyStoreStorePass());
                keyStore.setPath(this.generatorEncryptionInfo.getKeyStore().getKeyStorePath());
                keyStore.setType(this.generatorEncryptionInfo.getKeyStore().getKeyStoreType());
                keyLocator.setKeyStore(keyStore);
                Key key = wscommonbndfactory.createKey();
                key.setAlias(this.generatorEncryptionInfo.getKeyStore().getKeyAlias());
                key.setKeypass(this.generatorEncryptionInfo.getKeyStore().getKeyPass());
                key.setName(this.generatorEncryptionInfo.getKeyStore().getKeyName());
                keyLocator.getKeys().add((Object)key);
                secReqGenBndConfig.getKeyLocator().add((Object)keyLocator);
                SecurityResponseConsumerBindingConfig secResConBndConfig = portQNameBinding.getSecurityResponseConsumerBindingConfig();
                if (secResConBndConfig == null) {
                    secResConBndConfig = wscbndfactory.createSecurityResponseConsumerBindingConfig();
                    portQNameBinding.setSecurityResponseConsumerBindingConfig(secResConBndConfig);
                }
                encryptionInfo = wscommonbndfactory.createEncryptionInfo();
                encryptionInfo.setName("ResponseConsumerEncryptInfo" + System.currentTimeMillis());
                encryptionMethod = wscommonbndfactory.createDataEncryptionMethod();
                encryptionMethod.setAlgorithm(this.consumerEncryptionInfo.getDataEncryptionMethod());
                encryptionInfo.setEncryptionMethod(encryptionMethod);
                keyMethod = this.consumerEncryptionInfo.getKeyEncryptionMethod();
                if (keyMethod != null && !keyMethod.equals(ATKWASUIPlugin.getMessage((String)"%ENCRYPTION_INFO_KEY_ENCRYPTION_NONE"))) {
                    KeyEncryptionMethod keyEncryptionMethod = wscommonbndfactory.createKeyEncryptionMethod();
                    keyEncryptionMethod.setAlgorithm(keyMethod);
                    encryptionInfo.setKeyEncryptionMethod(keyEncryptionMethod);
                }
                encryptionKeyInfo = wscommonbndfactory.createEncryptionKeyInfo();
                encryptionKeyInfo.setKeyinfoRef(this.consumerEncryptionInfo.getKeyInfo().getId());
                encryptionInfo.getEncryptionKeyInfo().add((Object)encryptionKeyInfo);
                partReference = wscommonbndfactory.createPartReference();
                partReference.setPart(this.consumerEncryptionInfo.getId());
                encryptionInfo.setPartReference(partReference);
                secResConBndConfig.getEncryptionInfo().add((Object)encryptionInfo);
                keyInfo = wscommonbndfactory.createKeyInfo();
                keyInfo.setName(this.consumerEncryptionInfo.getKeyInfo().getId());
                keyInfo.setType(this.consumerEncryptionInfo.getKeyInfo().getType());
                keyInfo.setClassname(this.consumerEncryptionInfo.getKeyInfo().getConsumerClassName());
                keyLocatorMapping = wscommonbndfactory.createKeyLocatorMapping();
                keyLocatorMapping.setLocatorRef(this.consumerEncryptionInfo.getKeyInfo().getId());
                keyLocatorMapping.setKeynameRef(this.consumerEncryptionInfo.getKeyStore().getKeyName());
                keyInfo.setKeyLocatorMapping(keyLocatorMapping);
                secResConBndConfig.getKeyInfo().add((Object)keyInfo);
                keyLocator = wscommonbndfactory.createKeyLocator();
                keyLocator.setName(this.consumerEncryptionInfo.getKeyInfo().getId());
                keyLocator.setClassname(this.consumerEncryptionInfo.getKeyInfo().getLocatorClass());
                keyStore = wscommonbndfactory.createKeyStore();
                keyStore.setStorepass(this.consumerEncryptionInfo.getKeyStore().getKeyStoreStorePass());
                keyStore.setPath(this.consumerEncryptionInfo.getKeyStore().getKeyStorePath());
                keyStore.setType(this.consumerEncryptionInfo.getKeyStore().getKeyStoreType());
                keyLocator.setKeyStore(keyStore);
                key = wscommonbndfactory.createKey();
                key.setAlias(this.consumerEncryptionInfo.getKeyStore().getKeyAlias());
                key.setKeypass(this.consumerEncryptionInfo.getKeyStore().getKeyPass());
                key.setName(this.consumerEncryptionInfo.getKeyStore().getKeyName());
                keyLocator.getKeys().add((Object)key);
                secResConBndConfig.getKeyLocator().add((Object)keyLocator);
                artifactEdit.saveIfNecessary(this.monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtENC() throws IOException {
        WscextArtifactEdit artifactEdit = null;
        try {
            try {
                SecurityRequestGeneratorServiceConfig secReqGenServiceConfig;
                artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                WsClientExtension wscext = artifactEdit.getWsClientExtension();
                WscextFactoryImpl wscextfactory = new WscextFactoryImpl();
                com.ibm.etools.webservice.wscext.ServiceRef serviceRef = null;
                com.ibm.etools.webservice.wscext.PortQnameBinding portQnameBinding = null;
                EList serviceRefs = wscext.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    com.ibm.etools.webservice.wscext.ServiceRef tmpSerRef = (com.ibm.etools.webservice.wscext.ServiceRef)serviceRefs.get(i);
                    if (tmpSerRef.getServiceRefLink() != null && tmpSerRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = tmpSerRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscextfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int i2 = 0;
                while (i2 < portQnameBindings.size()) {
                    com.ibm.etools.webservice.wscext.PortQnameBinding pqBnd = (com.ibm.etools.webservice.wscext.PortQnameBinding)portQnameBindings.get(i2);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQnameBinding = pqBnd;
                        break;
                    }
                    ++i2;
                }
                if (portQnameBinding == null) {
                    portQnameBinding = wscextfactory.createPortQnameBinding();
                    portQnameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQnameBinding);
                }
                WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
                ClientServiceConfig clientServiceconfig = portQnameBinding.getClientServiceConfig();
                if (clientServiceconfig == null) {
                    clientServiceconfig = wscextfactory.createClientServiceConfig();
                    portQnameBinding.setClientServiceConfig(clientServiceconfig);
                }
                if ((secReqGenServiceConfig = clientServiceconfig.getSecurityRequestGeneratorServiceConfig()) == null) {
                    secReqGenServiceConfig = wscextfactory.createSecurityRequestGeneratorServiceConfig();
                    clientServiceconfig.setSecurityRequestGeneratorServiceConfig(secReqGenServiceConfig);
                }
                Confidentiality confidentiality = wscommonextfactory.createConfidentiality();
                confidentiality.setName(this.generatorEncryptionInfo.getId());
                confidentiality.setOrder(this.generatorEncryptionInfo.getOrder());
                Vector parts = this.generatorEncryptionInfo.getMessageParts();
                int i3 = 0;
                while (i3 < parts.size()) {
                    MessageParts messagePart = wscommonextfactory.createMessageParts();
                    MessagePartItem item = (MessagePartItem)parts.get(i3);
                    messagePart.setDialect(item.getDialect());
                    messagePart.setKeyword(item.getKeyword());
                    confidentiality.getMessageParts().add((Object)messagePart);
                    ++i3;
                }
                secReqGenServiceConfig.getConfidentiality().add((Object)confidentiality);
                SecurityResponseConsumerServiceConfig secResConServiceConfig = clientServiceconfig.getSecurityResponseConsumerServiceConfig();
                if (secResConServiceConfig == null) {
                    secResConServiceConfig = wscextfactory.createSecurityResponseConsumerServiceConfig();
                    clientServiceconfig.setSecurityResponseConsumerServiceConfig(secResConServiceConfig);
                }
                RequiredConfidentiality requiredConfidentiality = wscommonextfactory.createRequiredConfidentiality();
                requiredConfidentiality.setName(this.consumerEncryptionInfo.getId());
                requiredConfidentiality.setUsage(UsageType.get((String)this.consumerEncryptionInfo.getUsageType()));
                parts = this.consumerEncryptionInfo.getMessageParts();
                int i4 = 0;
                while (i4 < parts.size()) {
                    MessageParts messagePart = wscommonextfactory.createMessageParts();
                    MessagePartItem item = (MessagePartItem)parts.get(i4);
                    messagePart.setDialect(item.getDialect());
                    messagePart.setKeyword(item.getKeyword());
                    requiredConfidentiality.getMessageParts().add((Object)messagePart);
                    ++i4;
                }
                secResConServiceConfig.getRequiredConfidentiality().add((Object)requiredConfidentiality);
                artifactEdit.saveIfNecessary(this.monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public void setConsumerEncryptionInfo(EncryptionInformation consumerEncryptionInfo) {
        this.consumerEncryptionInfo = consumerEncryptionInfo;
    }

    public void setGeneratorEncryptionInfo(EncryptionInformation generatorEncryptionInfo) {
        this.generatorEncryptionInfo = generatorEncryptionInfo;
    }

    public void setServiceReference(ServiceReferenceObject serviceReference) {
        this.serviceReference = serviceReference;
    }
}

