/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.security.ui.command;

import com.ibm.ast.ws.security.ui.common.ServiceReferenceObject;
import com.ibm.ast.ws.security.ui.plugin.WSSecurityUIPlugin;
import com.ibm.ast.ws.security.ui.tokens.AuthenticationToken;
import com.ibm.ast.ws.security.ui.tokens.UserNameAuthenticationToken;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.ext.model.WscextArtifactEdit;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.impl.WscbndFactoryImpl;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscext.impl.WscextFactoryImpl;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandler;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.ValueType;
import com.ibm.etools.webservice.wscommonbnd.impl.WscommonbndFactoryImpl;
import com.ibm.etools.webservice.wscommonext.SecurityToken;
import com.ibm.etools.webservice.wscommonext.impl.WscommonextFactoryImpl;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AddClientSideAuthenticationCommand
extends AbstractDataModelOperation {
    private IProgressMonitor monitor;
    private AuthenticationToken token;
    private ServiceReferenceObject serviceReference;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.monitor = monitor;
        try {
            this.updateWsBndENC();
            this.updateWsExtENC();
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.ast.ws.security.ui", 0, WSSecurityUIPlugin.getMessage("MSG_ERROR_UPDATING_WEB_XMI"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void updateWsBndENC() throws IOException {
        WscbndArtifactEdit artifactEdit = null;
        try {
            try {
                SecurityRequestGeneratorBindingConfig secReqGenBndConfig;
                artifactEdit = WscbndArtifactEdit.getWSCBNDArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                ClientBinding wscbnd = artifactEdit.getClientBinding();
                WscbndFactoryImpl wscbndfactory = new WscbndFactoryImpl();
                ServiceRef serviceRef = null;
                PortQnameBinding portQNameBinding = null;
                EList serviceRefs = wscbnd.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    ServiceRef serRef = (ServiceRef)serviceRefs.get(i);
                    if (serRef.getServiceRefLink() != null && serRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = serRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscbndfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int j = 0;
                while (j < portQnameBindings.size()) {
                    PortQnameBinding pqBnd = (PortQnameBinding)portQnameBindings.get(j);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQNameBinding = pqBnd;
                        break;
                    }
                    ++j;
                }
                if (portQNameBinding == null) {
                    portQNameBinding = wscbndfactory.createPortQnameBinding();
                    portQNameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQNameBinding);
                }
                if ((secReqGenBndConfig = portQNameBinding.getSecurityRequestGeneratorBindingConfig()) == null) {
                    secReqGenBndConfig = wscbndfactory.createSecurityRequestGeneratorBindingConfig();
                    portQNameBinding.setSecurityRequestGeneratorBindingConfig(secReqGenBndConfig);
                }
                WscommonbndFactoryImpl wscommonbndfactory = new WscommonbndFactoryImpl();
                TokenGenerator tokenGen = wscommonbndfactory.createTokenGenerator();
                tokenGen.setName(this.token.getId());
                tokenGen.setClassname(this.token.getGeneratorClassName());
                ValueType valueType = wscommonbndfactory.createValueType();
                valueType.setLocalName(this.token.getTokenLocalName());
                valueType.setUri(this.token.getTokenURI());
                valueType.setName(this.token.getValueType());
                tokenGen.setValueType(valueType);
                CallbackHandler callBackHand = wscommonbndfactory.createCallbackHandler();
                callBackHand.setClassname(this.token.getTokenCallBackHandler());
                if (this.token instanceof UserNameAuthenticationToken) {
                    UserNameAuthenticationToken userNameToken = (UserNameAuthenticationToken)this.token;
                    BasicAuth auth = wscbndfactory.createBasicAuth();
                    auth.setPassword(userNameToken.getPassword());
                    auth.setUserid(userNameToken.getUserName());
                    callBackHand.setBasicAuth(auth);
                }
                tokenGen.setCallbackHandler(callBackHand);
                PartReference partRef = wscommonbndfactory.createPartReference();
                partRef.setPart(this.token.getId());
                tokenGen.setPartReference(partRef);
                secReqGenBndConfig.getTokenGenerator().add((Object)tokenGen);
                artifactEdit.saveIfNecessary(this.monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    private void updateWsExtENC() throws IOException {
        WscextArtifactEdit artifactEdit = null;
        try {
            try {
                SecurityRequestGeneratorServiceConfig secReqGenServiceConfig;
                artifactEdit = WscextArtifactEdit.getWSCEXTArtifactEditForWrite((IProject)this.serviceReference.getClientProject());
                WsClientExtension wscext = artifactEdit.getWsClientExtension();
                WscextFactoryImpl wscextfactory = new WscextFactoryImpl();
                com.ibm.etools.webservice.wscext.ServiceRef serviceRef = null;
                com.ibm.etools.webservice.wscext.PortQnameBinding portQnameBinding = null;
                EList serviceRefs = wscext.getServiceRefs();
                int i = 0;
                while (i < serviceRefs.size()) {
                    com.ibm.etools.webservice.wscext.ServiceRef tmpSerRef = (com.ibm.etools.webservice.wscext.ServiceRef)serviceRefs.get(i);
                    if (tmpSerRef.getServiceRefLink() != null && tmpSerRef.getServiceRefLink().equals(this.serviceReference.getServiceName())) {
                        serviceRef = tmpSerRef;
                        break;
                    }
                    ++i;
                }
                if (serviceRef == null) {
                    serviceRef = wscextfactory.createServiceRef();
                    serviceRef.setServiceRefLink(this.serviceReference.getServiceName());
                    serviceRefs.add((Object)serviceRef);
                }
                EList portQnameBindings = serviceRef.getPortQnameBindings();
                int i2 = 0;
                while (i2 < portQnameBindings.size()) {
                    com.ibm.etools.webservice.wscext.PortQnameBinding pqBnd = (com.ibm.etools.webservice.wscext.PortQnameBinding)portQnameBindings.get(i2);
                    if (pqBnd.getPortQnameLocalNameLink() != null && pqBnd.getPortQnameLocalNameLink().equals(this.serviceReference.getPortName())) {
                        portQnameBinding = pqBnd;
                        break;
                    }
                    ++i2;
                }
                if (portQnameBinding == null) {
                    portQnameBinding = wscextfactory.createPortQnameBinding();
                    portQnameBinding.setPortQnameLocalNameLink(this.serviceReference.getPortName());
                    serviceRef.getPortQnameBindings().add((Object)portQnameBinding);
                }
                WscommonextFactoryImpl wscommonextfactory = new WscommonextFactoryImpl();
                ClientServiceConfig clientServiceconfig = portQnameBinding.getClientServiceConfig();
                if (clientServiceconfig == null) {
                    clientServiceconfig = wscextfactory.createClientServiceConfig();
                    portQnameBinding.setClientServiceConfig(clientServiceconfig);
                }
                if ((secReqGenServiceConfig = clientServiceconfig.getSecurityRequestGeneratorServiceConfig()) == null) {
                    secReqGenServiceConfig = wscextfactory.createSecurityRequestGeneratorServiceConfig();
                    clientServiceconfig.setSecurityRequestGeneratorServiceConfig(secReqGenServiceConfig);
                }
                SecurityToken secToken = wscommonextfactory.createSecurityToken();
                secToken.setLocalName(this.token.getTokenLocalName());
                secToken.setName(this.token.getId());
                secToken.setUri(this.token.getTokenURI());
                secReqGenServiceConfig.getSecurityToken().add((Object)secToken);
                artifactEdit.saveIfNecessary(this.monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    public void setToken(AuthenticationToken token) {
        this.token = token;
    }

    public void setServiceReference(ServiceReferenceObject serviceReference) {
        this.serviceReference = serviceReference;
    }
}

