/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.etools.javaee.model.internal.IJEE5ModelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;

public class WebServiceMetadataUtil {
    private static final String WEB_SERVICE = "javax.jws.WebService";
    private static final String JAX_WS_SERVICE_CLASS = "javax.xml.ws.Service";

    private static String getServletClass(IProject project, String name) {
        WebArtifactEdit edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
        if (edit != null) {
            try {
                WebApp webApp = edit.getWebApp();
                if (webApp != null) {
                    Servlet servlet = webApp.getServletNamed(name);
                    String string = servlet.getServletClass().getQualifiedName();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                edit.dispose();
            }
        }
        return null;
    }

    private static String getEJBClass(IProject project, String name) {
        EnterpriseBeans beans;
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object model = provider.getModelObject(IJEE5ModelProvider.EJB_DD_MODEL_MERGED);
        if (model instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
            EnterpriseBean bean = ((org.eclipse.jst.j2ee.ejb.EJBJar)model).getEnterpriseBeanNamed(name);
            if (bean != null) {
                return bean.getEjbClassName();
            }
        } else if (model instanceof EJBJar && (beans = ((EJBJar)model).getEnterpriseBeans()) != null) {
            for (Object object : beans.getSessionBeans()) {
                SessionBean sessionBean = (SessionBean)object;
                if (!name.equals(sessionBean.getEjbName())) continue;
                return sessionBean.getEjbClass();
            }
            for (Object object : beans.getMessageDrivenBeans()) {
                MessageDrivenBean messageBean = (MessageDrivenBean)object;
                if (!messageBean.getEjbName().equals(name)) continue;
                return messageBean.getEjbClass();
            }
            for (Object object : beans.getEntityBeans()) {
                EntityBean entityBean = (EntityBean)object;
                if (!entityBean.getEjbName().equals(name)) continue;
                return entityBean.getEjbClass();
            }
        }
        return null;
    }

    public static String getServiceEndpointInterface(ServiceRef serviceRef) {
        for (Object object : serviceRef.getPortComponentRefs()) {
            PortComponentRef portRef = (PortComponentRef)object;
            JavaClass sei = portRef.getServiceEndpointInterface();
            if (sei == null) continue;
            return sei.getQualifiedName();
        }
        return null;
    }

    public static String getServiceImplBean(IProject project, PortComponent port, boolean performLookup) {
        ServiceImplBean bean = port.getServiceImplBean();
        ServletLink servletLink = bean.getEServletLink();
        if (servletLink != null) {
            String link = servletLink.getServletLink();
            if (link != null && performLookup) {
                link = WebServiceMetadataUtil.getServletClass(project, link);
            }
            return link;
        }
        EJBLink ejbLink = bean.getEEJBLink();
        if (ejbLink != null) {
            String ejb = ejbLink.getEjbLink();
            if (ejb != null) {
                ejb = WebServiceMetadataUtil.getEJBClass(project, ejb);
            }
            return ejb;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJaxWsService(IProject project, WebServiceDescription description) {
        if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            String version = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
            if (version.startsWith("1.")) return false;
            if (version.startsWith("2.")) {
                return false;
            }
        }
        if (description.getPortComponents().isEmpty()) return false;
        PortComponent port = (PortComponent)description.getPortComponents().get(0);
        String sei = port.getServiceEndpointInterface();
        if (sei == null) {
            return true;
        }
        try {
            IAnnotation[] annotations;
            FindSeiTypeJob job = new FindSeiTypeJob(project, sei);
            job.setSystem(true);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            IType type = job.getSeiType();
            if (type == null) return false;
            IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            block4: while (true) {
                String[][] matches;
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                String[][] stringArray = matches = type.resolveType(annotation.getElementName());
                int n3 = matches.length;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) {
                        ++n2;
                        continue block4;
                    }
                    String[] match = stringArray[n4];
                    String concat = String.valueOf(match[0]) + '.' + match[1];
                    if (WEB_SERVICE.equals(concat)) {
                        return true;
                    }
                    ++n4;
                }
                break;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean isJaxWsServiceRef(IProject project, ServiceRef serviceRef) {
        JavaClass clazz = serviceRef.getServiceInterface();
        if (clazz == null) {
            return false;
        }
        if (JAX_WS_SERVICE_CLASS.equals(clazz.getQualifiedName())) {
            return true;
        }
        for (EClass superClass : clazz.getEAllSuperTypes()) {
            if (!(superClass instanceof JavaClass) || !JAX_WS_SERVICE_CLASS.equals(((JavaClass)superClass).getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static class FindSeiTypeJob
    extends Job {
        private IType seiType_;
        private IProject project_;
        private String seiTypeName_;

        public FindSeiTypeJob(IProject project, String seiTypeName) {
            super("WebServiceMetadataUtil.FindSeiTypeJob");
            this.setSystem(true);
            this.project_ = project;
            this.seiTypeName_ = seiTypeName;
            this.seiType_ = null;
        }

        public IType getSeiType() {
            return this.seiType_;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IJavaProject javaProject = JavaCore.create((IProject)this.project_);
            try {
                this.seiType_ = javaProject.findType(this.seiTypeName_);
            }
            catch (JavaModelException javaModelException) {}
            return Status.OK_STATUS;
        }
    }
}

