/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.utils.AddSecuritySettingToModelUtil;
import com.ibm.ast.ws.rd.utils.CopyJAXRPCMappingFileUtil;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WsextArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wsext.WsDescExt;
import com.ibm.etools.webservice.wsext.WsExtension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.webservice.internal.WebServiceInit;
import org.eclipse.jst.j2ee.webservice.internal.wsdd.WsddResourceFactory;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class UpdateIBMWebServicesExtXMICommand
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private static final String IBM_WEBSERVICES_EXT_XMI = "ibm-webservices-ext.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webservicesXmlPath = null;
    IPath ibmWebServicesExtXmiPath = null;
    private String eJBProjectName;
    private IProject serviceProject;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IProject ibmWsExtXmiProject;
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"));
        }
        boolean isEJB = this.javaWSDLParam.getServerSide() == 2;
        IProject iProject = ibmWsExtXmiProject = isEJB ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.eJBProjectName) : this.serviceProject;
        if (ibmWsExtXmiProject == null) {
            return StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_SERVICE_PROJECT_NOT_FOUND"));
        }
        this.getWSDDFilePath(ibmWsExtXmiProject);
        if (this.webservicesXmlPath == null) {
            return StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_WEBSERVICES_XML_NOT_FOUND"));
        }
        IEnvironment environment = super.getEnvironment();
        if (this.ibmWebServicesExtXmiPath == null) {
            IStatus status = this.copyIBMWebServicesExtXMIFile(environment, monitor, isEJB);
            ResourcesPlugin.getWorkspace().checkpoint(false);
            if (this.javaWSDLParam.getSecurityConfig() != 0) {
                WsextArtifactEdit artifactEdit = null;
                try {
                    try {
                        artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ibmWsExtXmiProject);
                        WsExtension wsext = artifactEdit.getWsExtension();
                        AddSecuritySettingToModelUtil.addExtensionSecurity(this.javaWSDLParam, wsext, isEJB);
                        artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (artifactEdit != null) {
                            artifactEdit.dispose();
                        }
                    }
                }
                finally {
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            return status;
        }
        CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
        if (context.isBackupDD()) {
            CopyJAXRPCMappingFileUtil.backupWebServicesFile(environment, monitor, this.ibmWebServicesExtXmiPath.toString(), ibmWsExtXmiProject, IBM_WEBSERVICES_EXT_XMI);
        }
        WsextArtifactEdit artifactEdit = null;
        try {
            try {
                WsExtension newWsExt = UpdateIBMWebServicesExtXMICommand.loadResourceFromOutside(this.javaWSDLParam.getTempOutput(), isEJB, true);
                if (this.javaWSDLParam.getSecurityConfig() != 0) {
                    AddSecuritySettingToModelUtil.addExtensionSecurity(this.javaWSDLParam, newWsExt, isEJB);
                }
                EList newWsDescExts = newWsExt.getWsDescExt();
                artifactEdit = WsextArtifactEdit.getWSEXTArtifactEditForWrite((IProject)ibmWsExtXmiProject);
                WsExtension wsext = artifactEdit.getWsExtension();
                int n = 0;
                while (n < newWsDescExts.size()) {
                    WsDescExt wsDescExtension = (WsDescExt)newWsDescExts.get(n);
                    EList eList = wsext.getWsDescExt();
                    int i = 0;
                    while (i < eList.size()) {
                        WsDescExt wsDescExtensionTemp = (WsDescExt)eList.get(i);
                        if (wsDescExtensionTemp != null && wsDescExtensionTemp.getWsDescNameLink().equalsIgnoreCase(wsDescExtension.getWsDescNameLink())) {
                            eList.remove((Object)wsDescExtensionTemp);
                        }
                        ++i;
                    }
                    eList.add((Object)EcoreUtil.copy((EObject)wsDescExtension));
                    ++n;
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.webservicesXmlPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile(IBM_WEBSERVICES_EXT_XMI)).exists()) {
            this.ibmWebServicesExtXmiPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    private IStatus copyIBMWebServicesExtXMIFile(IEnvironment environment, IProgressMonitor monitor, boolean isEJB) {
        if (this.javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform(this.javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
        File source = new File(String.valueOf(targetOutput) + infFolder + File.separator + IBM_WEBSERVICES_EXT_XMI);
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = outputPath.append(infFolder).append(IBM_WEBSERVICES_EXT_XMI).makeAbsolute();
        try {
            FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    public static WsExtension loadResourceFromOutside(String rootPath, boolean isEJB, boolean needInf) {
        J2EEInit.init();
        WebServiceInit.init();
        WsddResourceFactory.registerWith((RendererFactory)new EMF2DOMRendererFactory());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        URIConverterImpl conv = new URIConverterImpl();
        resourceSet.setURIConverter((URIConverter)conv);
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        String filePath = null;
        filePath = needInf ? String.valueOf(rootPath) + infFolder + File.separator + IBM_WEBSERVICES_EXT_XMI : String.valueOf(rootPath) + IBM_WEBSERVICES_EXT_XMI;
        filePath = J2EEUtils.removeFileProtocol((String)filePath);
        URI uri = URI.createFileURI((String)filePath);
        try {
            Resource resource = resourceSet.getResource(uri, true);
            EList contents = resource.getContents();
            WsExtension wsext = null;
            int i = 0;
            while (i <= contents.size()) {
                if (contents.get(i) instanceof WsExtension) {
                    WsExtension wsExtension = wsext = (WsExtension)contents.get(i);
                    return wsExtension;
                }
                try {
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
        }
        finally {
            WsddResourceFactory.register();
        }
        return null;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }
}

