/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.utils.AddSecuritySettingToModelUtil;
import com.ibm.ast.ws.rd.utils.CopyJAXRPCMappingFileUtil;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.context.CodeGenerationContext;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wsbnd.impl.WsbndFactoryImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceFactoryRegistry;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.J2EEInit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.webservice.internal.WebServiceInit;
import org.eclipse.jst.j2ee.webservice.internal.wsdd.WsddResourceFactory;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;

public class UpdateIBMWebServicesBndXMICommand
extends AbstractDataModelOperation {
    private final String WEBSERVICES_XML = "webservices.xml";
    private static final String IBM_WEBSERVICES_BND_XMI = "ibm-webservices-bnd.xmi";
    private JavaWSDLParameterBase javaWSDLParam = null;
    IPath webservicesXmlPath = null;
    IPath ibmWebServicesBndXmiPath = null;
    private MessageUtils msgUtils_;
    private IProject earProject = null;
    private String eJBProjectName;
    private IProject serviceProject = null;
    private IProject jmsRouterProject = null;
    private boolean addRouter = true;
    private boolean noMerge = false;

    public UpdateIBMWebServicesBndXMICommand() {
        String pluginId = "com.ibm.ast.ws.rd";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public UpdateIBMWebServicesBndXMICommand(boolean addRouter) {
        this();
        this.addRouter = addRouter;
    }

    public UpdateIBMWebServicesBndXMICommand(boolean addRouter, boolean noMerge) {
        this();
        this.addRouter = addRouter;
        this.noMerge = noMerge;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        block43: {
            String transportName;
            IProject ibmWsBndXmiProject;
            if (this.javaWSDLParam == null) {
                return StatusUtils.errorStatus((String)this.msgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"));
            }
            IEnvironment environment = super.getEnvironment();
            boolean isEJB = this.javaWSDLParam.getServerSide() == 2;
            IProject iProject = ibmWsBndXmiProject = isEJB ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.eJBProjectName) : this.serviceProject;
            if (ibmWsBndXmiProject == null) {
                return StatusUtils.errorStatus((String)this.msgUtils_.getMessage("MSG_ERROR_SERVICE_PROJECT_NOT_FOUND"));
            }
            this.getWSDDFilePath(ibmWsBndXmiProject);
            if (this.webservicesXmlPath == null) {
                return StatusUtils.errorStatus((String)this.msgUtils_.getMessage("MSG_ERROR_WEBSERVICES_XML_NOT_FOUND"));
            }
            if (this.ibmWebServicesBndXmiPath == null) {
                IStatus status = this.copyIBMWebServicesBndXMIFile(environment, monitor, isEJB);
                ResourcesPlugin.getWorkspace().checkpoint(false);
                if (status.getSeverity() != 0) {
                    return status;
                }
                if (!isEJB && this.javaWSDLParam.getSecurityConfig() == 0) {
                    return Status.OK_STATUS;
                }
            }
            if ((transportName = this.javaWSDLParam.getBindingTypes()) == null || transportName.length() == 0) {
                transportName = this.javaWSDLParam.getTransport();
            }
            String httpFileName = "";
            String jmsFileName = "";
            if ((transportName.indexOf("http") != -1 && !this.javaWSDLParam.getSwitchBinding() || transportName.indexOf("jms") != -1 && this.javaWSDLParam.getSwitchBinding()) && this.serviceProject != null) {
                httpFileName = this.getModuleUriForProject(this.serviceProject);
            }
            if ((transportName.indexOf("jms") != -1 && !this.javaWSDLParam.getSwitchBinding() || transportName.indexOf("http") != -1 && this.javaWSDLParam.getSwitchBinding()) && this.jmsRouterProject != null) {
                jmsFileName = this.getModuleUriForProject(this.jmsRouterProject);
            }
            WsbndArtifactEdit artifactEdit = null;
            if (isEJB && this.addRouter && this.noMerge) {
                try {
                    try {
                        artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ibmWsBndXmiProject);
                        WSBinding wsbnd = artifactEdit.getWSBinding();
                        EList routers = wsbnd.getRouterModules();
                        this.addAndReplaceExistingRouter(routers, httpFileName, jmsFileName);
                        artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        IStatus status;
                        IStatus iStatus = status = StatusUtils.errorStatus((String)this.msgUtils_.getMessage("MSG_ERROR_UPDATING_IBM_WEBSERVICES_BND_XMI"), (Throwable)e);
                        if (artifactEdit != null) {
                            artifactEdit.dispose();
                        }
                        return iStatus;
                    }
                }
                finally {
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
                return Status.OK_STATUS;
            }
            if (this.ibmWebServicesBndXmiPath == null) {
                try {
                    try {
                        artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ibmWsBndXmiProject);
                        WSBinding wsbnd = (WSBinding)artifactEdit.getDeploymentDescriptorRoot();
                        if (this.javaWSDLParam.getSecurityConfig() != 0) {
                            AddSecuritySettingToModelUtil.addBndingSecurity(this.javaWSDLParam, wsbnd, isEJB);
                        }
                        if (isEJB && this.addRouter) {
                            RouterModule newRouter;
                            EList routers = wsbnd.getRouterModules();
                            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
                            if (httpFileName.length() > 0) {
                                newRouter = wsbndfactory.createRouterModule();
                                newRouter.setName(httpFileName);
                                newRouter.setTransport("http");
                                routers.add((Object)newRouter);
                            }
                            if (jmsFileName.length() > 0) {
                                newRouter = wsbndfactory.createRouterModule();
                                newRouter.setName(jmsFileName);
                                newRouter.setTransport("jms");
                                routers.add((Object)newRouter);
                            }
                        }
                        artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        break block43;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        IStatus iStatus = Status.OK_STATUS;
                        if (artifactEdit != null) {
                            artifactEdit.dispose();
                        }
                        return iStatus;
                    }
                }
                finally {
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            CodeGenerationContext context = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext();
            if (context.isBackupDD()) {
                CopyJAXRPCMappingFileUtil.backupWebServicesFile(environment, monitor, this.ibmWebServicesBndXmiPath.toString(), ibmWsBndXmiProject, IBM_WEBSERVICES_BND_XMI);
            }
            artifactEdit = null;
            try {
                try {
                    WSBinding newWsBnd = UpdateIBMWebServicesBndXMICommand.loadResourceFromOutside(this.javaWSDLParam.getTempOutput(), isEJB, true);
                    if (this.javaWSDLParam.getSecurityConfig() != 0) {
                        AddSecuritySettingToModelUtil.addBndingSecurity(this.javaWSDLParam, newWsBnd, isEJB);
                    }
                    EList newWsdescBindings = newWsBnd.getWsdescBindings();
                    artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForWrite((IProject)ibmWsBndXmiProject);
                    WSBinding wsbnd = artifactEdit.getWSBinding();
                    int n = 0;
                    while (n < newWsdescBindings.size()) {
                        WSDescBinding wsDescBinding = (WSDescBinding)newWsdescBindings.get(n);
                        if (isEJB && this.addRouter) {
                            EList routers = wsbnd.getRouterModules();
                            this.addAndReplaceExistingRouter(routers, httpFileName, jmsFileName);
                        }
                        EList eList = wsbnd.getWsdescBindings();
                        int i = 0;
                        while (i < eList.size()) {
                            WSDescBinding wsDescBindingTemp = (WSDescBinding)eList.get(i);
                            if (wsDescBindingTemp != null && wsDescBindingTemp.getWsDescNameLink().equalsIgnoreCase(wsDescBinding.getWsDescNameLink())) {
                                eList.remove((Object)wsDescBindingTemp);
                            }
                            ++i;
                        }
                        eList.add((Object)EcoreUtil.copy((EObject)wsDescBinding));
                        ++n;
                    }
                    artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (artifactEdit != null) {
                        artifactEdit.dispose();
                    }
                }
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private final String getModuleUriForProject(IProject moduleProject) {
        String moduleURI = null;
        if (moduleProject != null) {
            EARArtifactEdit earArtifactEdit = null;
            try {
                try {
                    earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.earProject);
                    IVirtualComponent moduleComponent = ComponentCore.createComponent((IProject)moduleProject);
                    moduleURI = earArtifactEdit.getModuleURI(moduleComponent);
                }
                catch (Exception exception) {
                    String extension = null;
                    extension = J2EEProjectUtilities.isDynamicWebProject((IProject)moduleProject) ? ".war" : (J2EEProjectUtilities.isEJBProject((IProject)moduleProject) ? ".jar" : ".war");
                    moduleURI = String.valueOf(moduleProject.getName().replaceAll(" ", "_")) + extension;
                    if (earArtifactEdit != null) {
                        earArtifactEdit.dispose();
                    }
                }
            }
            finally {
                if (earArtifactEdit != null) {
                    earArtifactEdit.dispose();
                }
            }
        }
        return moduleURI;
    }

    private void addAndReplaceExistingRouter(EList routers, String httpFileName, String jmsFileName) {
        RouterModule newRouter;
        boolean foundHttpRouter = false;
        boolean foundJmsRouter = false;
        int i = 0;
        while (i < routers.size()) {
            RouterModule router = (RouterModule)routers.get(i);
            if (httpFileName.equals(router.getName()) && "http".equals(router.getTransport())) {
                foundHttpRouter = true;
            } else if (jmsFileName.equals(router.getName()) && "jms".equals(router.getTransport())) {
                foundJmsRouter = true;
            } else if (httpFileName.length() > 0 && "http".equals(router.getTransport())) {
                router.setName(httpFileName);
                foundHttpRouter = true;
            } else if (jmsFileName.length() > 0 && "jms".equals(router.getTransport())) {
                router.setName(jmsFileName);
                foundJmsRouter = true;
            }
            ++i;
        }
        if (!foundHttpRouter && httpFileName.length() > 0) {
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            newRouter = wsbndfactory.createRouterModule();
            newRouter.setName(httpFileName);
            newRouter.setTransport("http");
            routers.add((Object)newRouter);
        }
        if (!foundJmsRouter && jmsFileName.length() > 0) {
            WsbndFactoryImpl wsbndfactory = new WsbndFactoryImpl();
            newRouter = wsbndfactory.createRouterModule();
            newRouter.setName(jmsFileName);
            newRouter.setTransport("jms");
            routers.add((Object)newRouter);
        }
    }

    private void getWSDDFilePath(IProject ddProject) {
        IPath projectPath = ddProject.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)ddProject);
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isWebProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
        } else if (J2EEUtils.isEJBProject((IProject)ddProject)) {
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        IVirtualFile ivFile = ivFolder.getFile("webservices.xml");
        if (ivFile.exists()) {
            this.webservicesXmlPath = projectPath.append(ivFile.getProjectRelativePath());
        }
        if ((ivFile = ivFolder.getFile(IBM_WEBSERVICES_BND_XMI)).exists()) {
            this.ibmWebServicesBndXmiPath = projectPath.append(ivFile.getProjectRelativePath());
        }
    }

    private IStatus copyIBMWebServicesBndXMIFile(IEnvironment environment, IProgressMonitor monitor, boolean isEJB) {
        if (this.javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform(this.javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)this.javaWSDLParam.getTempOutput());
        File source = new File(String.valueOf(targetOutput) + infFolder + File.separator + IBM_WEBSERVICES_BND_XMI);
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = outputPath.append(infFolder).append(IBM_WEBSERVICES_BND_XMI).makeAbsolute();
        try {
            FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    public static WSBinding loadResourceFromOutside(String rootPath, boolean isEJB, boolean needInf) {
        J2EEInit.init();
        WebServiceInit.init();
        WsddResourceFactory.registerWith((RendererFactory)new EMF2DOMRendererFactory());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new J2EEResourceFactoryRegistry());
        URIConverterImpl conv = new URIConverterImpl();
        resourceSet.setURIConverter((URIConverter)conv);
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        String filePath = null;
        filePath = needInf ? String.valueOf(rootPath) + infFolder + File.separator + IBM_WEBSERVICES_BND_XMI : String.valueOf(rootPath) + IBM_WEBSERVICES_BND_XMI;
        filePath = J2EEUtils.removeFileProtocol((String)filePath);
        URI uri = URI.createFileURI((String)filePath);
        try {
            Resource resource = resourceSet.getResource(uri, true);
            EList contents = resource.getContents();
            WSBinding wsbnd = null;
            int i = 0;
            while (i <= contents.size()) {
                if (contents.get(i) instanceof WSBinding) {
                    WSBinding wSBinding = wsbnd = (WSBinding)contents.get(i);
                    return wSBinding;
                }
                try {
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
        }
        finally {
            WsddResourceFactory.register();
        }
        return null;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setJmsRouterProject(IProject jmsRouterProject) {
        this.jmsRouterProject = jmsRouterProject;
    }
}

