/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CreateModuleCommand
extends AbstractDataModelOperation {
    public static final byte WEB = 0;
    public static final byte EJB = 1;
    public static final byte APPCLIENT = 2;
    public static final byte EAR = 3;
    private final Hashtable serverFactoryIdToWasFacetMapper_ = new Hashtable();
    public static final String WEB_TEMPLATE = "template.jst.web";
    public static final String EJB_TEMPLATE = "template.jst.ejb";
    public static final String APPCLIENT_TEMPLATE = "template.jst.appclient";
    public static final String EAR_TEMPLATE = "template.jst.ear";
    private String projectName;
    private String moduleName;
    private byte moduleType;
    private String j2eeLevel;
    private String serverFactoryId;
    private String serverInstanceId_;
    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;

    public CreateModuleCommand() {
        this.serverFactoryIdToWasFacetMapper_.put("com.ibm.ws.ast.st.v7.server.base", "7.0");
        this.serverFactoryIdToWasFacetMapper_.put("com.ibm.ws.ast.st.v61.server.base", "6.1");
        this.serverFactoryIdToWasFacetMapper_.put("com.ibm.ws.ast.st.v6.server.base", "6.0");
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        status = this.checkDataReady();
        if (status.getSeverity() == 4) {
            return status;
        }
        IProject project = ProjectUtilities.getProject((String)this.projectName);
        if (!project.exists()) {
            byte type = this.getModuleType();
            switch (type) {
                case 0: {
                    status = this.createWebProject(monitor, adaptable);
                    break;
                }
                case 1: {
                    status = this.createEjbProject(monitor, adaptable);
                    break;
                }
                case 2: {
                    status = this.createAppClientProject(monitor, adaptable);
                    break;
                }
                case 3: {
                    status = this.createEarProject(monitor, adaptable);
                    break;
                }
                default: {
                    return StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_COMPONENT_CREATION", new String[]{this.projectName, this.moduleName}));
                }
            }
        }
        return status;
    }

    private IStatus createWebProject(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(env);
        createProjectCmd.setTemplateId(WEB_TEMPLATE);
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId_);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredWebExtendedFacetVersion());
        createProjectCmd.setProjectName(this.projectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredWebExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.web", this.getWebVersionFromJ2EELevel(this.j2eeLevel));
        String wasFacetVersion = (String)this.serverFactoryIdToWasFacetMapper_.get(this.serverFactoryId);
        if (wasFacetVersion != null) {
            RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion(IFacetConstants.WEB_COEXISTENCE_FACET_ID, wasFacetVersion);
            RequiredFacetVersion reqFacetVersion3 = this.getRequiredFacetVersion(IFacetConstants.WEB_EXTENDED_FACET_ID, wasFacetVersion);
            return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2, reqFacetVersion3};
        }
        return new RequiredFacetVersion[]{reqFacetVersion1};
    }

    private RequiredFacetVersion getRequiredFacetVersion(String facetName, String facetVersion) {
        IProjectFacet projectFacetJava = ProjectFacetsManager.getProjectFacet((String)facetName);
        IProjectFacetVersion projJavaFacetVersion = projectFacetJava.getVersion(facetVersion);
        RequiredFacetVersion reqFacetVersion = new RequiredFacetVersion();
        reqFacetVersion.setAllowNewer(false);
        reqFacetVersion.setProjectFacetVersion(projJavaFacetVersion);
        return reqFacetVersion;
    }

    private IStatus checkDataReady() {
        if (this.projectName == null || this.serverFactoryId == null) {
            return StatusUtils.errorStatus((String)RdPlugin.getDefault().getMessage("MSG_ERROR_COMPONENT_CREATION", new String[]{this.projectName, this.moduleName}));
        }
        return Status.OK_STATUS;
    }

    private Set getFacetInstallActions(Set projectFacetVersions) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        for (IProjectFacetVersion fv : projectFacetVersions) {
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, null);
            actions.add(action);
        }
        return actions;
    }

    private boolean doesRuntimeSupportFacets(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime, Set projectFacetVersions) {
        Set runtimes = RuntimeManager.getRuntimes((Set)projectFacetVersions);
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime : runtimes) {
            if (!runtime.getName().equals(facetRuntime.getName())) continue;
            return true;
        }
        return false;
    }

    private IStatus createEarProject(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(env);
        createProjectCmd.setTemplateId(EAR_TEMPLATE);
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId_);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredEarExtendedFacetVersion());
        createProjectCmd.setProjectName(this.projectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredEarExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.ear", this.getEARVersionFromJ2EELevel(this.j2eeLevel));
        String wasFacetVersion = (String)this.serverFactoryIdToWasFacetMapper_.get(this.serverFactoryId);
        if (wasFacetVersion != null) {
            RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion(IFacetConstants.EAR_COEXISTENCE_FACET_ID, wasFacetVersion);
            RequiredFacetVersion reqFacetVersion3 = this.getRequiredFacetVersion(IFacetConstants.EAR_EXTENDED_FACET_ID, wasFacetVersion);
            return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2, reqFacetVersion3};
        }
        return new RequiredFacetVersion[]{reqFacetVersion1};
    }

    private IStatus createEjbProject(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(env);
        createProjectCmd.setTemplateId(EJB_TEMPLATE);
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId_);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredEjbExtendedFacetVersion());
        createProjectCmd.setProjectName(this.projectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredEjbExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.ejb", this.getEJBVersionFromJ2EELevel(this.j2eeLevel));
        String wasFacetVersion = (String)this.serverFactoryIdToWasFacetMapper_.get(this.serverFactoryId);
        if (wasFacetVersion != null) {
            RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion(IFacetConstants.EJB_EXTENDED_FACET_ID, (String)this.serverFactoryIdToWasFacetMapper_.get(this.serverFactoryId));
            return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2};
        }
        return new RequiredFacetVersion[]{reqFacetVersion1};
    }

    private IStatus createAppClientProject(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        CreateFacetedProjectCommand createProjectCmd = new CreateFacetedProjectCommand();
        createProjectCmd.setEnvironment(env);
        createProjectCmd.setTemplateId(APPCLIENT_TEMPLATE);
        createProjectCmd.setServerFactoryId(this.serverFactoryId);
        createProjectCmd.setServerInstanceId(this.serverInstanceId_);
        createProjectCmd.setRequiredFacetVersions(this.getRequiredAppClientExtendedFacetVersion());
        createProjectCmd.setProjectName(this.projectName);
        IStatus status = createProjectCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return Status.OK_STATUS;
    }

    private RequiredFacetVersion[] getRequiredAppClientExtendedFacetVersion() {
        RequiredFacetVersion reqFacetVersion1 = this.getRequiredFacetVersion("jst.appclient", this.getAppClientVersionFromJ2EELevel(this.j2eeLevel));
        String wasFacetVersion = (String)this.serverFactoryIdToWasFacetMapper_.get(this.serverFactoryId);
        if (wasFacetVersion != null) {
            RequiredFacetVersion reqFacetVersion2 = this.getRequiredFacetVersion(IFacetConstants.APPCLIENT_COEXISTENCE_FACET_ID, wasFacetVersion);
            RequiredFacetVersion reqFacetVersion3 = this.getRequiredFacetVersion(IFacetConstants.APPCLIENT_EXTENDED_FACET_ID, wasFacetVersion);
            return new RequiredFacetVersion[]{reqFacetVersion1, reqFacetVersion2, reqFacetVersion3};
        }
        return new RequiredFacetVersion[]{reqFacetVersion1};
    }

    private boolean isJavaFacet(IProjectFacet pf) {
        return pf.getId().equals("jst.java");
    }

    private Set getInitialFacetVersionsFromTemplate(String templateId) {
        IFacetedProjectTemplate template = ProjectFacetsManager.getTemplate((String)templateId);
        Set fixedFacets = template.getFixedProjectFacets();
        HashSet<IProjectFacetVersion> initial = new HashSet<IProjectFacetVersion>();
        for (IProjectFacet facet : fixedFacets) {
            IProjectFacetVersion highestFacetVersion = null;
            try {
                highestFacetVersion = this.isJavaFacet(facet) ? facet.getVersion("1.4") : facet.getLatestVersion();
            }
            catch (VersionFormatException versionFormatException) {
            }
            catch (CoreException coreException) {}
            initial.add(highestFacetVersion);
        }
        return initial;
    }

    /*
     * Unable to fully structure code
     */
    private Set getFacetsToAdd(String templateId) {
        facets = new HashSet<E>();
        this.setFacetRuntime();
        if (this.facetRuntime != null) {
            template = ProjectFacetsManager.getTemplate((String)templateId);
            templateFacets = template.getFixedProjectFacets();
            block3: for (IProjectFacet fixedFacet : templateFacets) {
                block9: {
                    versions = null;
                    try {
                        versions = fixedFacet.getSortedVersions(false);
                        break block9;
                    }
                    catch (VersionFormatException v0) {
                        versionSet = fixedFacet.getVersions();
                        itr = versionSet.iterator();
                        versions = new ArrayList<E>();
                        ** while (itr.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        versions.add(itr.next());
                        continue;
lbl19:
                        // 1 sources

                        break block9;
                    }
                    catch (CoreException v1) {
                        versionSet = fixedFacet.getVersions();
                        itr = versionSet.iterator();
                        versions = new ArrayList<E>();
                        ** while (itr.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        versions.add(itr.next());
                        continue;
                    }
                }
                for (IProjectFacetVersion pfv : versions) {
                    pfvs = new HashSet<IProjectFacetVersion>();
                    pfvs.add(pfv);
                    if (!this.doesRuntimeSupportFacets(this.facetRuntime, pfvs)) continue;
                    facets.add(pfv);
                    continue block3;
                }
            }
        } else {
            facets = this.getInitialFacetVersionsFromTemplate(templateId);
        }
        return facets;
    }

    private void setFacetRuntime() {
        if (this.serverInstanceId_ != null && this.serverInstanceId_.length() > 0) {
            IServer server = ServerCore.findServer((String)this.serverInstanceId_);
            IRuntime sRuntime = server.getRuntime();
            this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
        } else {
            IServerType st = ServerCore.findServerType((String)this.serverFactoryId);
            String runtimeTypeId = st.getRuntimeType().getId();
            IRuntime[] runtimes = ServerCore.getRuntimes();
            int i = 0;
            while (i < runtimes.length) {
                IRuntime sRuntime = runtimes[i];
                if (!sRuntime.isStub() && sRuntime.getRuntimeType().getId().equals(runtimeTypeId)) {
                    this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
                }
                ++i;
            }
        }
    }

    private String getWebVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "2.2";
            }
            case 13: {
                return "2.3";
            }
            case 14: {
                return "2.4";
            }
            case 50: {
                return "2.5";
            }
        }
        return "2.4";
    }

    private String getEJBVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "1.1";
            }
            case 13: {
                return "2.0";
            }
            case 14: {
                return "2.1";
            }
            case 50: {
                return "3.0";
            }
        }
        return "2.1";
    }

    private String getAppClientVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
            case 50: {
                return "5.0";
            }
        }
        return "1.4";
    }

    private String getEARVersionFromJ2EELevel(String j2eeVersion) {
        int aVersion = Integer.valueOf(this.j2eeLevel);
        switch (aVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
            case 50: {
                return "5.0";
            }
        }
        return "1.4";
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public byte getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(byte moduleType) {
        this.moduleType = moduleType;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setJ2eeLevel(String level) {
        this.j2eeLevel = level != null && level.indexOf(".") != -1 ? J2EEUtils.getJ2EEIntVersionAsString((String)level) : level;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId_ = serverInstanceId;
    }
}

