/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.command.ValidateEditCommand;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;

public class CopyJAXRPCMappingFileUtil {
    public static void copyJaxRpcMappingFile(IEnvironment environment, IProgressMonitor monitor, JavaWSDLParameterBase javaWSDLParam) {
        boolean isEJB = javaWSDLParam.getServerSide() == 2;
        CopyJAXRPCMappingFileUtil.copyJaxRpcMappingFile(environment, monitor, javaWSDLParam, isEJB);
    }

    public static void copyJaxRpcMappingFile(IEnvironment environment, IProgressMonitor monitor, JavaWSDLParameterBase javaWSDLParam, boolean isEJB) {
        CopyJAXRPCMappingFileUtil.copyFile(environment, monitor, javaWSDLParam, isEJB);
    }

    private static IStatus copyFile(IEnvironment environment, IProgressMonitor monitor, JavaWSDLParameterBase javaWSDLParam, boolean isEJB) {
        if (javaWSDLParam.getTempOutput() == null) {
            return Status.OK_STATUS;
        }
        String infFolder = "WEB-INF";
        if (isEJB) {
            infFolder = "META-INF";
        }
        Path outputPath = new Path(PlatformUtils.getPathFromPlatform(javaWSDLParam.getOutput()));
        String targetOutput = J2EEUtils.removeFileProtocol((String)javaWSDLParam.getTempOutput());
        File sourceDir = new File(String.valueOf(targetOutput) + infFolder);
        File[] mappingFiles = sourceDir.listFiles(new JaxRpcMappingFileNameFilter());
        int i = 0;
        while (i < mappingFiles.length) {
            FileInputStream finStream = null;
            ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
            try {
                finStream = new FileInputStream(mappingFiles[i]);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace(System.err);
            }
            IPath targetPath = outputPath.append(infFolder).append(mappingFiles[i].getName()).makeAbsolute();
            Vector<IPath> pathVector = new Vector<IPath>();
            pathVector.add(targetPath);
            ValidateEditCommand validateEditCmd = new ValidateEditCommand();
            validateEditCmd.setEnvironment(environment);
            validateEditCmd.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
            IStatus validateStatus = validateEditCmd.execute(monitor, null);
            if (!validateStatus.isOK()) {
                return validateStatus;
            }
            try {
                FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
                ResourcesPlugin.getWorkspace().checkpoint(false);
            }
            catch (CoreException ce) {
                ce.printStackTrace(System.err);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public static IStatus backupWebServicesFile(IEnvironment environment, IProgressMonitor monitor, String sourcePathName, IProject wsXmlProject, String targetName) {
        Path sourcePath = new Path(PlatformUtils.getFileFromPlatform(sourcePathName));
        File source = new File(sourcePath.makeAbsolute().toString());
        FileInputStream finStream = null;
        ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
        try {
            finStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace(System.err);
        }
        IPath targetPath = wsXmlProject.getFullPath().append(".backup").append(new Long(System.currentTimeMillis() / 10000L).toString()).append(targetName).makeAbsolute();
        try {
            FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)environment.getStatusHandler());
            ResourcesPlugin.getWorkspace().checkpoint(false);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
        return Status.OK_STATUS;
    }

    static class JaxRpcMappingFileNameFilter
    implements FilenameFilter {
        JaxRpcMappingFileNameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name != null && name.endsWith("mapping.xml");
        }
    }
}

