/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.utils;

import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.ast.ws.rd.utils.WSDLUtils;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractWSDL2JavaCommand;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class BuildWSDLPort2ImplBeanMappingTask
extends AbstractDataModelOperation {
    private final String IMPL = "Impl";
    private final String DOT = ".";
    private JavaWSDLParameterBase javaWSDLParam_;
    private boolean isTopDown_ = false;
    private WebServicesParser parser_;
    private AbstractWSDL2JavaCommand wsdl2JavaCommand_;
    private Hashtable namespaceToPackageMapping;
    private Hashtable portTypeToSEIMapping;

    public BuildWSDLPort2ImplBeanMappingTask(JavaWSDLParameterBase javaWSDLParam, boolean isTopDown) {
        this();
        this.javaWSDLParam_ = javaWSDLParam;
        this.isTopDown_ = isTopDown;
    }

    public BuildWSDLPort2ImplBeanMappingTask() {
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        if (this.isTopDown_) {
            this.executeTopDown();
        } else {
            this.executeBottomUp();
        }
        return status;
    }

    private void executeTopDown() {
        Definition definition = this.getDefinition(this.javaWSDLParam_.getInputWsdlLocation());
        HashMap<PortType, Port> portType2PortMapping = new HashMap<PortType, Port>();
        HashMap<Object, String> wsdlPort2ImplBeanMapping = new HashMap<Object, String>();
        HashMap<PortType, Binding> portType2BindingMapping = new HashMap<PortType, Binding>();
        Map services = definition.getServices();
        for (Service service : services.values()) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                String packageName;
                PortType portType = port.getBinding().getPortType();
                String implBeanName = null;
                if (portType2PortMapping.containsKey(portType)) {
                    if ((Binding)portType2BindingMapping.get(portType) != port.getBinding()) {
                        packageName = this.getPackageName(portType.getQName().getNamespaceURI());
                        if (packageName == null) {
                            packageName = WSDLUtils.getPackageName(portType, (Map)this.javaWSDLParam_.getMappings());
                        }
                        if (this.portTypeToSEIMapping != null && (implBeanName = this.getSEIName(portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart())) != null) {
                            implBeanName = String.valueOf(implBeanName) + "Impl";
                        }
                        if (implBeanName == null) {
                            implBeanName = this.genImplBeanName(packageName, portType.getQName().getLocalPart());
                        }
                        if (this.portTypeToSEIMapping != null) {
                            if (this.getSEIName(portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart()) != null) {
                                wsdlPort2ImplBeanMapping.put(portType2PortMapping.get(portType), implBeanName);
                            }
                        } else {
                            wsdlPort2ImplBeanMapping.put(portType2PortMapping.get(portType), implBeanName);
                        }
                    } else {
                        packageName = this.getPackageName(port.getBinding().getQName().getNamespaceURI());
                        if (packageName == null) {
                            packageName = WSDLUtils.getPackageName(port, (Map)this.javaWSDLParam_.getMappings());
                        }
                        implBeanName = this.genImplBeanName(packageName, port.getBinding().getQName().getLocalPart());
                    }
                } else {
                    portType2PortMapping.put(portType, port);
                    portType2BindingMapping.put(portType, port.getBinding());
                    packageName = this.getPackageName(port.getBinding().getQName().getNamespaceURI());
                    if (packageName == null) {
                        packageName = WSDLUtils.getPackageName(port, (Map)this.javaWSDLParam_.getMappings());
                    }
                    implBeanName = this.genImplBeanName(packageName, port.getBinding().getQName().getLocalPart());
                }
                if (this.portTypeToSEIMapping != null) {
                    if (this.getSEIName(portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart()) == null) continue;
                    wsdlPort2ImplBeanMapping.put(port, implBeanName);
                    continue;
                }
                wsdlPort2ImplBeanMapping.put(port, implBeanName);
            }
        }
        this.javaWSDLParam_.setWSDLPort2ImplBeanMapping(wsdlPort2ImplBeanMapping);
    }

    public String genImplBeanName(String packageName, String localname) {
        StringBuffer sb = new StringBuffer();
        if (packageName != null && packageName.trim().length() > 0) {
            sb.append(packageName);
            sb.append(".");
        }
        String computedResult = null;
        if (this.wsdl2JavaCommand_ != null) {
            if (this.wsdl2JavaCommand_ instanceof AbstractEmitterCommand) {
                ((AbstractEmitterCommand)this.wsdl2JavaCommand_).setEmitterData((Object)this.javaWSDLParam_);
            }
            computedResult = this.wsdl2JavaCommand_.xmlNameToJava(localname);
        }
        if (computedResult == null) {
            computedResult = WSDLUtils.resolveDotInPortName(localname);
        }
        sb.append(computedResult.substring(0, 1).toUpperCase());
        sb.append(computedResult.substring(1));
        sb.append("Impl");
        return sb.toString();
    }

    public Definition getDefinition(String wsdlURI) {
        if (wsdlURI.indexOf(58) < 0 || wsdlURI.indexOf("platform:/resource") >= 0) {
            wsdlURI = PlatformUtils.getFileURLFromPlatform(wsdlURI);
        }
        if (this.parser_ == null) {
            this.parser_ = new WebServicesParserExt(wsdlURI);
        }
        return this.parser_.getWSDLDefinition(wsdlURI);
    }

    private void executeBottomUp() {
        Definition definition = this.getDefinition(this.javaWSDLParam_.getOutputWsdlLocation());
        Service service = (Service)definition.getServices().values().iterator().next();
        HashMap<Port, String> wsdlPort2ImplBeanMapping = new HashMap<Port, String>();
        for (Port port : service.getPorts().values()) {
            wsdlPort2ImplBeanMapping.put(port, this.javaWSDLParam_.getBeanName());
        }
        this.javaWSDLParam_.setWSDLPort2ImplBeanMapping(wsdlPort2ImplBeanMapping);
    }

    public void setWSParser(WebServicesParser parser) {
        this.parser_ = parser;
    }

    public WebServicesParser getWSParser() {
        return this.parser_;
    }

    public void setTopDown(boolean isTopDown_) {
        this.isTopDown_ = isTopDown_;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaParameter_) {
        this.javaWSDLParam_ = javaParameter_;
    }

    public void setWsdl2JavaCommand(AbstractEmitterCommand wsdl2JavaCommand) {
        if (wsdl2JavaCommand instanceof AbstractWSDL2JavaCommand) {
            this.wsdl2JavaCommand_ = (AbstractWSDL2JavaCommand)wsdl2JavaCommand;
        }
    }

    private String getPackageName(String namespace) {
        if (this.namespaceToPackageMapping != null && namespace != null) {
            return (String)this.namespaceToPackageMapping.get(namespace);
        }
        return null;
    }

    public void setNamespaceToPackageMapping(Hashtable namespaceToPackageMapping) {
        this.namespaceToPackageMapping = namespaceToPackageMapping;
    }

    public void setPortTypeToSEIMapping(Hashtable portTypeToSEIMapping) {
        this.portTypeToSEIMapping = portTypeToSEIMapping;
    }

    private String getSEIName(String namespace, String localPart) {
        if (this.portTypeToSEIMapping != null && namespace != null && localPart != null) {
            return (String)this.portTypeToSEIMapping.get(String.valueOf(namespace) + ":" + localPart);
        }
        return null;
    }
}

