/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.taghandler.scenarios;

import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.EJBBinding;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.ParameterStyleType;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.SOAPBinding;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.SOAPBindingJms;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.StyleType;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.UseType;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebService;
import com.ibm.ast.ws.rd.annotations.WebServicesDoclet.WebServicesClassLevelTags;
import com.ibm.ast.ws.rd.taghandler.WSInfo;
import com.ibm.ast.ws.rd.utils.WRDEmitterCommandsRegistry;
import com.ibm.etools.webservice.was.consumption.registry.EmitterCommandsExtension;
import com.ibm.etools.webservice.was.consumption.registry.EmitterCommandsRegistry;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.ws.rd.j2ee.utils.J2EEEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SaveWSDLInfo {
    protected JavaWSDLParameterBase java2WsdlParameter_;
    protected EmitterCommandsExtension emitterExtension_;
    protected String beanName_;
    private WSInfo info_;
    private IProject freeFormProject_;
    private IVirtualComponent component_;
    private String seiName_;
    private String targetJ2eeVersion_;

    public SaveWSDLInfo(WSInfo info, IProject freeFormProject, IVirtualComponent component, String seiName) {
        this.info_ = info;
        this.freeFormProject_ = freeFormProject;
        this.component_ = component;
        this.seiName_ = seiName;
        this.targetJ2eeVersion_ = null;
    }

    void process() {
        if (this.freeFormProject_ != null) {
            IVirtualComponent earComponent = J2EEEnvironment.getApplicationComponent((IProject)this.freeFormProject_, (boolean)true);
            EARArtifactEdit earArtifactEdit = null;
            try {
                earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)earComponent);
                this.targetJ2eeVersion_ = this.getJ2EETextVersion((EnterpriseArtifactEdit)earArtifactEdit);
            }
            finally {
                if (earArtifactEdit != null) {
                    earArtifactEdit.dispose();
                }
            }
            this.emitterExtension_ = "1.3".equals(this.targetJ2eeVersion_) ? EmitterCommandsRegistry.getInstance().getBestEmitterCommandsExtension("1.3", "7.0.0") : EmitterCommandsRegistry.getInstance().getBestEmitterCommandsExtension("5.0", "7.0.0");
        } else {
            if (J2EEUtils.isWebComponent((IVirtualComponent)this.component_)) {
                WebArtifactEdit webArtifactEdit = null;
                try {
                    webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component_);
                    this.targetJ2eeVersion_ = this.getJ2EETextVersion((EnterpriseArtifactEdit)webArtifactEdit);
                }
                finally {
                    if (webArtifactEdit != null) {
                        webArtifactEdit.dispose();
                    }
                }
            }
            EJBArtifactEdit ejbArtifactEdit = null;
            try {
                ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)this.component_);
                this.targetJ2eeVersion_ = this.getJ2EETextVersion((EnterpriseArtifactEdit)ejbArtifactEdit);
            }
            finally {
                if (ejbArtifactEdit != null) {
                    ejbArtifactEdit.dispose();
                }
            }
            this.emitterExtension_ = WRDEmitterCommandsRegistry.getBestEmitterCommandExtension(this.component_.getProject(), this.targetJ2eeVersion_);
        }
        this.java2WsdlParameter_ = this.emitterExtension_.getJavaWSDLParam();
        this.setJava2WsdlParms(this.java2WsdlParameter_);
    }

    private String getJ2EETextVersion(EnterpriseArtifactEdit enterpriseArtifactEdit) {
        return J2EEVersionUtil.getJ2EETextVersion((int)enterpriseArtifactEdit.getJ2EEVersion());
    }

    public JavaWSDLParameterBase getJava2WSDLParameter() {
        return this.java2WsdlParameter_;
    }

    public EmitterCommandsExtension getEmitterExtension() {
        return this.emitterExtension_;
    }

    public String getBeanName() {
        return this.beanName_;
    }

    public String getEJBName() {
        return this.info_.getEjbName();
    }

    public String getTargetJ2eeVersion() {
        return this.targetJ2eeVersion_;
    }

    protected void setJava2WsdlParms(JavaWSDLParameterBase parms) {
        IType javaType = this.info_.getJavaType();
        this.beanName_ = javaType.getElementName();
        String className = javaType.getFullyQualifiedName();
        parms.setSEIName(this.seiName_);
        parms.setBeanName(className);
        if (parms.getServicePortName() == null) {
            parms.setServicePortName(this.beanName_);
        }
        if (parms.getPortTypeName() == null) {
            parms.setPortTypeName(this.beanName_);
        }
        IProject sourceProject = this.freeFormProject_ != null ? this.freeFormProject_ : this.component_.getProject();
        parms.setProject(sourceProject);
        this.setWSDLGenerationParms(parms);
    }

    private void setWSDLGenerationParms(JavaWSDLParameterBase parms) {
        WebServicesClassLevelTags wsClassLevelTags = this.info_.getWebServicesClassLevelTags();
        SOAPBinding hi = wsClassLevelTags.getSOAPBinding();
        SOAPBindingJms ji = wsClassLevelTags.getSOAPBindingJms();
        EJBBinding ejbi = wsClassLevelTags.getEJBBinding();
        WebService wi = wsClassLevelTags.getWebService();
        if (wi == null) {
            return;
        }
        this.setWebServiceInfo(parms, wi);
        if (this.info_.isEjbWebServiceScenario()) {
            parms.setServerSide((byte)2);
        } else {
            parms.setServerSide((byte)1);
        }
        this.setBindingTypesInfo(parms, hi, ji, ejbi);
        this.setBindingProperties(parms, hi, ji, ejbi);
        if (hi != null) {
            this.setHttpBindingInfo(parms, hi);
        }
        if (ji != null) {
            this.setJMSBindingInfo(parms, ji);
        }
        if (ejbi != null) {
            this.setEJBBindingInfo(parms, ejbi);
        }
    }

    private void setSOAPBindingInfo(JavaWSDLParameterBase parms, SOAPBinding sb) {
        UseType ut = sb.getUse();
        if (ut != null) {
            parms.setUse(ut.getName());
        } else {
            parms.setUse("LITERAL");
        }
        StyleType st = sb.getStyle();
        if (st != null) {
            parms.setStyle(st.getName());
        } else {
            parms.setStyle("DOCUMENT");
        }
        ParameterStyleType pst = sb.getParameterStyle();
        if (pst != null) {
            switch (pst.getValue()) {
                case 2: {
                    parms.setWrapped(false);
                    break;
                }
                case 0: {
                    parms.setWrapped(true);
                }
            }
        }
    }

    private void setJMSBindingInfo(JavaWSDLParameterBase parms, SOAPBindingJms ji) {
        String bindingName;
        this.setSOAPBindingInfo(parms, ji);
        String portName = ji.getPortName();
        if (portName != null) {
            parms.setJmsServicePortName(portName);
        }
        if ((bindingName = ji.getBindingName()) != null) {
            parms.setJmsBindingName(bindingName);
        }
    }

    private void setHttpBindingInfo(JavaWSDLParameterBase parms, SOAPBinding hi) {
        String bindingName;
        this.setSOAPBindingInfo(parms, hi);
        String portName = hi.getPortName();
        if (portName != null) {
            parms.setHttpServicePortName(portName);
        }
        if ((bindingName = hi.getBindingName()) != null) {
            parms.setHttpBindingName(bindingName);
        }
    }

    private void setEJBBindingInfo(JavaWSDLParameterBase parms, EJBBinding ejbi) {
        if (ejbi.getPortName() != null) {
            parms.setEjbServicePortName(ejbi.getPortName());
        }
        if (ejbi.getBindingName() != null) {
            parms.setEjbBindingName(ejbi.getBindingName());
        }
    }

    private Collection convertPropertiesStringToCollection(String keyValueStrings) {
        ArrayList<String> properties = new ArrayList<String>();
        if (keyValueStrings != null && keyValueStrings.length() > 0) {
            int commaPos = 0;
            while (commaPos != -1) {
                String keyValue;
                commaPos = keyValueStrings.indexOf(44);
                if (commaPos == -1) {
                    keyValue = keyValueStrings.trim();
                } else {
                    keyValue = keyValueStrings.substring(0, commaPos);
                    keyValueStrings = keyValueStrings.substring(commaPos + 1, keyValueStrings.length());
                }
                properties.add(keyValue.trim());
            }
        }
        return properties;
    }

    private void setBindingProperties(JavaWSDLParameterBase parms, SOAPBinding hi, SOAPBindingJms ji, EJBBinding ejbi) {
        Vector properties = new Vector();
        if (hi != null && hi.getProperties() != null) {
            properties.addAll(this.convertPropertiesStringToCollection(hi.getProperties()));
        }
        if (ji != null && ji.getProperties() != null) {
            properties.addAll(this.convertPropertiesStringToCollection(ji.getProperties()));
        }
        if (ejbi != null && ejbi.getProperties() != null) {
            properties.addAll(this.convertPropertiesStringToCollection(ejbi.getProperties()));
        }
        if (properties.size() > 0) {
            Object[] sa = new String[properties.size()];
            properties.copyInto(sa);
            parms.setArbitraryProperties((String[])sa);
        }
    }

    private void setBindingTypesInfo(JavaWSDLParameterBase parms, SOAPBinding hi, SOAPBindingJms ji, EJBBinding ejbi) {
        StringBuffer bindingTypes = new StringBuffer();
        if (hi != null) {
            bindingTypes.append("http");
            if (ji != null || ejbi != null) {
                bindingTypes.append(',');
            }
        }
        if (ji != null) {
            bindingTypes.append("jms");
            if (ejbi != null) {
                bindingTypes.append(',');
            }
        }
        if (ejbi != null) {
            bindingTypes.append("ejb");
        }
        if (bindingTypes.length() == 0) {
            bindingTypes.append("http");
        }
        parms.setBindingTypes(bindingTypes.toString());
    }

    private void setWebServiceInfo(JavaWSDLParameterBase parms, WebService wi) {
        String targetNamespace;
        String serviceElementName;
        String portTypeName = wi.getName();
        if (portTypeName != null) {
            parms.setPortTypeName(portTypeName);
        }
        if ((serviceElementName = wi.getServiceName()) != null) {
            parms.setServiceElementName(serviceElementName);
        }
        if ((targetNamespace = wi.getTargetNamespace()) != null) {
            parms.setNamespace(targetNamespace);
        }
    }
}

