/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.taghandler.scenarios;

import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.taghandler.WSInfo;
import com.ibm.ast.ws.rd.taghandler.scenarios.SaveWSDLInfo;
import com.ibm.ast.ws.rd.taghandler.scenarios.Scenario;
import com.ibm.ast.ws.rd.utils.PlatformUtils;
import com.ibm.ast.ws.rd.utils.SEICreationInfo;
import com.ibm.ast.ws.rd.utils.WRDStatusHandler;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.ws.rd.utils.WRDUtilFactory;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IURLProvider;

public abstract class BottomUpScenario
extends Scenario {
    protected SEICreationInfo seiInfo;
    protected IEnvironment env_;
    private MessageUtils msgUtils_;

    public BottomUpScenario(WSInfo i, IProject fp, IVirtualComponent c) {
        super(i, fp, c);
        TransientResourceContext context = new TransientResourceContext();
        context.setCheckoutFilesEnabled(true);
        context.setCreateFoldersEnabled(true);
        context.setOverwriteFilesEnabled(true);
        this.env_ = new EclipseEnvironment(null, (ResourceContext)context, (IStatusHandler)new WRDStatusHandler());
        String pluginId = "com.ibm.ast.ws.rd";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    void process() {
        try {
            SaveWSDLInfo swi = this.invokeSEICodeGeneration();
            if (swi != null) {
                if (swi.getEmitterExtension() == null) {
                    throw new Exception(WebServiceWasConsumptionPlugin.getMessage((String)"MSG_ERROR_J2EE14_EMITTERS_MISSING"));
                }
                this.processSaveWSDLInfo(swi);
            }
        }
        catch (Exception e) {
            IStatus status = StatusUtils.errorStatus((String)this.msgUtils_.getMessage("MSG_ERROR_SEI_GEN"), (Throwable)e);
            RdPlugin.getDefault().getLog().log(status);
        }
    }

    protected void setHttpEndpointUrlInfo(JavaWSDLParameterBase java2WsdlParm, IProject webProject, String portComponentName) {
        IModule module = ServerUtil.getModule((IProject)webProject);
        IServer[] deployedServers = ServerUtil.getServersByModule((IModule)module, null);
        if (deployedServers.length != 0) {
            URL url;
            IServer defaultServer = deployedServers[0];
            IURLProvider urlProvider = (IURLProvider)defaultServer.loadAdapter(IURLProvider.class, null);
            if (urlProvider != null && (url = urlProvider.getModuleRootURL(module)) != null) {
                String s = url.toString();
                StringBuffer buf = new StringBuffer(s.endsWith("/") ? s.substring(0, s.length() - 1) : s);
                buf.append("/services/").append(portComponentName);
                java2WsdlParm.setUrlLocation(buf.toString());
            }
        } else {
            StringBuffer url = new StringBuffer("http://localhost:9080/");
            url.append(webProject.getName()).append("/services/").append(portComponentName);
            java2WsdlParm.setUrlLocation(url.toString());
        }
    }

    protected IStatus invokeJava2Wsdl(JavaWSDLParameterBase java2WsdlParm, AbstractEmitterCommand java2WsdlCommand, IPath targetWsdlRootPath, String wsdlFileRootName) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAdaptable adaptable = null;
        IPath targetWsdlPath = targetWsdlRootPath.addTrailingSeparator().append("wsdl").addTrailingSeparator().append(String.valueOf(wsdlFileRootName) + ".wsdl");
        java2WsdlParm.setOutputWsdlLocation(PlatformUtils.getPlatformURL(targetWsdlPath));
        java2WsdlParm.setMethods(new Hashtable());
        WRDUtilFactory.getMonitor().monitor(RdPlugin.getDefault().getMessage("MSG_INFO_INVOKING_JAVA2WSDL"), 1);
        java2WsdlCommand.setEmitterData((Object)java2WsdlParm);
        java2WsdlCommand.setEnvironment(this.env_);
        try {
            return java2WsdlCommand.execute((IProgressMonitor)monitor, adaptable);
        }
        catch (ExecutionException ee) {
            IStatus status = StatusUtils.errorStatus((Throwable)ee);
            return status;
        }
    }

    protected void prepareWsdl2JavaParameter(JavaWSDLParameterBase java2WsdlParm, JavaWSDLParameterBase wsdl2JavaParm, IPath moduleDDPath) {
        byte serverSide = java2WsdlParm.getServerSide();
        wsdl2JavaParm.setServerSide(serverSide);
        IProject sourceProject = java2WsdlParm.getProject();
        wsdl2JavaParm.setProject(sourceProject);
        String wsdlLocation = java2WsdlParm.getOutputWsdlLocation();
        wsdl2JavaParm.setInputWsdlLocation(wsdlLocation);
        wsdl2JavaParm.setOutputWsdlLocation(wsdlLocation);
        wsdl2JavaParm.setBeanName(java2WsdlParm.getBeanName());
        wsdl2JavaParm.setOutput(PlatformUtils.getPlatformURL(moduleDDPath));
        wsdl2JavaParm.setTempOutput(J2EEUtils.getFileURL((File)J2EEUtils.createTempDir()));
        wsdl2JavaParm.setMetaInfOnly(true);
        wsdl2JavaParm.setSEIName(java2WsdlParm.getSEIName());
        wsdl2JavaParm.setScenario("wrdBottomUpServer");
        wsdl2JavaParm.setBindingTypes(java2WsdlParm.getBindingTypes());
    }

    protected IStatus invokeWsdl2Java(JavaWSDLParameterBase wsdl2JavaParm, AbstractEmitterCommand wsdl2JavaCommand) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IAdaptable adaptable = null;
        wsdl2JavaCommand.setEmitterData((Object)wsdl2JavaParm);
        WRDUtilFactory.getMonitor().monitor(RdPlugin.getDefault().getMessage("MSG_INFO_INVOKING_WSDL2JAVA"), 1);
        wsdl2JavaCommand.setEnvironment(this.env_);
        try {
            return wsdl2JavaCommand.execute((IProgressMonitor)monitor, adaptable);
        }
        catch (ExecutionException ee) {
            IStatus status = StatusUtils.errorStatus((Throwable)ee);
            return status;
        }
    }

    protected final IStatus deleteUnwantedFile(IPath unwantedFilePath) {
        IStatus status = Status.OK_STATUS;
        TransientResourceContext context = new TransientResourceContext();
        try {
            context.setOverwriteFilesEnabled(true);
            context.setCheckoutFilesEnabled(true);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile unwantedFile = root.getFile(unwantedFilePath);
            if (unwantedFile.exists()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                IStatusHandler handler = this.env.getStatusHandler();
                FileResourceUtils.deleteFile((ResourceContext)context, (IFile)unwantedFile, (IProgressMonitor)monitor, (IStatusHandler)handler);
            }
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)e.getMessage(), (Throwable)e);
        }
        return status;
    }

    protected final IStatus deleteUnwantedSoapBindingImpl(JavaWSDLParameterBase wsdl2JavaParm) {
        String rootPathString = PlatformUtils.getPathFromPlatform(wsdl2JavaParm.getDevelopServerJavaOutput());
        IPath rootPath = new Path(rootPathString).addTrailingSeparator();
        String beanName = wsdl2JavaParm.getBeanName();
        String beanNameAsPaths = beanName.replace('.', '/');
        IPath soapBindingImplFilePath = rootPath.append(String.valueOf(beanNameAsPaths) + "SoapBindingImpl.java");
        return this.deleteUnwantedFile(soapBindingImplFilePath);
    }

    protected final IStatus deleteUnwantedSEI(JavaWSDLParameterBase wsdl2JavaParm) {
        String rootPathString = PlatformUtils.getPathFromPlatform(wsdl2JavaParm.getDevelopServerJavaOutput());
        IPath rootPath = new Path(rootPathString).addTrailingSeparator();
        String beanName = wsdl2JavaParm.getBeanName();
        String beanNameAsPaths = beanName.replace('.', '/');
        IPath unwantedSeiPath = rootPath.append(String.valueOf(beanNameAsPaths) + ".java");
        return this.deleteUnwantedFile(unwantedSeiPath);
    }

    protected abstract void processSaveWSDLInfo(SaveWSDLInfo var1);

    protected abstract SaveWSDLInfo invokeSEICodeGeneration();
}

