/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.finder;

import com.ibm.ast.ws.rd.finder.AbstractClientFinder;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client14Finder
extends AbstractClientFinder {
    @Override
    protected boolean canHandle(IFile file) {
        IProject project = file.getProject();
        String strVer = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
        if (strVer == null) {
            return false;
        }
        int version = J2EEVersionUtil.convertVersionStringToInt((String)strVer);
        if (JavaEEProjectUtilities.isApplicationClientProject((IProject)project) && version > 13 && "application-client.xml".equals(file.getName())) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder folder = J2EEUtils.getAppClientDeploymentDescriptorFolder((IVirtualComponent)component);
            return folder.getUnderlyingFolder().equals((Object)file.getParent());
        }
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && version > 23 && "web.xml".equals(file.getName())) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder folder = J2EEUtils.getWebDeploymentDescriptorFolder((IVirtualComponent)component);
            return folder.getUnderlyingFolder().equals((Object)file.getParent());
        }
        if (JavaEEProjectUtilities.isEJBProject((IProject)project) && version > 20 && "ejb-jar.xml".equals(file.getName())) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder folder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
            return folder.getUnderlyingFolder().equals((Object)file.getParent());
        }
        return false;
    }

    private List<?> getFromApplicationClient(IProject project) {
        List serviceRefs = Collections.EMPTY_LIST;
        AppClientArtifactEdit app = AppClientArtifactEdit.getAppClientArtifactEditForRead((IProject)project);
        if (app != null) {
            try {
                try {
                    ApplicationClient appClient = app.getApplicationClient();
                    if (appClient != null) {
                        serviceRefs = appClient.getServiceRefs();
                    }
                }
                catch (Exception exception) {
                    app.dispose();
                }
            }
            finally {
                app.dispose();
            }
        }
        return serviceRefs;
    }

    private List<?> getFromWeb(IProject project) {
        List serviceRefs = Collections.EMPTY_LIST;
        WebArtifactEdit web = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
        if (web != null) {
            try {
                try {
                    WebApp webApp = web.getWebApp();
                    if (webApp != null) {
                        serviceRefs = webApp.getServiceRefs();
                    }
                }
                catch (Exception exception) {
                    web.dispose();
                }
            }
            finally {
                web.dispose();
            }
        }
        return serviceRefs;
    }

    private List<?> getFromEjb(IProject project) {
        ArrayList serviceRefs = new ArrayList();
        EJBArtifactEdit ejb = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)project);
        if (ejb != null) {
            try {
                try {
                    EJBJar ejbJar = ejb.getEJBJar();
                    if (ejbJar != null) {
                        for (Object obj : ejbJar.getEnterpriseBeans()) {
                            EnterpriseBean bean = (EnterpriseBean)obj;
                            serviceRefs.addAll(bean.getServiceRefs());
                        }
                    }
                }
                catch (Exception exception) {
                    ejb.dispose();
                }
            }
            finally {
                ejb.dispose();
            }
        }
        return serviceRefs;
    }

    @Override
    protected List<?> getServiceRefs(IProject project) {
        if (JavaEEProjectUtilities.isApplicationClientProject((IProject)project)) {
            return this.getFromApplicationClient(project);
        }
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            return this.getFromWeb(project);
        }
        return this.getFromEjb(project);
    }
}

