/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.rd.finder;

import com.ibm.ast.ws.rd.finder.AbstractFinder;
import com.ibm.ast.ws.rd.utils.WebServiceMetadataUtil;
import com.ibm.ccl.ws.finder.core.WSInfo;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientFinder
extends AbstractFinder {
    @Override
    protected String getCategoryId() {
        return "jaxrpc.client";
    }

    @Override
    protected void addWebServices(IFile file) {
        IProject project = file.getProject();
        for (Object object : this.getServiceRefs(project)) {
            String name;
            ServiceRef serviceRef = (ServiceRef)object;
            if (WebServiceMetadataUtil.isJaxWsServiceRef(project, serviceRef) || (name = serviceRef.getServiceRefName()) == null) continue;
            this.callback.add(this.newWSInfo(file, name, object));
        }
    }

    @Override
    protected void changeWebServices(IFile file) {
        IProject project = file.getProject();
        List<WSInfo> infos = this.getWebServicesInProject(project);
        for (Object object : this.getServiceRefs(project)) {
            String name;
            ServiceRef serviceRef = (ServiceRef)object;
            if (WebServiceMetadataUtil.isJaxWsServiceRef(project, serviceRef) || (name = serviceRef.getServiceRefName()) == null) continue;
            WSInfo info = this.newEmptyWSInfo(project, name);
            if (infos.contains(info)) {
                infos.remove(info);
                this.callback.clear(info);
                continue;
            }
            this.callback.add(this.newWSInfo(file, name, object));
        }
        for (WSInfo info : infos) {
            this.callback.remove(info);
        }
    }

    public Object getWebServiceObject(WSInfo info, IProgressMonitor monitor) {
        IProject project = info.getProject();
        if (project != null) {
            String name = info.getProperty("_ws_name_");
            for (Object object : this.getServiceRefs(project)) {
                ServiceRef serviceRef = (ServiceRef)object;
                if (!name.equals(serviceRef.getServiceRefName())) continue;
                return object;
            }
        }
        return null;
    }

    public void fillProperties(Object webServiceObject, Map<String, String> properties) {
        ServiceRef serviceRef = (ServiceRef)webServiceObject;
        properties.put("_wsinfo_label_", serviceRef.getServiceRefName());
        properties.put("_wsinfo_icon_", "icons/obj16/serviceref_obj.gif");
        this.setProperty(properties, "_ws_wsdl_file_", serviceRef.getWsdlFile());
        this.setProperty(properties, "_ws_src_name_", WebServiceMetadataUtil.getServiceEndpointInterface(serviceRef));
    }

    protected abstract List<?> getServiceRefs(IProject var1);
}

