/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.deployer;

import com.ibm.ast.ws.deployer.WASDeploy;
import com.ibm.ast.ws.deployer.WASDeploymentModule;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.webservice.command.adapter.EnvironmentAdapter;
import com.ibm.etools.webservice.command.adapter.StatusToStatus;
import com.ibm.etools.webservice.was.consumption.registry.EnvironmentAdapterRegistry;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.internal.emf.utilities.ICommand;
import org.eclipse.wst.common.internal.emf.utilities.ICommandContext;

public class WSDeployer
implements ICommand {
    private final String ID = "com.ibm.etools.webservice.was.consumption.core";
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static IResourceChangeListener listener_;
    private static ArrayList ejbComponentRootFoldersList_;

    static {
        ejbComponentRootFoldersList_ = new ArrayList();
        listener_ = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) {
                        return;
                    }
                    delta.accept(new IResourceDeltaVisitor(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean visit(IResourceDelta d) throws CoreException {
                            String deltaResourceName;
                            IResource deltaResource = d.getResource();
                            if (deltaResource != null && this.isDeployTrigger(deltaResourceName = deltaResource.getName(), d)) {
                                IVirtualResource[] vDeltaResources = ComponentCore.createResources((IResource)deltaResource);
                                if (vDeltaResources.length < 1) {
                                    return true;
                                }
                                IVirtualResource vDeltaResource = vDeltaResources[0];
                                IVirtualComponent component = vDeltaResource.getComponent();
                                IProject project = component.getProject();
                                IContainer componentRootFolder = component.getRootFolder().getUnderlyingResource().getParent();
                                QualifiedName qualifiedName = WASDeploymentModule.MAX_TRIGGER_TIMESTAMP;
                                synchronized (qualifiedName) {
                                    Long maxTriggerTimeStampLong = (Long)componentRootFolder.getSessionProperty(WASDeploymentModule.MAX_TRIGGER_TIMESTAMP);
                                    if (maxTriggerTimeStampLong != null) {
                                        long maxTriggerTimeStamp = maxTriggerTimeStampLong;
                                        long deltaResourceModificationStamp = deltaResource.getLocalTimeStamp();
                                        if (WSDeployer.isTraceEnabled()) {
                                            System.out.println("Resource: " + deltaResource.getFullPath() + " : " + deltaResourceModificationStamp);
                                        }
                                        if (deltaResourceModificationStamp < 0L || deltaResourceModificationStamp > maxTriggerTimeStamp) {
                                            this.enableDeployment(project, component, (IResource)componentRootFolder);
                                        }
                                    } else {
                                        this.enableDeployment(project, component, (IResource)componentRootFolder);
                                    }
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private final void enableDeployment(IProject project, IVirtualComponent component, IResource componentRootFolder) {
                            QualifiedName qualifiedName = WASDeploymentModule.DEPLOYED_FLAG;
                            synchronized (qualifiedName) {
                                if (JavaEEProjectUtilities.isUtilityProject((IProject)project)) {
                                    this.handleUtilityCase(component);
                                } else {
                                    try {
                                        if (componentRootFolder.getSessionProperty(WASDeploymentModule.DEPLOYED_FLAG) == null) {
                                            return;
                                        }
                                        componentRootFolder.setSessionProperty(WASDeploymentModule.DEPLOYED_FLAG, null);
                                        if (WSDeployer.isTraceEnabled()) {
                                            System.out.println(">> WSDEPLOY enabled for: " + project.getName());
                                        }
                                    }
                                    catch (CoreException coreException) {}
                                }
                            }
                        }

                        private final void handleUtilityCase(IVirtualComponent utilityComponent) {
                            IVirtualComponent[] referencingComponents = utilityComponent.getReferencingComponents();
                            IResource[] componentRootFolders = this.getEJBComponentRootFolders(referencingComponents);
                            int i = 0;
                            while (i < componentRootFolders.length) {
                                try {
                                    if (componentRootFolders[i].getSessionProperty(WASDeploymentModule.DEPLOYED_FLAG) != null) {
                                        componentRootFolders[i].setSessionProperty(WASDeploymentModule.DEPLOYED_FLAG, null);
                                        if (WSDeployer.isTraceEnabled()) {
                                            System.out.println(">> WSDEPLOY(EJB) enabled for: " + componentRootFolders[i].getProject().getName());
                                        }
                                    }
                                }
                                catch (CoreException coreException) {}
                                ++i;
                            }
                        }

                        private final IResource[] getEJBComponentRootFolders(IVirtualComponent[] referencingComponents) {
                            ejbComponentRootFoldersList_.clear();
                            int i = 0;
                            while (i < referencingComponents.length) {
                                if (JavaEEProjectUtilities.isEJBProject((IProject)referencingComponents[i].getProject())) {
                                    ejbComponentRootFoldersList_.add(referencingComponents[i].getRootFolder().getUnderlyingResource().getParent());
                                }
                                ++i;
                            }
                            IResource[] resources = new IResource[ejbComponentRootFoldersList_.size()];
                            ejbComponentRootFoldersList_.toArray(resources);
                            return resources;
                        }
                    });
                }
                catch (CoreException coreException) {}
            }

            /*
             * Enabled aggressive exception aggregation
             */
            public boolean isDeployTrigger(String resourceName, IResourceDelta resDelta) {
                if ("webservices.xml".equals(resourceName)) {
                    return true;
                }
                if ("ejb-jar.xml".equals(resourceName)) {
                    return true;
                }
                if ("web.xml".equals(resourceName)) {
                    return true;
                }
                if ("application-client.xml".equals(resourceName)) {
                    return true;
                }
                if ("webservicesclient.xml".equals(resourceName)) {
                    return true;
                }
                if (resourceName.endsWith("mapping.xml")) {
                    return true;
                }
                if (resourceName.length() > 5) {
                    String extension = resourceName.substring(resourceName.length() - 5);
                    if (extension.equalsIgnoreCase(".wsdl")) {
                        return true;
                    }
                    if (extension.equals(".java") && resDelta != null && resDelta.getKind() != 1) {
                        if (resourceName.endsWith("_Ser.java") || resourceName.endsWith("_Deser.java") || resourceName.endsWith("_Helper.java") || resourceName.endsWith("_DeserProxy.java") || resourceName.endsWith("Locator.java") || resourceName.endsWith("Information.java")) {
                            return true;
                        }
                        if (resourceName.endsWith("Stub.java")) {
                            IResource resource = resDelta.getResource();
                            ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
                            try {
                                IType[] types = cu.getTypes();
                                int i = 0;
                                while (i < types.length) {
                                    String superClassName = types[i].getSuperclassName();
                                    String[][] resolvedTypeNames = types[i].resolveType(superClassName);
                                    if (resolvedTypeNames != null) {
                                        int j = 0;
                                        while (j < resolvedTypeNames.length) {
                                            int k = 1;
                                            while (k < resolvedTypeNames[0].length) {
                                                String packageName = resolvedTypeNames[j][0];
                                                String className = resolvedTypeNames[j][k];
                                                if ("com.ibm.ws.webservices.engine.client".equals(packageName) && "Stub".equals(className)) {
                                                    return true;
                                                }
                                                ++k;
                                            }
                                            ++j;
                                        }
                                    }
                                    ++i;
                                }
                                return false;
                            }
                            catch (JavaModelException e) {
                                if (WSDeployer.isTraceEnabled()) {
                                    System.err.println("JavaModelException: " + e.getMessage());
                                    e.printStackTrace(System.err);
                                }
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener_);
    }

    public static final boolean isTraceEnabled() {
        return Platform.inDebugMode() && "true".equals(Platform.getDebugOption((String)"com.ibm.etools.webservice.was.deploy.core/debug"));
    }

    public void init(Object[] selection) {
    }

    private final boolean runWSDeploy(EnterpriseArtifactEdit enterpriseArtifactEdit) throws CoreException {
        IEnvironment env;
        if (enterpriseArtifactEdit == null) {
            return true;
        }
        WASDeploy wasDeploy = new WASDeploy(enterpriseArtifactEdit);
        EnvironmentAdapter adapter = EnvironmentAdapterRegistry.getInstance().getAdapter();
        Environment environment = adapter.adapt(env = adapter.getDefaultEnvironment());
        Status status = wasDeploy.execute(environment);
        if (status.getSeverity() >= 2 || status.getThrowable() != null) {
            throw new CoreException((IStatus)new StatusToStatus(status));
        }
        return true;
    }

    private final void collectStatusMessages(Status status, StringBuffer statusMessages) {
        Throwable statusThrowable;
        String message = status.getMessage();
        if (message != null && message.trim().length() > 0) {
            statusMessages.append(this.LINE_SEPARATOR).append(message);
        }
        if ((statusThrowable = status.getThrowable()) != null) {
            StringWriter exceptionTrace = new StringWriter();
            statusThrowable.printStackTrace(new PrintWriter(exceptionTrace));
            statusMessages.append(this.LINE_SEPARATOR).append(exceptionTrace.getBuffer());
        }
        if (status.hasChildren()) {
            Status[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectStatusMessages(children[i], statusMessages);
                ++i;
            }
        }
    }

    public boolean execute(IResource resource, IResourceDelta delta, ICommandContext context) throws CoreException {
        if (WSDeployer.isTraceEnabled()) {
            System.out.println("WSDeploy executing for: " + resource.getFullPath().toString());
        }
        boolean deployResult = true;
        if (resource instanceof IProject) {
            IVirtualComponent resourceComponent = ComponentCore.createComponent((IProject)((IProject)resource));
            if (J2EEUtils.isEARComponent((IVirtualComponent)resourceComponent)) {
                EARArtifactEdit earArtifactEdit = null;
                try {
                    earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)resourceComponent);
                    IVirtualReference[] earReferences = EarUtilities.getJ2EEModuleReferences((IVirtualComponent)resourceComponent);
                    int j = 0;
                    while (j < earReferences.length) {
                        IVirtualComponent component = earReferences[j].getReferencedComponent();
                        deployResult = deployResult && this.processModuleComponent(component);
                        ++j;
                    }
                }
                finally {
                    if (earArtifactEdit != null) {
                        earArtifactEdit.dispose();
                    }
                }
            } else {
                boolean bl = deployResult = deployResult && this.processModuleComponent(resourceComponent);
            }
        }
        if (WSDeployer.isTraceEnabled()) {
            System.out.println("WSDeploy completed for: " + resource.getFullPath().toString());
        }
        return deployResult;
    }

    private boolean processModuleComponent(IVirtualComponent component) throws CoreException {
        if (J2EEUtils.isEJBComponent((IVirtualComponent)component)) {
            EJBArtifactEdit ejbArtifactEdit = null;
            try {
                ejbArtifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                boolean bl = this.runWSDeploy((EnterpriseArtifactEdit)ejbArtifactEdit);
                return bl;
            }
            finally {
                if (ejbArtifactEdit != null) {
                    ejbArtifactEdit.dispose();
                }
            }
        }
        if (J2EEUtils.isWebComponent((IVirtualComponent)component)) {
            WebArtifactEdit webArtifactEdit = null;
            try {
                webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
                boolean bl = this.runWSDeploy((EnterpriseArtifactEdit)webArtifactEdit);
                return bl;
            }
            finally {
                if (webArtifactEdit != null) {
                    webArtifactEdit.dispose();
                }
            }
        }
        if (J2EEUtils.isAppClientComponent((IVirtualComponent)component)) {
            AppClientArtifactEdit appClientArtifactEdit = null;
            try {
                appClientArtifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IVirtualComponent)component);
                boolean bl = this.runWSDeploy((EnterpriseArtifactEdit)appClientArtifactEdit);
                return bl;
            }
            finally {
                if (appClientArtifactEdit != null) {
                    appClientArtifactEdit.dispose();
                }
            }
        }
        return true;
    }
}

