/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.deployer;

import com.ibm.ast.ws.deployer.ClasspathResolver;
import com.ibm.ast.ws.deployer.WSDeployer;
import com.ibm.ast.ws.rd.plugin.RdPlugin;
import com.ibm.ast.ws.rd.utils.WebServiceMetadataUtil;
import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.webservice.deploy.core.AbstractDeploymentModule;
import com.ibm.etools.webservice.deploy.core.DeployModel;
import com.ibm.etools.webservice.deploy.core.WebserviceClient;
import com.ibm.etools.webservice.deploy.core.WebserviceXMLException;
import com.ibm.etools.webservice.deploy.core.Webservices;
import com.ibm.etools.webservice.was.ext.model.WscbndArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSCDDArtifactEdit;
import org.eclipse.jst.j2ee.internal.webservice.componentcore.util.WSDDArtifactEdit;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.environment.NullStatusHandler;

public abstract class WASDeploymentModule
extends AbstractDeploymentModule {
    protected EnterpriseArtifactEdit enterpriseArtifactEdit_;
    private Hashtable resourceTable_;
    private IJavaProject destinationJavaProject_;
    private IVirtualComponent outputComponent_;
    private IContainer defaultServiceOutputContainer_;
    private IContainer defaultClientOutputContainer_;
    public static final QualifiedName DEPLOYED_FLAG = J2EEUtils.DEPLOYED_FLAG;
    public static final QualifiedName MAX_TRIGGER_TIMESTAMP = J2EEUtils.MAX_TRIGGER_TIMESTAMP;

    public WASDeploymentModule(EnterpriseArtifactEdit enterpriseArtifactEdit) {
        super(WASDeploymentModule.getModel());
        this.enterpriseArtifactEdit_ = enterpriseArtifactEdit;
        this.resourceTable_ = new Hashtable();
    }

    protected boolean isJaxRpc(Object metaObject) {
        if (metaObject instanceof WebServiceDescription) {
            WebServiceDescription wsDesc = (WebServiceDescription)metaObject;
            return !WebServiceMetadataUtil.isJaxWsService(this.enterpriseArtifactEdit_.getProject(), wsDesc);
        }
        if (metaObject instanceof ServiceRef) {
            ServiceRef serviceRef = (ServiceRef)metaObject;
            return !WebServiceMetadataUtil.isJaxWsServiceRef(this.enterpriseArtifactEdit_.getProject(), serviceRef);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status execute(Environment environment) {
        Status status;
        block24: {
            IContainer componentRootFolder;
            block23: {
                block21: {
                    IVirtualComponent component = this.enterpriseArtifactEdit_.getComponent();
                    IProject project = component.getProject();
                    componentRootFolder = component.getRootFolder().getUnderlyingResource().getParent();
                    if (JemProjectUtilities.isBinaryProject((IProject)project)) {
                        return new SimpleStatus("");
                    }
                    try {
                        if (!J2EEPlugin.getDefault().getJ2EEPreferences().isIncrementalDeploymentEnabled()) break block21;
                        QualifiedName qualifiedName = DEPLOYED_FLAG;
                        synchronized (qualifiedName) {
                            if (componentRootFolder.getSessionProperty(DEPLOYED_FLAG) != null) {
                                return new SimpleStatus("");
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
                try {
                    try {
                        status = super.execBase(environment);
                    }
                    catch (Exception e) {
                        status = new SimpleStatus("", this.getMessage("ERROR_EXCEPTION_THROWN", e.toString()), 4, (Throwable)e);
                        this.cleanupModule();
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.cleanupModule();
                    throw throwable;
                }
                this.cleanupModule();
            }
            if (status.getSeverity() < 4) {
                try {
                    QualifiedName e = DEPLOYED_FLAG;
                    synchronized (e) {
                        componentRootFolder.setSessionProperty(DEPLOYED_FLAG, (Object)Boolean.TRUE);
                        long deployTimeStamp = System.currentTimeMillis();
                        QualifiedName qualifiedName = MAX_TRIGGER_TIMESTAMP;
                        synchronized (qualifiedName) {
                            componentRootFolder.setSessionProperty(MAX_TRIGGER_TIMESTAMP, (Object)new Long(deployTimeStamp));
                        }
                        if (WSDeployer.isTraceEnabled()) {
                            System.out.println("<< " + componentRootFolder.getProject().getName() + " is fully deployed... " + deployTimeStamp);
                        }
                    }
                }
                catch (CoreException e) {
                    if (!WSDeployer.isTraceEnabled()) break block24;
                    System.err.println("WSDeploymentModule: Unable to set deployment status: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return status;
    }

    protected Webservices gatherWebservices() {
        IProject project = this.enterpriseArtifactEdit_.getProject();
        WSDDArtifactEdit edit = null;
        try {
            edit = WSDDArtifactEdit.getWSDDArtifactEditForRead((IProject)project);
            Webservices webservices = new Webservices(edit.getWebServices());
            return webservices;
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    protected WebserviceClient gatherWebserviceClients() {
        block30: {
            ClientBinding clientBinding;
            WscbndArtifactEdit edit;
            IVirtualComponent component;
            block28: {
                component = this.enterpriseArtifactEdit_.getComponent();
                edit = null;
                edit = WscbndArtifactEdit.getWSCBNDArtifactEditForRead((IVirtualComponent)component);
                clientBinding = edit.getClientBinding();
                if (!"1.3".equals(J2EEUtils.getJ2EEVersion((IProject)component.getProject()))) break block28;
                IVirtualFile wscXmlDDFile = null;
                wscXmlDDFile = J2EEUtils.isWebComponent((IVirtualComponent)component) ? J2EEUtils.getDeploymentDescriptorFile((IVirtualComponent)component, (String)"WEB-INF/webservicesclient.xml") : J2EEUtils.getDeploymentDescriptorFile((IVirtualComponent)component, (String)"META-INF/webservicesclient.xml");
                if (!wscXmlDDFile.exists()) {
                    return null;
                }
                WSCDDArtifactEdit wscEdit = null;
                try {
                    wscEdit = WSCDDArtifactEdit.getWSCDDArtifactEditForRead((IVirtualComponent)component);
                    WebserviceClient webserviceClient = new WebserviceClient(wscEdit.getWebServicesClient(), clientBinding);
                    return webserviceClient;
                }
                finally {
                    if (wscEdit != null) {
                        wscEdit.dispose();
                    }
                }
            }
            if (JavaEEProjectUtilities.isEJBComponent((IVirtualComponent)component) && J2EEUtils.getDeploymentDescriptorFile((IVirtualComponent)component, (String)"META-INF/ejb-jar.xml").exists()) {
                EJBArtifactEdit ejbEdit = null;
                try {
                    ejbEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
                    WebserviceClient webserviceClient = new WebserviceClient(ejbEdit.getEJBJar(), clientBinding);
                    return webserviceClient;
                }
                finally {
                    if (ejbEdit != null) {
                        ejbEdit.dispose();
                    }
                }
            }
            if (JavaEEProjectUtilities.isApplicationClientComponent((IVirtualComponent)component) && J2EEUtils.getDeploymentDescriptorFile((IVirtualComponent)component, (String)"META-INF/application-client.xml").exists()) {
                AppClientArtifactEdit appClientEdit = null;
                try {
                    appClientEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IVirtualComponent)component);
                    WebserviceClient webserviceClient = new WebserviceClient(appClientEdit.getApplicationClient(), clientBinding);
                    return webserviceClient;
                }
                finally {
                    if (appClientEdit != null) {
                        appClientEdit.dispose();
                    }
                }
            }
            if (JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)component) && J2EEUtils.getDeploymentDescriptorFile((IVirtualComponent)component, (String)"WEB-INF/web.xml").exists()) {
                WebserviceClient webserviceClient;
                block29: {
                    WebArtifactEdit webEdit = null;
                    try {
                        webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
                        webserviceClient = new WebserviceClient(webEdit.getWebApp(), clientBinding);
                        if (webEdit == null) break block29;
                    }
                    catch (Throwable throwable) {
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                        throw throwable;
                    }
                    webEdit.dispose();
                }
                return webserviceClient;
            }
            break block30;
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return null;
    }

    private static DeployModel getModel() {
        DeployModel model = new DeployModel();
        ResourceBundle resource = ResourceBundle.getBundle("com.ibm.etools.webservice.deploy.core.deploy");
        model.setBundle(resource);
        model.setCodeGenOnly(false);
        model.setDeployClient(true);
        model.setDeployService(true);
        model.setTrace(true);
        model.setDoValidation(false);
        model.getClassPath().appendPath(System.getProperty("java.class.path"));
        return model;
    }

    protected int getModuleType() {
        int result = UNKNOWN_MODULE;
        IVirtualComponent component = this.enterpriseArtifactEdit_.getComponent();
        if (J2EEUtils.isEJBComponent((IVirtualComponent)component)) {
            return EJB_MODULE;
        }
        if (J2EEUtils.isWebComponent((IVirtualComponent)component)) {
            return WEB_MODULE;
        }
        if (J2EEUtils.isAppClientComponent((IVirtualComponent)component)) {
            return JAVA_MODULE;
        }
        return result;
    }

    protected Status setupModule() {
        SimpleStatus status = new SimpleStatus("");
        try {
            this.outputComponent_ = this.enterpriseArtifactEdit_.getComponent();
            IPackageFragmentRoot[] pkgFragmentRoots = J2EEProjectUtilities.getSourceContainers((IProject)this.outputComponent_.getProject());
            if (pkgFragmentRoots == null || pkgFragmentRoots.length < 1) {
                if (WSDeployer.isTraceEnabled()) {
                    System.out.println("Web service deployer ignored project with no source folders: " + this.outputComponent_.getProject());
                }
                return new SimpleStatus("", RdPlugin.getDefault().getMessage("MSG_WARN_IGNORE_PROJECT_NO_SRC", new Object[]{this.outputComponent_.getProject().getName()}), 2);
            }
            IPath clientOutputPath = pkgFragmentRoots[0].getUnderlyingResource().getFullPath();
            IPath serviceOutputPath = J2EEUtils.hasWasXDocletSupport((IProject)this.outputComponent_.getProject()) ? this.outputComponent_.getRootFolder().getUnderlyingFolder().getParent().getFolder((IPath)new Path("gen/src")).getFullPath() : clientOutputPath;
            this.defaultServiceOutputContainer_ = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(serviceOutputPath);
            this.defaultClientOutputContainer_ = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(clientOutputPath);
            if (WSDeployer.isTraceEnabled()) {
                System.out.println("defaultServiceOutputContainer_ = " + this.defaultServiceOutputContainer_.getFullPath());
                System.out.println("defaultClientOutputContainer_ = " + this.defaultClientOutputContainer_.getFullPath());
            }
            this.destinationJavaProject_ = JavaCore.create((IProject)this.outputComponent_.getProject());
            this.tempDir_ = File.createTempFile("WSDeploy", "");
            this.tempDir_.delete();
            this.tempDir_.mkdir();
            this.model_.setGeneratedServiceSourceLocation(this.tempDir_.toURI().toURL().toString());
            this.model_.setGeneratedClientSourceLocation(this.tempDir_.toURI().toURL().toString());
        }
        catch (Exception e) {
            status = new SimpleStatus("", e.getMessage(), 4, (Throwable)e);
        }
        return status;
    }

    protected void cleanupModule() {
        if (!WSDeployer.isTraceEnabled()) {
            ArchiveUtil.delete((File)this.tempDir_);
        }
    }

    protected URL getRootURL() {
        String path = this.enterpriseArtifactEdit_.getComponent().getRootFolder().getWorkspaceRelativePath().toString();
        URI uri = URI.createPlatformResourceURI((String)path);
        URL url = null;
        try {
            url = new URL(uri.toString());
        }
        catch (Throwable exc) {
            exc.printStackTrace();
        }
        return url;
    }

    protected void compileCode() throws WebserviceXMLException {
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new MultiProjectCodeCompiler(), null);
        }
        catch (CoreException e) {
            throw new WebserviceXMLException(e.getMessage());
        }
    }

    protected void manageGeneratedFiles(boolean isClient) {
        block3: {
            TransientResourceContext resCtx = new TransientResourceContext();
            resCtx.setCheckoutFilesEnabled(true);
            resCtx.setCreateFoldersEnabled(true);
            resCtx.setOverwriteFilesEnabled(true);
            String tempDirAbsolutePath = this.tempDir_.getAbsolutePath();
            if (WSDeployer.isTraceEnabled()) {
                System.out.println("WASDeploymentModule staging area: " + tempDirAbsolutePath);
            }
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new TempFileProcessor(isClient), null);
            }
            catch (CoreException e) {
                if (!WSDeployer.isTraceEnabled()) break block3;
                System.err.println("CoreException: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected String getXMLFilePathFromVisitor(String filePath) {
        XMLResourceProxyVisitor visitor = new XMLResourceProxyVisitor(filePath);
        try {
            this.enterpriseArtifactEdit_.getProject().accept((IResourceProxyVisitor)visitor, 0);
            return visitor.getFilePath() == null ? filePath : visitor.getFilePath();
        }
        catch (CoreException coreException) {
            return filePath;
        }
    }

    private final class MultiProjectCodeCompiler
    implements IWorkspaceRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            ArrayList<IResource> filelist;
            IProject project;
            Hashtable<String, ArrayList<IResource>> resourceByProject = new Hashtable<String, ArrayList<IResource>>();
            ArrayList<String> orderedProjectList = new ArrayList<String>();
            Enumeration resourceKeys = WASDeploymentModule.this.resourceTable_.keys();
            while (resourceKeys.hasMoreElements()) {
                String filePath = (String)resourceKeys.nextElement();
                IResource resource = (IResource)WASDeploymentModule.this.resourceTable_.get(filePath);
                if (resource == null) continue;
                project = resource.getProject();
                String projectName = project.getName();
                filelist = (ArrayList<IResource>)resourceByProject.get(projectName);
                if (filelist == null) {
                    filelist = new ArrayList<IResource>();
                    resourceByProject.put(resource.getProject().getName(), filelist);
                }
                filelist.add(resource);
                if (orderedProjectList.contains(projectName)) continue;
                if (WASDeploymentModule.this.outputComponent_.getProject().getName().equals(projectName)) {
                    orderedProjectList.add(projectName);
                    continue;
                }
                orderedProjectList.add(0, projectName);
            }
            int orderIndex = 0;
            while (orderIndex < orderedProjectList.size()) {
                String projectName = (String)orderedProjectList.get(orderIndex);
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ArrayList<String> compilerArgs = new ArrayList<String>();
                filelist = (List)resourceByProject.get(projectName);
                long maxLocalTimeStamp = -1L;
                int i22 = 0;
                while (i22 < filelist.size()) {
                    IResource resource = (IResource)filelist.get(i22);
                    String filePath = resource.getRawLocation().toOSString();
                    long localTimeStamp = resource.getLocalTimeStamp();
                    if (localTimeStamp > maxLocalTimeStamp) {
                        maxLocalTimeStamp = localTimeStamp;
                    }
                    compilerArgs.add(filePath);
                    ++i22;
                }
                QualifiedName i22 = MAX_TRIGGER_TIMESTAMP;
                synchronized (i22) {
                    project.setSessionProperty(MAX_TRIGGER_TIMESTAMP, (Object)new Long(maxLocalTimeStamp));
                }
                int numberOfCompilerArgs = compilerArgs.size();
                if (numberOfCompilerArgs > 0) {
                    ClasspathResolver resolver = new ClasspathResolver("");
                    try {
                        resolver.setQuoteEntries(false);
                        compilerArgs.add(0, resolver.getClasspath(project));
                        compilerArgs.add(0, "-classpath");
                    }
                    catch (JavaModelException e) {
                        throw new CoreException(StatusUtils.errorStatus((Throwable)e));
                    }
                    try {
                        IPackageFragmentRoot defaultSrcContainer = J2EEProjectUtilities.getSourceContainers((IProject)project)[0];
                        IPath outputLocation = defaultSrcContainer.getRawClasspathEntry().getOutputLocation();
                        if (outputLocation == null) {
                            outputLocation = JavaCore.create((IProject)project).getOutputLocation();
                        }
                        IPath outputPath = Platform.getLocation().append(outputLocation);
                        compilerArgs.add(0, outputPath.toOSString());
                        compilerArgs.add(0, "-d");
                        BatchCompiler.compile((String[])compilerArgs.toArray(new String[compilerArgs.size()]), (PrintWriter)new PrintWriter(System.out), (PrintWriter)new PrintWriter(System.err), null);
                        try {
                            ResourcesPlugin.getWorkspace().getRoot().getFolder(outputLocation).refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    }
                    catch (JavaModelException e) {
                        throw new CoreException(StatusUtils.errorStatus((String)e.getMessage()));
                    }
                }
                ++orderIndex;
            }
        }
    }

    private final class TempFileProcessor
    implements IWorkspaceRunnable {
        private ResourceContext resCtx_;
        private boolean isClient_;
        private final int DOT_JAVA_EXTENSION_LENGTH = ".java".length();

        public TempFileProcessor(boolean isClient) {
            this.resCtx_ = new TransientResourceContext();
            this.resCtx_.setCheckoutFilesEnabled(true);
            this.resCtx_.setCreateFoldersEnabled(true);
            this.resCtx_.setOverwriteFilesEnabled(true);
            this.isClient_ = isClient;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            this.processGeneratedFiles(WASDeploymentModule.this.tempDir_, WASDeploymentModule.this.tempDir_.getAbsolutePath().length() + 1, new CRC32(), new byte[2048]);
        }

        private void processGeneratedFiles(File directory, int tempDirPrefixPos, CRC32 crc32, byte[] buffer) {
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.processGeneratedFiles(files[i], tempDirPrefixPos, crc32, buffer);
                } else {
                    IType type;
                    String filePath;
                    block23: {
                        filePath = files[i].getAbsolutePath();
                        if (WSDeployer.isTraceEnabled()) {
                            System.out.println("GENERATED file: " + filePath);
                        }
                        String generatedClassName = filePath.substring(tempDirPrefixPos, filePath.length() - this.DOT_JAVA_EXTENSION_LENGTH).replace(File.separatorChar, '.');
                        type = null;
                        try {
                            type = WASDeploymentModule.this.destinationJavaProject_.findType(generatedClassName);
                        }
                        catch (JavaModelException e) {
                            if (!WSDeployer.isTraceEnabled()) break block23;
                            System.err.println("JavaModelException: " + e.getMessage());
                            e.printStackTrace(System.err);
                        }
                    }
                    if (type != null) {
                        IResource sourceRes;
                        block24: {
                            sourceRes = null;
                            try {
                                ICompilationUnit cu = type.getCompilationUnit();
                                if (cu != null) {
                                    sourceRes = cu.getCorrespondingResource();
                                }
                            }
                            catch (JavaModelException e) {
                                if (!WSDeployer.isTraceEnabled()) break block24;
                                System.err.println("JavaModelException: " + e.getMessage());
                                e.printStackTrace(System.err);
                            }
                        }
                        if (sourceRes != null) {
                            if (J2EEPlugin.getDefault().getJ2EEPreferences().isIncrementalDeploymentEnabled()) {
                                long resourceSize;
                                IPath location = sourceRes.getLocation();
                                long l = resourceSize = location != null ? location.toFile().length() : 0L;
                                if (files[i].length() != resourceSize) {
                                    this.overwriteResource(files[i], sourceRes);
                                } else {
                                    long crcFile;
                                    long crcRes;
                                    block25: {
                                        IFile sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(sourceRes.getFullPath());
                                        crcRes = 0L;
                                        crcFile = 1L;
                                        try {
                                            InputStream is = sourceFile.getContents();
                                            crcRes = this.calculateCheckSum(buffer, is, crc32);
                                            is.close();
                                            FileInputStream fis = new FileInputStream(files[i]);
                                            crcFile = this.calculateCheckSum(buffer, fis, crc32);
                                            fis.close();
                                        }
                                        catch (CoreException e) {
                                            if (WSDeployer.isTraceEnabled()) {
                                                System.err.println("CoreException: " + e.getMessage());
                                                e.printStackTrace(System.err);
                                            }
                                        }
                                        catch (IOException e) {
                                            if (!WSDeployer.isTraceEnabled()) break block25;
                                            System.err.println("IOException: " + e.getMessage());
                                            e.printStackTrace(System.err);
                                        }
                                    }
                                    if (crcRes != crcFile) {
                                        if (WSDeployer.isTraceEnabled()) {
                                            System.out.println("WASDeploymentModule: " + sourceRes.getFullPath() + " replaced.");
                                        }
                                        this.overwriteResource(files[i], sourceRes);
                                    }
                                }
                            } else {
                                this.overwriteResource(files[i], sourceRes);
                            }
                        }
                    } else {
                        IContainer outputContainer = this.isClient_ ? WASDeploymentModule.this.defaultClientOutputContainer_ : WASDeploymentModule.this.defaultServiceOutputContainer_;
                        this.overwriteResource(files[i], (IResource)outputContainer.getFile((IPath)new Path(filePath.substring(tempDirPrefixPos, filePath.length()))));
                    }
                }
                ++i;
            }
        }

        private long calculateCheckSum(byte[] buffer, InputStream is, CRC32 crc32) {
            crc32.reset();
            int bytesRead = 0;
            try {
                while ((bytesRead = is.read(buffer)) != -1) {
                    crc32.update(buffer, 0, bytesRead);
                }
            }
            catch (Exception exception) {}
            return crc32.getValue();
        }

        private void overwriteResource(File tempFile, IResource destResource) {
            block4: {
                try {
                    boolean derived = destResource.exists() ? destResource.isDerived() : true;
                    FileInputStream fis = new FileInputStream(tempFile);
                    FileResourceUtils.createFile((ResourceContext)this.resCtx_, (IPath)destResource.getFullPath(), (InputStream)fis, (IProgressMonitor)new NullProgressMonitor(), (IStatusHandler)new NullStatusHandler());
                    fis.close();
                    IFile modifiedDestResource = ResourcesPlugin.getWorkspace().getRoot().getFile(destResource.getFullPath());
                    WASDeploymentModule.this.resourceTable_.put(modifiedDestResource.getRawLocation().toOSString(), modifiedDestResource);
                    if (WSDeployer.isTraceEnabled()) {
                        System.out.println("REFRESHED: " + modifiedDestResource.getFullPath());
                    }
                    if (derived) {
                        modifiedDestResource.setDerived(true);
                    }
                }
                catch (Exception e) {
                    if (!WSDeployer.isTraceEnabled()) break block4;
                    System.err.println("Exception: " + e.getMessage());
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private final class XMLResourceProxyVisitor
    implements IResourceProxyVisitor {
        private String filePath = null;
        private String fileName;

        public XMLResourceProxyVisitor(String resourceName) {
            int i;
            if (resourceName != null && (i = resourceName.lastIndexOf("/")) != -1 && resourceName.length() > i) {
                this.fileName = resourceName.substring(i + 1);
            }
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.getType() != 1) {
                return true;
            }
            String resourceName = proxy.getName();
            if (this.fileName != null && resourceName.equals(this.fileName)) {
                IResource resource = proxy.requestResource();
                URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString());
                this.filePath = uri.toString();
            }
            return true;
        }

        public String getFilePath() {
            return this.filePath;
        }
    }
}

