/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.deployer;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class PathUtil {
    public static String makeOSAbsolute(IProject project, IPath path) {
        File testAsFile = new File(path.toOSString());
        if (testAsFile.exists()) {
            return path.toOSString();
        }
        IResource target = PathUtil.getResource(project, path);
        if (target == null || !target.exists()) {
            return "";
        }
        IPath filesystemLocation = target.getLocation();
        if (filesystemLocation == null) {
            return path.toOSString();
        }
        return filesystemLocation.toOSString();
    }

    public static String getOSOutputDirectory(IProject project) {
        return PathUtil.getProjectOutputContainer(project).getLocation().toOSString();
    }

    public static IResource getResource(IProject project, IPath path) {
        if (path == null) {
            return null;
        }
        if (path.isAbsolute()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        }
        return project.findMember(path);
    }

    public static IContainer getProjectOutputContainer(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            IJavaProject jp = JavaCore.create((IProject)project);
            IResource jc = PathUtil.getResource(project, jp.getOutputLocation());
            if (jc == null || !jc.exists() || !(jc instanceof IContainer)) {
                return project;
            }
            return (IContainer)jc;
        }
        catch (JavaModelException javaModelException) {
            return project;
        }
    }

    public static String encloseInQuotes(String str) {
        if (!System.getProperty("os.name").startsWith("Windows") && !System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            return str;
        }
        int len = str.length();
        if (len > 0 && str.charAt(0) == '\"' && str.charAt(len - 1) == '\"') {
            return str;
        }
        StringBuffer buf = new StringBuffer(len + 2);
        buf.append('\"').append(str).append('\"');
        return buf.toString();
    }
}

