/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.deployer;

import com.ibm.ast.ws.deployer.WASDeploymentModuleWrapper;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;

public class DeploymentModuleWrapperRegistry {
    private static DeploymentModuleWrapperRegistry registry_ = null;
    private Hashtable wrapperEntriesByFacetVersion_ = new Hashtable();
    private Hashtable wrapperEntriesByRuntime_ = new Hashtable();

    private DeploymentModuleWrapperRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.ibm.ast.ws.rd.deploymentmodulewrapper");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                String wasFacetVersion = configElements[1].getAttribute("version");
                String runtimeTypeId = configElements[2].getAttribute("id");
                this.wrapperEntriesByFacetVersion_.put(wasFacetVersion, configElements);
                this.wrapperEntriesByRuntime_.put(runtimeTypeId, configElements);
                ++i;
            }
        }
    }

    private WASDeploymentModuleWrapper getWrapperById(Hashtable wrapperTable, String id) {
        if (id == null) {
            return null;
        }
        Object wrapperEntry = wrapperTable.get(id);
        WASDeploymentModuleWrapper wrapper = null;
        if (wrapperEntry instanceof IConfigurationElement[]) {
            IConfigurationElement[] configElements = (IConfigurationElement[])wrapperEntry;
            try {
                wrapper = (WASDeploymentModuleWrapper)configElements[0].createExecutableExtension("class");
                wrapperTable.put(id, wrapper);
            }
            catch (CoreException coreException) {}
        } else if (wrapperEntry instanceof WASDeploymentModuleWrapper) {
            wrapper = (WASDeploymentModuleWrapper)wrapperEntry;
        }
        return wrapper;
    }

    public WASDeploymentModuleWrapper getWrapper(String wasFacetVersionString, IRuntime runtime) {
        WASDeploymentModuleWrapper wrapper = this.getWrapperById(this.wrapperEntriesByFacetVersion_, wasFacetVersionString);
        String runtimeTypeId = runtime.getRuntimeType().getId();
        if (wrapper != null) {
            if (!(this.wrapperEntriesByRuntime_.get(runtimeTypeId) instanceof WASDeploymentModuleWrapper)) {
                this.wrapperEntriesByRuntime_.put(runtimeTypeId, wrapper);
            }
            return wrapper;
        }
        wrapper = this.getWrapperById(this.wrapperEntriesByRuntime_, runtimeTypeId);
        if (wrapper != null) {
            if (wasFacetVersionString != null && !(this.wrapperEntriesByFacetVersion_.get(wasFacetVersionString) instanceof WASDeploymentModuleWrapper)) {
                this.wrapperEntriesByFacetVersion_.put(wasFacetVersionString, wrapper);
            }
            return wrapper;
        }
        Hashtable<String, WASDeploymentModuleWrapper> newWrapperEntriesByRuntime = new Hashtable<String, WASDeploymentModuleWrapper>();
        for (Object wrapperEntry : this.wrapperEntriesByRuntime_.values()) {
            if (wrapperEntry instanceof WASDeploymentModuleWrapper) {
                wrapper = (WASDeploymentModuleWrapper)wrapperEntry;
                continue;
            }
            IConfigurationElement[] configElements = (IConfigurationElement[])wrapperEntry;
            try {
                wrapper = (WASDeploymentModuleWrapper)configElements[0].createExecutableExtension("class");
                newWrapperEntriesByRuntime.put(configElements[2].getAttribute("id"), wrapper);
                String wasFacetVersion = configElements[1].getAttribute("version");
                if (!(this.wrapperEntriesByFacetVersion_.get(wasFacetVersion) instanceof WASDeploymentModuleWrapper)) {
                    this.wrapperEntriesByFacetVersion_.put(wasFacetVersion, wrapper);
                }
                if (!wrapper.isRuntimeExtension(runtime)) continue;
                break;
            }
            catch (CoreException coreException) {}
        }
        for (String id : newWrapperEntriesByRuntime.keySet()) {
            this.wrapperEntriesByFacetVersion_.put(id, newWrapperEntriesByRuntime.get(id));
        }
        return wrapper;
    }

    public static DeploymentModuleWrapperRegistry getInstance() {
        if (registry_ == null) {
            registry_ = new DeploymentModuleWrapperRegistry();
        }
        return registry_;
    }
}

