/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.tokens;

import com.ibm.ast.ws.policyset.ui.callback.dialog.X509CallbackHandlerDialog;
import com.ibm.ast.ws.policyset.ui.common.KeyStore;
import com.ibm.ast.ws.policyset.ui.tokens.ProtectionToken;
import org.eclipse.swt.widgets.Shell;

public class X509ProtectionToken
extends ProtectionToken {
    public static final String GENERATOR_CALLBACK_HANDLER = "com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallbackHandler";
    public static final String CONSUMER_CALLBACK_HANDLER = "com.ibm.websphere.wssecurity.callbackhandler.X509ConsumeCallbackHandler";
    protected KeyStore keyStore;
    protected String certificatePathString;

    public String getCertificatePathString() {
        return this.certificatePathString;
    }

    public void setCertificatePathString(String certificatePathString) {
        this.certificatePathString = certificatePathString;
    }

    public X509ProtectionToken(String nameLocalPart, boolean tokenGenerator) {
        super(nameLocalPart);
        if (this.tokenName.equals("WssX509V3Token10") || this.tokenName.equals("WssX509V3Token11")) {
            this.localName = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
        } else if (this.tokenName.equals("WssX509Pkcs7Token10") || this.tokenName.equals("WssX509Pkcs7Token11")) {
            this.localName = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7";
        } else if (this.tokenName.equals("WssX509PkiPathV1Token10") || this.tokenName.equals("WssX509PkiPathV1Token11")) {
            this.localName = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
        } else if (this.tokenName.equals("WssX509V1Token11")) {
            this.localName = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509";
        } else {
            this.tokenName = null;
        }
        if (tokenGenerator) {
            this.callBackHandler = GENERATOR_CALLBACK_HANDLER;
            this.jaasLogin = "system.wss.generate.x509";
        } else {
            this.callBackHandler = CONSUMER_CALLBACK_HANDLER;
            this.jaasLogin = "system.wss.consume.x509";
        }
        this.jaasConfigs = new String[]{this.jaasLogin};
        this.callbackHandlers = new String[]{this.callBackHandler};
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public boolean isSymmetric() {
        return false;
    }

    public boolean isValid() {
        return this.keyStore == null || this.keyStore.isValid();
    }

    public String getDefaultEncryptionKeyInfoType() {
        return "KEYID";
    }

    public boolean getCallbackHandlerAdvancedDialog(Shell parent, String callbackHandler) {
        if (parent != null) {
            X509CallbackHandlerDialog dialog = new X509CallbackHandlerDialog(parent, callbackHandler);
            dialog.setKeyStoreData(this.keyStore);
            dialog.setCertificatePathString(this.certificatePathString);
            int result = dialog.open();
            if (result == 0) {
                this.keyStore = dialog.getKeyStoreData();
                this.certificatePathString = dialog.getCertificatePathString();
            }
        }
        return true;
    }
}

