/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.tokens;

import com.ibm.ast.ws.policyset.ui.callback.dialog.UsernameCallbackHandlerDialog;
import com.ibm.ast.ws.policyset.ui.common.PropertyList;
import com.ibm.ast.ws.policyset.ui.common.PropertyObject;
import com.ibm.ast.ws.policyset.ui.common.TimestampNonceComposite;
import com.ibm.ast.ws.policyset.ui.tokens.AuthenticationToken;
import org.eclipse.swt.widgets.Shell;

public class UserNameAuthenticationToken
extends AuthenticationToken {
    public static final String GUIPROMPT_CALLBACK = "com.ibm.websphere.wssecurity.callbackhandler.UNTGUIPromptCallbackHandler";

    public UserNameAuthenticationToken(String namelocalPart, boolean tokenGenerator) {
        super(namelocalPart);
        this.tokenURI = "";
        if (this.tokenName.equals("WssUsernameToken10")) {
            this.localName = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
        }
        if (this.tokenName.equals("WssUsernameToken11")) {
            this.localName = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.1#UsernameToken";
        }
        if (tokenGenerator) {
            this.jaasLogin = "system.wss.generate.unt";
            this.callBackHandler = "com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallbackHandler";
            this.callbackHandlers = new String[]{"com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallbackHandler", GUIPROMPT_CALLBACK};
        } else {
            this.jaasLogin = "system.wss.consume.unt";
            this.callBackHandler = "com.ibm.websphere.wssecurity.callbackhandler.UNTConsumeCallbackHandler";
        }
        this.jaasConfigs = new String[]{this.jaasLogin};
        this.properties = new PropertyList();
        this.properties.add(new PropertyObject(TimestampNonceComposite.GENERATOR_TIMESTAMP, true));
        this.properties.add(new PropertyObject(TimestampNonceComposite.GENERATOR_NONCE, true));
    }

    public boolean isValid() {
        if (GUIPROMPT_CALLBACK.equals(this.callBackHandler)) {
            return true;
        }
        return super.isValid();
    }

    public boolean getCallbackHandlerAdvancedDialog(Shell parent, String callback) {
        if (parent != null) {
            UsernameCallbackHandlerDialog dialog = new UsernameCallbackHandlerDialog(parent, callback);
            dialog.setBasicAuthentication(this.auth);
            dialog.setPropertiesList(this.properties);
            int result = dialog.open();
            if (result == 0) {
                this.auth = dialog.getBasicAuthentication();
                dialog.setPropertiesList(this.properties);
            }
        }
        return true;
    }
}

