/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.tokens;

import com.ibm.ast.ws.policyset.ui.callback.dialog.KerberosCallbackHandlerDialog;
import com.ibm.ast.ws.policyset.ui.common.PropertyList;
import com.ibm.ast.ws.policyset.ui.common.PropertyObject;
import com.ibm.ast.ws.policyset.ui.tokens.CustomeAuthenticationToken;
import org.eclipse.swt.widgets.Shell;

public class KerberosProtectionToken
extends CustomeAuthenticationToken {
    public static final String TARGET_SERVICE_HOST = "com.ibm.wsspi.wssecurity.krbtoken.targetServiceHost";
    public static final String TARGET_SERVICE_NAME = "com.ibm.wsspi.wssecurity.krbtoken.targetServiceName";
    public static final String CLIENT_REALM = "com.ibm.wsspi.wssecurity.krbtoken.clientRealm";
    public static final String TARGET_SERVICE_REALM = "com.ibm.wsspi.wssecurity.krbtoken.targetServiceRealm";
    protected boolean isGenerator;

    public KerberosProtectionToken(String localname, boolean isGenerator) {
        super("CustomToken");
        this.isGenerator = isGenerator;
        this.properties = new PropertyList();
        if (localname.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ") || localname.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ1510") || localname.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ4120") || localname.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ") || localname.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510") || localname.equals("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ4120")) {
            this.localName = localname;
            if (isGenerator) {
                this.jaasLogin = "system.wss.generate.KRB5BST";
                this.callBackHandler = "com.ibm.websphere.wssecurity.callbackhandler.KRBTokenGenerateCallbackHandler";
            } else {
                this.callBackHandler = "com.ibm.websphere.wssecurity.callbackhandler.KRBTokenConsumeCallbackHandler";
                this.jaasLogin = "system.wss.consume.KRB5BST";
            }
            this.callbackHandlers = new String[]{this.callBackHandler};
            this.jaasConfigs = new String[]{this.jaasLogin};
            this.properties = new PropertyList();
        } else {
            this.tokenName = null;
        }
    }

    public void addProperty(PropertyObject property) {
        this.properties.add(property);
    }

    public boolean isSymmetric() {
        return true;
    }

    public String getDefaultEncryptionKeyInfoType() {
        return "KEYID";
    }

    public boolean isValid() {
        return this.properties != null && this.properties.getProperties().size() > 0 && this.properties.getProperty(TARGET_SERVICE_HOST).getValue().length() != 0 && this.properties.getProperty(TARGET_SERVICE_NAME).getValue().length() != 0;
    }

    public boolean getCallbackHandlerAdvancedDialog(Shell parent, String callbackHandler) {
        if (!this.isGenerator) {
            return false;
        }
        if (parent != null) {
            KerberosCallbackHandlerDialog dialog = new KerberosCallbackHandlerDialog(parent);
            dialog.setProperties(this.properties);
            dialog.setBasicAuth(this.auth);
            int result = dialog.open();
            if (result == 0) {
                this.properties = dialog.getProperties();
                this.auth = dialog.getBasicAuth();
            }
        }
        return true;
    }
}

