/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.dialogs;

import com.ibm.ast.ws.policyset.ui.common.SSLSettingsObject;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SSLComposite
extends SimpleWidgetDataContributor {
    private String INFOPOP_SSL_SETTING_TEXT = "SSL0001";
    protected Text sslSettings;
    private String INFOPOP_SSL_PROP_TEXT = "SSL0002";
    protected Text propFile;
    private String INFOPOP_SSL_BROWSE_BUTTON = "SSL0003";
    protected Button browse;

    public IStatus getStatus() {
        if (this.sslSettings.getText().equals("")) {
            return StatusUtils.warningStatus((String)Activator.getMessage("ERROR_SSL_SETTINGS"));
        }
        if (this.propFile.getText().trim().equals("")) {
            return StatusUtils.warningStatus((String)Activator.getMessage("ERROR_SSL_PROP_FILE"));
        }
        return Status.OK_STATUS;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        final Composite theParent = parent;
        Composite sslComposite = Activator.getUiUtils().createComposite(parent, 3);
        this.sslSettings = Activator.getUiUtils().createText(sslComposite, Activator.getMessage("LABEL_SSL_SETTINGS"), Activator.getMessage("TOOLTIP_SSL_SETTING_TEXT"), this.INFOPOP_SSL_SETTING_TEXT, 2048);
        new Label(sslComposite, 0);
        this.propFile = Activator.getUiUtils().createText(sslComposite, Activator.getMessage("LABEL_SSL_PROP_FILE"), Activator.getMessage("TOOLTIP_SSL_PROP_TEXT"), this.INFOPOP_SSL_PROP_TEXT, 2048);
        this.browse = Activator.getUiUtils().createPushButton(sslComposite, Activator.getMessage("LABEL_BROWSE_BUTTON"), Activator.getMessage("TOOLTIP_SSL_BROWSE_BUTTON"), this.INFOPOP_SSL_BROWSE_BUTTON);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(theParent.getShell());
                fileDialog.setFilterExtensions(new String[]{"*.props", "*.*"});
                String property = fileDialog.open();
                if (property != null) {
                    SSLComposite.this.propFile.setText(property);
                }
            }
        });
        return this;
    }

    protected void setEnabled(boolean enabled) {
        this.sslSettings.setEnabled(enabled);
        this.propFile.setEnabled(enabled);
        this.browse.setEnabled(enabled);
    }

    public SSLSettingsObject getSslSetting() {
        return new SSLSettingsObject(this.sslSettings.getText().trim(), this.propFile.getText().trim());
    }

    public void setSslSetting(SSLSettingsObject sslSetting) {
        if (sslSetting != null) {
            this.sslSettings.setText(sslSetting.getSslSettings());
            this.propFile.setText(sslSetting.getPropertyFile());
        }
    }

    public void setStatusListener(Listener statusListener) {
        this.sslSettings.addListener(24, statusListener);
        this.propFile.addListener(24, statusListener);
    }
}

