/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.dialogs;

import com.ibm.ast.ws.policyset.ui.common.KeyStore;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.common.Timer;
import com.ibm.ast.ws.policyset.ui.dialogs.KeyStoreComposite;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class KeyStoreWithKeyComposite
extends KeyStoreComposite
implements Runnable {
    private String INFOPOP_CSWK_ALIAS_TEXT = "CSWK0001";
    protected Text keyAlias;
    private String INFOPOP_CSWK_PASSWORD_TEXT = "CSWK0002";
    protected Text keyPassword;
    protected Text keyName;
    protected boolean keyStoreLoadable = false;
    protected String foundKeyName = null;
    private Timer timer_ = null;
    protected Listener statusListener_;

    public void setStatusListener(Listener statusListener) {
        this.keyAlias.addListener(24, statusListener);
        if (this.keyPassword != null) {
            this.keyPassword.addListener(24, statusListener);
        }
        this.keyName.addListener(24, statusListener);
        super.setStatusListener(statusListener);
    }

    public KeyStoreWithKeyComposite(KeyStore keyStore) {
        super(keyStore);
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        super.addControls(parent, statusListener);
        this.keyStorePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyStoreWithKeyComposite.this.handleKeyStorePathModifyEvent();
            }
        });
        this.keyAlias = Activator.getUiUtils().createText(parent, Activator.getMessage("LABEL_KEY_ALIAS"), Activator.getMessage("TOOLTIP_CSWK_ALIAS_TEXT"), this.INFOPOP_CSWK_ALIAS_TEXT, 2048);
        this.keyAlias.setText(((KeyStoreWithKey)this.keyStore).getKeyAlias());
        if (((KeyStoreWithKey)this.keyStore).getKeyPassword() != null) {
            this.keyPassword = Activator.getUiUtils().createText(parent, Activator.getMessage("LABEL_KEY_PASS"), Activator.getMessage("TOOLTIP_CSWK_PASSWORD_TEXT"), this.INFOPOP_CSWK_PASSWORD_TEXT, this.style);
            this.keyPassword.setText(((KeyStoreWithKey)this.keyStore).getKeyPassword());
        }
        this.keyName = Activator.getUiUtils().createText(parent, Activator.getMessage("KEY_NAME_LABEL"), null, null, 2048);
        String name = ((KeyStoreWithKey)this.keyStore).getKeyName();
        if (name != null) {
            this.keyName.setText(name);
        } else {
            this.keyName.setEnabled(false);
        }
        return this;
    }

    protected void handleKeyStorePathModifyEvent() {
        if (this.keyStorePath.getText().indexOf(46) > 0) {
            this.timer_ = Timer.newInstance(this.timer_, Display.getCurrent(), this);
            this.timer_.startTimer();
            this.run();
        } else {
            this.statusListener_.handleEvent(null);
        }
    }

    public IStatus getStatus() {
        IStatus status = super.getStatus();
        if (status.getSeverity() != 0) {
            return status;
        }
        if (this.keyAlias.getText().trim().length() == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MSG_KEY_ALIAS_IS_EMPTY"));
        }
        if (this.keyPassword != null && this.keyPassword.getText().trim().length() == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MSG_KEYPASS_IS_EMPTY"));
        }
        if (this.keyName.getText().trim().length() == 0 || !this.keyName.isEnabled()) {
            if (!this.keyStoreLoadable) {
                this.keyName.setEnabled(true);
                return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_KEY_STORE_NOT_LOADABLE"));
            }
            if (this.foundKeyName != null) {
                return status;
            }
            try {
                java.security.KeyStore javaKey = java.security.KeyStore.getInstance(this.keyStoreType.getText());
                javaKey.load(new FileInputStream(this.keyStorePath.getText().trim()), this.keyStorePassword.getText().trim().toCharArray());
                X509Certificate javaX509 = (X509Certificate)javaKey.getCertificate(this.keyAlias.getText().trim());
                this.foundKeyName = javaX509.getSubjectDN().getName();
                if (this.foundKeyName == null) {
                    this.setKeyNameText("");
                    return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_KEY_NOT_FOUND"));
                }
                this.setKeyNameText(this.foundKeyName);
            }
            catch (KeyStoreException keyStoreException) {
                this.setKeyNameText("");
                return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_KEY_NOT_FOUND"));
            }
            catch (Exception exception) {
                this.setKeyNameText("");
                return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_KEY_NOT_FOUND"));
            }
        }
        return status;
    }

    public boolean canFinish() {
        return true;
    }

    protected void setKeyNameText(String text) {
        this.foundKeyName = text;
        this.keyName.setText(this.foundKeyName);
        this.foundKeyName = null;
    }

    public KeyStore getKeyStore() {
        KeyStoreWithKey keyStore = new KeyStoreWithKey(super.getKeyStore());
        keyStore.setKeyAlias(this.keyAlias.getText());
        if (this.keyPassword == null) {
            keyStore.setKeyPassword(null);
        } else {
            keyStore.setKeyPassword(this.keyPassword.getText());
        }
        if (this.keyName == null) {
            keyStore.setKeyName(null);
        } else {
            keyStore.setKeyName(this.keyName.getText());
        }
        return keyStore;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.keyAlias.setEnabled(enabled);
        if (this.keyPassword != null) {
            this.keyPassword.setEnabled(enabled);
        }
    }

    public void run() {
        File file = new File(this.keyStorePath.getText().trim());
        this.keyStoreLoadable = file.exists();
        this.keyName.setEnabled(!this.keyStoreLoadable);
        this.statusListener_.handleEvent(null);
    }
}

