/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.dialogs;

import com.ibm.ast.ws.policyset.ui.common.KeyStore;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class KeyStoreComposite
extends SimpleWidgetDataContributor {
    private String INFOPOP_KSC_KEYSTORE_PASSWORD_TEXT = "KSC0001";
    protected Text keyStorePassword;
    private String INFOPOP_KSC_KEYSTORE_PATH_TEXT = "KSC0002";
    protected Text keyStorePath;
    private String INFOPOP_KSC_KEYSTORE_TYPE_COMBO = "KSC0003";
    protected Combo keyStoreType;
    private String INFOPOP_KSC_KEYSTORE_BROWSE_BUTTON = "KSC0004";
    protected Button browseKeyStorePath;
    protected int style;
    private String INFOPOP_WSS_KSS_DIALOG = "KSC0005";
    protected KeyStore keyStore;

    public KeyStoreComposite(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public IStatus getStatus() {
        if (this.keyStorePath.getText().equals("")) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MSG_KEY_STORE_PATH_IS_EMPTY"));
        }
        if (this.keyStorePassword.getText().trim().equals("")) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MSG_KEY_STOREPASS_IS_EMPTY"));
        }
        if (this.keyStoreType.getText().trim().equals("")) {
            return StatusUtils.errorStatus((String)Activator.getMessage("ERROR_MSG_KEY_STORE_TYPE_IS_EMPTY"));
        }
        return Status.OK_STATUS;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        final Composite theParent = parent;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ast.ws.policyset.ui." + this.INFOPOP_WSS_KSS_DIALOG);
        parent.setLayoutData((Object)new GridData(768));
        this.style = WSUIPlugin.getInstance().getWASSecurityContext().isStarPassword() ? 0x400800 : 2048;
        Label pathText = new Label(parent, 8);
        pathText.setText(Activator.getMessage("LABEL_KEYSTORE_PATH"));
        Composite pathComposite = Activator.getUiUtils().createComposite(parent, 2, 0, 0);
        this.keyStorePath = new Text(pathComposite, 2048);
        this.keyStorePath.setLayoutData((Object)new GridData(768));
        this.keyStorePath.setToolTipText(Activator.getMessage("TOOLTIP_KSC_KEYSTORE_PATH_TEXT"));
        this.browseKeyStorePath = Activator.getUiUtils().createPushButton(pathComposite, Activator.getMessage("LABEL_BROWSE_BUTTON"), Activator.getMessage("TOOLTIP_KSC_KEYSTORE_BROWSE_BUTTON"), this.INFOPOP_KSC_KEYSTORE_BROWSE_BUTTON);
        this.browseKeyStorePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(theParent.getShell());
                fileDialog.setFilterExtensions(KeyStore.getKeyStoreExtensions());
                fileDialog.setFilterNames(KeyStore.getKeyStoreExtensionNames());
                String keyStorePathText = fileDialog.open();
                if (keyStorePathText != null) {
                    KeyStoreComposite.this.keyStorePath.setText(keyStorePathText);
                }
            }
        });
        this.keyStorePassword = Activator.getUiUtils().createText(parent, Activator.getMessage("LABEL_KEYSTORE_PASS"), Activator.getMessage("TOOLTIP_KSC_KEYSTORE_PASSWORD_TEXT"), this.INFOPOP_KSC_KEYSTORE_PASSWORD_TEXT, this.style);
        this.keyStoreType = Activator.getUiUtils().createCombo(parent, Activator.getMessage("LABEL_KEYSTORE_TYPE"), Activator.getMessage("TOOLTIP_KSC_KEYSTORE_TYPE_COMBO"), this.INFOPOP_KSC_KEYSTORE_TYPE_COMBO, 2056);
        this.keyStoreType.setItems(KeyStore.getKeyStoreTypes());
        if (this.keyStore != null) {
            this.keyStorePassword.setText(this.keyStore.getPassword());
            this.keyStorePath.setText(this.keyStore.getPath());
            this.keyStoreType.setText(this.keyStore.getType());
        }
        return this;
    }

    public void setStatusListener(Listener statusListener) {
        this.keyStorePassword.addListener(24, statusListener);
        this.keyStorePath.addListener(24, statusListener);
        this.keyStoreType.addListener(24, statusListener);
    }

    public KeyStore getKeyStore() {
        KeyStore keyStore = new KeyStore(this.keyStorePassword.getText(), this.keyStorePath.getText(), this.keyStoreType.getText());
        return keyStore;
    }

    public void setEnabled(boolean enabled) {
        this.keyStorePassword.setEnabled(enabled);
        this.keyStorePath.setEnabled(enabled);
        this.keyStoreType.setEnabled(enabled);
        this.browseKeyStorePath.setEnabled(enabled);
    }
}

