/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.dialogs;

import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.policyset.ui.dialogs.UserNamePasswordComposite;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import com.ibm.ast.ws.policyset.ui.tokens.AuthenticationToken;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class AuthenticationTokenComposite
extends SimpleWidgetDataContributor {
    protected Listener statusListener_;
    protected Text tokenType;
    protected Combo jaasConfig;
    private String INFOPOP_AUTH_COMP_COMBO_CALLBACK = "AUTH0002";
    protected Combo callBack;
    protected UserNamePasswordComposite auth;
    protected AuthenticationToken token;
    protected Button timestamp;
    protected Button nonce;

    public IStatus getStatus() {
        return this.auth.getStatus();
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.statusListener_ = statusListener;
        Composite tokenComposite = Activator.getUiUtils().createComposite(parent, 2);
        this.tokenType = Activator.getUiUtils().createText(tokenComposite, Activator.getMessage("LABEL_TOKEN_TYPE"), Activator.getMessage("TOOLTIP_AUTH_COMP_TEXT_TOKENTYPE"), null, 2056);
        this.callBack = Activator.getUiUtils().createCombo(tokenComposite, Activator.getMessage("LABEL_CALLBACK_HANDLER"), Activator.getMessage("TOOLTIP_AUTH_COMP_COMBO_CALLBACK"), this.INFOPOP_AUTH_COMP_COMBO_CALLBACK, 2048);
        this.callBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthenticationTokenComposite.this.auth.setEnabled(!AuthenticationTokenComposite.this.callBack.getText().equals("com.ibm.websphere.wssecurity.callbackhandler.UNTGUIPromptCallbackHandler"));
                AuthenticationTokenComposite.this.statusListener_.handleEvent(null);
            }
        });
        this.jaasConfig = Activator.getUiUtils().createCombo(tokenComposite, Activator.getMessage("LABEL_JAAS_LOGIN"), null, null, 2048);
        this.auth = new UserNamePasswordComposite();
        this.auth.addControls(tokenComposite, this.statusListener_);
        new Label(parent, 256);
        this.timestamp = Activator.getUiUtils().createCheckbox(parent, Activator.getMessage("GENERATOR_TIMESTAMP"), null, null);
        this.nonce = Activator.getUiUtils().createCheckbox(parent, Activator.getMessage("GENERATOR_NONCE"), null, null);
        return this;
    }

    public AuthenticationToken getToken() {
        BasicAuthentication authentication = this.auth.getBasicAuthentication();
        authentication.getGeneratorTimestamp().setValue(this.timestamp.getSelection());
        authentication.getGeneratorNonce().setValue(this.nonce.getSelection());
        this.token.setBasicAuth(authentication);
        this.token.setCallBackHandler(this.callBack.getText());
        this.token.setJAASConfig(this.jaasConfig.getText());
        return this.token;
    }

    public void setToken(AuthenticationToken token) {
        this.token = token;
        if (token == null) {
            return;
        }
        this.tokenType.setText(token.getTokenName());
        this.jaasConfig.setItems(token.getJAASConfigs());
        if (this.jaasConfig.indexOf(token.getJAASConfig()) == -1) {
            this.jaasConfig.add(token.getJAASConfig());
        }
        this.jaasConfig.setText(token.getJAASConfig());
        this.callBack.setItems(token.getCallBackHandlers());
        if (this.callBack.indexOf(token.getCallBackHandler()) == -1) {
            this.callBack.add(token.getCallBackHandler());
        }
        this.callBack.setText(token.getCallBackHandler());
        this.auth.setBasicAuthentication(token.getBasicAuth());
        this.auth.setEnabled(!this.callBack.getText().equals("com.ibm.websphere.wssecurity.callbackhandler.UNTGUIPromptCallbackHandler"));
        this.timestamp.setSelection(token.getBasicAuth().getGeneratorTimestamp().getBooleanValue());
        this.nonce.setSelection(token.getBasicAuth().getGeneratorNonce().getBooleanValue());
    }

    public void setStatusListener(Listener statusListener) {
        this.statusListener_ = statusListener;
        this.auth.setStatusListener(statusListener);
    }
}

