/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.common;

import java.util.Calendar;
import org.eclipse.swt.widgets.Display;

public class Timer
extends Thread {
    private final long ONE_SECOND = 1000L;
    private long refreshTime;
    private boolean isRunning = true;
    private Display display;
    private Runnable runnable;

    private Timer(Display display, Runnable runnable) {
        this.display = display;
        this.runnable = runnable;
    }

    public static synchronized Timer newInstance(Timer timer, Display display, Runnable runnable) {
        if (!Timer.isRunning(timer)) {
            return new Timer(display, runnable);
        }
        return timer;
    }

    public static synchronized boolean isRunning(Timer timer) {
        return timer != null && timer.isRunning;
    }

    public synchronized void startTimer() {
        this.refreshTime = this.getCurrentTime() + 1000L;
        if (!this.isAlive()) {
            this.start();
        }
    }

    private long getCurrentTime() {
        return Calendar.getInstance().getTime().getTime();
    }

    public void run() {
        long currTime = this.getCurrentTime();
        while (currTime < this.refreshTime) {
            try {
                Timer.sleep(this.refreshTime - currTime);
            }
            catch (InterruptedException interruptedException) {}
            currTime = this.getCurrentTime();
        }
        this.isRunning = false;
        this.display.syncExec(this.runnable);
    }
}

