/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.common;

import com.ibm.ast.ws.policyset.ui.plugin.Activator;

public class KeyStore {
    protected String type;
    protected String path;
    protected String password;

    public KeyStore() {
        this.type = "";
        this.path = "";
        this.password = "";
    }

    public KeyStore(KeyStore store) {
        if (store == null) {
            return;
        }
        this.type = store.getType();
        this.path = store.getPath();
        this.password = store.getPassword();
    }

    public KeyStore(String password, String path, String type) {
        this.type = type;
        this.path = path;
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path.trim();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static String[] getKeyStoreTypes() {
        return new String[]{"JKS", "JCEKS", "PKCS11", "PKCS12"};
    }

    public static String[] getKeyStoreExtensions() {
        return new String[]{"*.ks;*.jks;*.jceks;*.p11;*.p12", "*.ks", "*.jks", "*.jceks", "*.p11", "*.p12", "*.*"};
    }

    public static String[] getKeyStoreExtensionNames() {
        return new String[]{String.valueOf(Activator.getMessage("ALL_KEYSTORE_EXTENSIONS")) + " (*.ks;*.jks;*.jceks;*.p11;*.p12)", "JKS (*.ks;*.jks)", "JCEKS (*.jceks)", "PKCS11 (*.p11)", "PKCS12 (*.p12)", String.valueOf(Activator.getMessage("ALL_FILE")) + " (*.*)"};
    }

    public boolean isValid() {
        return this.type.length() > 0 && this.password.length() > 0 && this.path.length() > 0;
    }
}

