/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.common;

import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import com.ibm.ws.ast.st.core.internal.util.J2EEUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class CommonPolicyUtils {
    public static final String CLIENT_POLICYATTACHMENT_FILE_NAME = "clientPolicyAttachments.xml";
    public static final String POLICYATTACHMENT_FILE_NAME = "policyAttachments.xml";
    public static final String POLICYSET_FILE_NAME = "policySet.xml";
    public static final String POLICY_FILE_NAME = "policy.xml";
    public static final String BINDING_FILE_NAME = "bindings.xml";
    public static List<String> bindingFolders;
    public static final String POLICYSETS_FOLDER = "PolicySets";
    public static final String POLICYTYPES_FOLDER = "PolicyTypes";

    public static File createTempDir() {
        String pluginTempDir = Activator.getDefault().getStateLocation().toString();
        File tempDir = new File(pluginTempDir);
        File newTempDir = null;
        try {
            newTempDir = File.createTempFile("TEMP", "", tempDir);
            if (newTempDir.delete() && newTempDir.mkdir()) {
                tempDir = newTempDir;
            }
            return tempDir;
        }
        catch (Exception exception) {
            return tempDir;
        }
    }

    public static String[] getTransformAlgorithms() {
        return new String[]{"http://www.w3.org/2001/10/xml-exc-c14n#", "http://www.w3.org/TR/1999/REC-xpath-19991116", "http://www.w3.org/2002/06/xmldsig-filter2", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "http://www.w3.org/2002/07/decrypt#XML", "http://www.w3.org/2000/09/xmldsig#enveloped-signature"};
    }

    public static IFolder getOutputFolder(IProject application, boolean forceCreation) {
        block9: {
            try {
                IFolder folder;
                IModule module;
                IModule[] ears;
                if ((J2EEUtils.isWebComponent((IProject)application) || J2EEUtils.isEJBComponent((IProject)application)) && (ears = J2EEUtil.getEnterpriseApplications((IModule)(module = ServerUtil.getModule((IProject)application)), null)) != null && ears.length > 0) {
                    application = ears[0].getProject();
                }
                if (J2EEUtils.isEARComponent((IProject)application) && (folder = application.getFolder("META-INF")).exists()) {
                    return folder;
                }
                if (JavaUtil.isUnmanagedProject((IProject)application) || J2EEUtils.isAppClientComponent((IProject)application)) {
                    IFolder legacyMetaInfFolder = application.getFolder("META-INF");
                    if (legacyMetaInfFolder.exists()) {
                        return legacyMetaInfFolder;
                    }
                    final IFolder[] metaInfFolderHolder = new IFolder[1];
                    IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            IFolder metaInfFolder;
                            if (proxy.getName().equals("META-INF") && (metaInfFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(proxy.requestFullPath())).exists()) {
                                metaInfFolderHolder[0] = metaInfFolder;
                                return false;
                            }
                            return true;
                        }
                    };
                    List srcContainers = JemProjectUtilities.getSourceContainers((IProject)application);
                    for (IContainer srcContainer : srcContainers) {
                        srcContainer.accept(visitor, 0);
                        if (metaInfFolderHolder[0] == null) continue;
                        return metaInfFolderHolder[0];
                    }
                }
                if (forceCreation) break block9;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (JavaEEProjectUtilities.isEARProject((IProject)application)) {
            return CommonPolicyUtils.createIFolder((IContainer)application, "META-INF");
        }
        IContainer srcContainer = JemProjectUtilities.getSourceFolderOrFirst((IProject)application, (String)"src");
        return CommonPolicyUtils.createIFolder(srcContainer, "META-INF");
    }

    public static IProject getContaingEarProject(IProject application) {
        IModule module;
        IModule[] ears;
        if ((J2EEUtils.isWebComponent((IProject)application) || J2EEUtils.isEJBComponent((IProject)application)) && (ears = J2EEUtil.getEnterpriseApplications((IModule)(module = ServerUtil.getModule((IProject)application)), null)) != null && ears.length > 0) {
            return ears[0].getProject();
        }
        return application;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkJavaProjectTargetRuntime(IProject project, String variable) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
            Path desiredPath = new Path(variable);
            int i = 0;
            while (true) {
                IPath path;
                if (i >= classPathEntries.length) {
                    return false;
                }
                IClasspathEntry classpathEntry = classPathEntries[i];
                if (classpathEntry.getEntryKind() == 4 && (path = classpathEntry.getPath()) != null && path.equals((Object)desiredPath)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String[] getApplicationBindings(IProject clientProject) {
        try {
            bindingFolders = new Vector<String>();
            class ApplicationBindingsResourceVisitor
            implements IResourceVisitor {
                ApplicationBindingsResourceVisitor() {
                }

                public boolean visit(IResource res) {
                    IPath tempPath;
                    if (res.getType() == 2 && (tempPath = res.getFullPath()) != null && tempPath.segmentCount() > 2 && tempPath.segment(tempPath.segmentCount() - 2).equalsIgnoreCase("META-INF")) {
                        boolean found = false;
                        int j = 0;
                        while (j < bindingFolders.size()) {
                            if (bindingFolders.get(j).equalsIgnoreCase(res.getFullPath().lastSegment())) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found && !res.getFullPath().lastSegment().equalsIgnoreCase(CommonPolicyUtils.POLICYSETS_FOLDER) && CommonPolicyUtils.isAppBindingFolder(res)) {
                            bindingFolders.add(res.getFullPath().lastSegment());
                        }
                    }
                    return true;
                }
            }
            ApplicationBindingsResourceVisitor visitor = new ApplicationBindingsResourceVisitor();
            clientProject.accept((IResourceVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] bindings = new String[bindingFolders.size()];
        int i = 0;
        while (i < bindingFolders.size()) {
            bindings[i] = bindingFolders.get(i);
            ++i;
        }
        return bindings;
    }

    private static boolean isAppBindingFolder(IResource resource) {
        IContainer container = resource.getParent();
        IFolder bindingFolder = container.getFolder((IPath)new Path(resource.getName()));
        IFolder types = bindingFolder.getFolder(POLICYTYPES_FOLDER);
        return types != null && types.exists();
    }

    public static IFolder createIFolder(IContainer parent, String newFolderName) throws CoreException {
        IFolder newFolder = parent.getFolder((IPath)new Path(newFolderName));
        if (!newFolder.exists()) {
            try {
                newFolder.create(true, true, null);
                newFolder.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return newFolder;
    }

    public static File createIFolder(File parent, String newFolderName) throws CoreException {
        File newFolder = new Path(parent.getAbsolutePath()).append(newFolderName).toFile();
        if (!newFolder.exists()) {
            try {
                newFolder.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newFolder;
    }

    public static void createJavaFolder(String folderName) {
        File parent;
        if (folderName != null && (parent = new File(folderName)) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        if (!src.exists()) {
            return;
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

