/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.command;

import com.ibm.ast.ws.jaxws.emitter.command.ValidateEditCommand;
import com.ibm.ast.ws.policyset.ui.common.CommonPolicyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CopyGeneratedFilesCommand
extends AbstractDataModelOperation {
    protected ResourceContext resCtx_;
    protected File sourceFile;
    protected IPath targetPath;
    protected HashMap<IPath, File> targetPathToFileMap;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus envStatus = Status.OK_STATUS;
        this.resCtx_ = ((BaseEclipseEnvironment)this.getEnvironment()).getResourceContext();
        this.targetPathToFileMap = new HashMap();
        envStatus = this.processGeneratedFiles(this.sourceFile, this.targetPath, monitor, this.getEnvironment().getStatusHandler());
        if (envStatus.isOK()) {
            Vector<IPath> pathVector = new Vector<IPath>();
            for (IPath targetFilePath : this.targetPathToFileMap.keySet()) {
                pathVector.add(targetFilePath);
            }
            ValidateEditCommand validateEditCmd = new ValidateEditCommand();
            validateEditCmd.setEnvironment(super.getEnvironment());
            validateEditCmd.setFileList(ValidateEditCommand.convertIPathToIFileArray(pathVector));
            envStatus = validateEditCmd.execute(monitor, adaptable);
        }
        return envStatus;
    }

    protected IStatus overwriteResource(File tempFile, IPath tmpPath, IProgressMonitor monitor, IStatusHandler handler) {
        try {
            FileInputStream fis = new FileInputStream(tempFile);
            IFile createdFile = FileResourceUtils.createFile((ResourceContext)this.resCtx_, (IPath)tmpPath, (InputStream)fis, (IProgressMonitor)monitor, (IStatusHandler)handler);
            fis.close();
            if (createdFile == null) {
                return StatusUtils.errorStatus((String)"");
            }
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            return errStatus;
        }
        return Status.OK_STATUS;
    }

    protected IStatus processGeneratedFiles(File source, IPath targetPath, IProgressMonitor monitor, IStatusHandler handler) {
        IStatus retStatus = Status.OK_STATUS;
        try {
            File[] files = source.listFiles();
            if (files == null) {
                return retStatus;
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    File newFolder = CommonPolicyUtils.createIFolder(targetPath.toFile(), files[i].getName());
                    retStatus = this.processGeneratedFiles(files[i], (IPath)new Path(newFolder.getAbsolutePath()), monitor, handler);
                    if (retStatus.getSeverity() != 0) {
                        return retStatus;
                    }
                } else {
                    IPath targetFilePath = targetPath.append(files[i].getName());
                    retStatus = this.overwriteResource(files[i], targetFilePath, monitor, handler);
                    if (retStatus.getSeverity() != 0) {
                        return retStatus;
                    }
                    this.targetPathToFileMap.put(targetFilePath, files[i]);
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((Throwable)e);
        }
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setTargetPath(IPath targetFile) {
        this.targetPath = targetFile;
    }
}

