/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.callback.dialog;

import com.ibm.ast.ws.policyset.ui.callback.dialog.AbstractCallbackHandlerDialog;
import com.ibm.ast.ws.policyset.ui.common.KeyStore;
import com.ibm.ast.ws.policyset.ui.common.KeyStoreWithKey;
import com.ibm.ast.ws.policyset.ui.dialogs.KeyStoreComposite;
import com.ibm.ast.ws.policyset.ui.dialogs.KeyStoreWithKeyComposite;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class X509CallbackHandlerDialog
extends AbstractCallbackHandlerDialog {
    private String INFOPOP_X509_CALBACK_HANDLER_PROERTIES = "X50901";
    private KeyStoreComposite keystoreComp;
    private KeyStore keyStoreData;
    private String certificatePathString;
    private String INFOPOP_WSS_TRUST_ANY_CHECK = "WSS0012";
    private Button trustAnyCertificate;
    private String INFOPOP_WSS_SIGNCER_TEXT = "WSS0003";
    private Text certificatePath;
    private String INFOPOP_WSS_SIGNCER_BUTTON = "WSS0004";
    private Button browseCert;

    public X509CallbackHandlerDialog(Shell parent, String callback) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent_ = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent_, "com.ibm.ast.ws.policyset.ui." + this.INFOPOP_X509_CALBACK_HANDLER_PROERTIES);
        this.setTitle(Activator.getMessage("X509_CALLBACK_HANDLER_TITLE"));
        this.createX509Page(this.parent_);
        return parent;
    }

    private void createX509Page(Composite parent) {
        new Label(parent, 0);
        if (this.keyStoreData != null && this.keyStoreData instanceof KeyStoreWithKey) {
            Composite keystoreGroup = this.uiUtils.createComposite(parent, 2);
            this.keystoreComp = new KeyStoreWithKeyComposite(this.keyStoreData);
            this.keystoreComp.addControls(keystoreGroup, this.getStatusListener());
        } else {
            Composite mainGroup = this.uiUtils.createComposite(parent, 1);
            this.trustAnyCertificate = this.uiUtils.createCheckbox(mainGroup, Activator.getMessage("CHECKBOX_TRUST_ANY_CERT"), Activator.getMessage("TOOLTIP_CHECKBOX_TRUST_ANY_CERT"), this.INFOPOP_WSS_TRUST_ANY_CHECK);
            Composite composite = this.uiUtils.createComposite(mainGroup, 2);
            this.keystoreComp = new KeyStoreComposite(this.keyStoreData);
            this.keystoreComp.addControls(composite, this.getStatusListener());
            Label certPathLabel = new Label(composite, 8);
            certPathLabel.setText(Activator.getMessage("CERTIFICATE_PATH_LABEL"));
            Composite compositeInner = this.uiUtils.createComposite(composite, 2, 0, 0);
            this.certificatePath = new Text(compositeInner, 2048);
            this.certificatePath.setToolTipText(Activator.getMessage("TOOLTIP_WSS_SIGNCER_TEXT"));
            this.certificatePath.setToolTipText(this.INFOPOP_WSS_SIGNCER_TEXT);
            this.certificatePath.setLayoutData((Object)new GridData(768));
            this.browseCert = this.uiUtils.createPushButton(compositeInner, Activator.getMessage("LABEL_BROWSE_BUTTON"), Activator.getMessage("TOOLTIP_WSS_SIGNCER_BUTTON"), this.INFOPOP_WSS_SIGNCER_BUTTON);
            if (this.certificatePathString != null) {
                this.certificatePath.setText(this.certificatePathString);
            }
            this.trustAnyCertificate.setSelection(this.keyStoreData == null);
            this.checkFieldsEnablement();
            this.trustAnyCertificate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    X509CallbackHandlerDialog.this.checkFieldsEnablement();
                    X509CallbackHandlerDialog.this.getStatusListener().handleEvent(null);
                }
            });
            this.browseCert.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(X509CallbackHandlerDialog.this.parent_.getShell());
                    fileDialog.setFilterExtensions(new String[]{"*.cer", "*.*"});
                    fileDialog.setFilterNames(new String[]{String.valueOf(Activator.getMessage("CERTIFICATE_FILES")) + " (*.cer)", String.valueOf(Activator.getMessage("ALL_FILE")) + " (*.*)"});
                    String certificatePathText = fileDialog.open();
                    if (certificatePathText != null) {
                        X509CallbackHandlerDialog.this.certificatePath.setText(certificatePathText);
                    }
                }
            });
        }
        this.keystoreComp.setStatusListener(this.statusListener);
    }

    private void checkFieldsEnablement() {
        boolean trustAny = this.trustAnyCertificate.getSelection();
        this.keystoreComp.setEnabled(!trustAny);
        this.certificatePath.setEnabled(!trustAny);
        if (!trustAny && this.keyStoreData == null) {
            this.keyStoreData = new KeyStore("", "", "");
        }
        this.browseCert.setEnabled(!trustAny);
    }

    public IStatus getStatus() {
        if (this.trustAnyCertificate != null && this.trustAnyCertificate.getSelection()) {
            return Status.OK_STATUS;
        }
        if (this.keyStoreData == null || !this.keyStoreData.isValid()) {
            return this.keystoreComp.getStatus();
        }
        return Status.OK_STATUS;
    }

    public KeyStore getKeyStoreData() {
        return this.keyStoreData;
    }

    public void setKeyStoreData(KeyStore keyStoreData) {
        this.keyStoreData = keyStoreData;
    }

    public String getCertificatePathString() {
        return this.certificatePathString;
    }

    public void setCertificatePathString(String certificatePathString) {
        this.certificatePathString = certificatePathString;
    }

    protected void okPressed() {
        if (this.trustAnyCertificate == null) {
            this.keyStoreData = this.keystoreComp.getKeyStore();
        } else if (this.trustAnyCertificate.getSelection()) {
            this.keyStoreData = null;
            this.certificatePathString = null;
        } else {
            this.keyStoreData = this.keystoreComp.getKeyStore();
            this.certificatePathString = this.certificatePath.getText();
        }
        super.okPressed();
    }

    protected String getDialogDescription() {
        return Activator.getMessage("X509_CALLBACK_HANDLER_DESC");
    }
}

