/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.callback.dialog;

import com.ibm.ast.ws.policyset.ui.callback.dialog.AbstractCallbackHandlerDialog;
import com.ibm.ast.ws.policyset.ui.common.BasicAuthentication;
import com.ibm.ast.ws.policyset.ui.dialogs.UserNamePasswordComposite;
import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;

public class KerberosCallbackHandlerDialog
extends AbstractCallbackHandlerDialog {
    private String INFOPOP_KRB_CALBACK_HANDLER_PROERTIES = "KRB0001";
    protected UserNamePasswordComposite auth;
    protected Text targetServiceHost;
    protected Text targetServiceName;
    protected Text clientRealm;
    protected Text targetServiceRealm;
    protected Button useBasicAuth;
    protected BasicAuthentication basicAuth;

    public KerberosCallbackHandlerDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.parent_ = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent_, "com.ibm.ast.ws.policyset.ui." + this.INFOPOP_KRB_CALBACK_HANDLER_PROERTIES);
        this.setTitle(Activator.getMessage("KERBEROS_CALLBACK_HANDLER_TITLE"));
        this.createKerberosPage(this.parent_);
        return parent;
    }

    private void createKerberosPage(Composite parent) {
        new Label(parent, 0);
        Composite parent1 = this.uiUtils.createComposite(parent, 1);
        this.useBasicAuth = this.uiUtils.createCheckbox(parent1, Activator.getMessage("KERBEROS_USE_BASIC_AUTH"), null, null);
        Composite authComp = this.uiUtils.createComposite(parent1, 2);
        this.auth = new UserNamePasswordComposite();
        this.auth.addControls(authComp, this.statusListener);
        new Label(parent1, 256);
        Composite krb = this.uiUtils.createComposite(parent, 2);
        this.targetServiceHost = this.uiUtils.createText(krb, Activator.getMessage("KERBEROS_TARGET_SERVICE_HOST"), null, null, 2048);
        this.targetServiceName = this.uiUtils.createText(krb, Activator.getMessage("KERBEROS_TARGET_SERVICE_NAME"), null, null, 2048);
        new Label(krb, 256);
        new Label(krb, 256);
        this.clientRealm = this.uiUtils.createText(krb, Activator.getMessage("KERBEROS_CLIENT_REALM"), null, null, 2048);
        this.targetServiceRealm = this.uiUtils.createText(krb, Activator.getMessage("KERBEROS_TARGET_SERVICE_REALM"), null, null, 2048);
        this.targetServiceHost.setText(this.getProperty("com.ibm.wsspi.wssecurity.krbtoken.targetServiceHost"));
        this.targetServiceName.setText(this.getProperty("com.ibm.wsspi.wssecurity.krbtoken.targetServiceName"));
        this.clientRealm.setText(this.getProperty("com.ibm.wsspi.wssecurity.krbtoken.clientRealm"));
        this.targetServiceRealm.setText(this.getProperty("com.ibm.wsspi.wssecurity.krbtoken.targetServiceRealm"));
        this.auth.setBasicAuthentication(this.basicAuth);
        this.targetServiceHost.addListener(24, this.getStatusListener());
        this.targetServiceName.addListener(24, this.getStatusListener());
        this.useBasicAuth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                KerberosCallbackHandlerDialog.this.auth.setEnabled(KerberosCallbackHandlerDialog.this.useBasicAuth.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                KerberosCallbackHandlerDialog.this.auth.setEnabled(KerberosCallbackHandlerDialog.this.useBasicAuth.getSelection());
            }
        });
        this.useBasicAuth.setSelection(this.basicAuth != null);
        this.auth.setEnabled(this.useBasicAuth.getSelection());
    }

    public IStatus getStatus() {
        if (this.targetServiceHost.getText().trim().length() == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("KERBEROS_TARGET_SERVICE_HOST_MISSING"));
        }
        if (this.targetServiceName.getText().trim().length() == 0) {
            return StatusUtils.errorStatus((String)Activator.getMessage("KERBEROS_TARGET_SERVICE_NAME_MISSING"));
        }
        return Status.OK_STATUS;
    }

    protected void okPressed() {
        this.updateProperty("com.ibm.wsspi.wssecurity.krbtoken.targetServiceHost", this.targetServiceHost.getText().trim());
        this.updateProperty("com.ibm.wsspi.wssecurity.krbtoken.targetServiceName", this.targetServiceName.getText().trim());
        this.updateProperty("com.ibm.wsspi.wssecurity.krbtoken.clientRealm", this.clientRealm.getText().trim());
        this.updateProperty("com.ibm.wsspi.wssecurity.krbtoken.targetServiceRealm", this.targetServiceRealm.getText().trim());
        this.basicAuth = this.useBasicAuth.getSelection() ? this.auth.getBasicAuthentication() : null;
        super.okPressed();
    }

    protected String getDialogDescription() {
        return Activator.getMessage("KERBEROS_CALLBACK_HANDLER_DESC");
    }

    public void setBasicAuth(BasicAuthentication basicAuth) {
        this.basicAuth = basicAuth;
    }

    public BasicAuthentication getBasicAuth() {
        return this.basicAuth;
    }
}

