/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.policyset.ui.actions;

import com.ibm.ast.ws.policyset.ui.plugin.Activator;
import com.ibm.ccl.ws.finder.core.WSInfo;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.wsdl.ui.internal.actions.OpenWSDLEditorUtil;

public class OpenWSDLAction
implements IObjectActionDelegate {
    private IWorkbenchPage page = null;
    private IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.page = targetPart.getSite().getPage();
    }

    public void run(IAction action) {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        WSInfo info = (WSInfo)this.selection.getFirstElement();
        IFile file = null;
        try {
            if ("jaxws.service".equals(info.getCategoryId())) {
                Object content = info.getContent(null);
                file = (IFile)Platform.getAdapterManager().loadAdapter(content, IFile.class.getName());
                if (file == null) {
                    String wsdl = (String)Platform.getAdapterManager().getAdapter(content, String.class);
                    if (wsdl == null) {
                        MessageDialog.openError(null, (String)Activator.getMessage("ERR_OPEN_TITLE2"), (String)Activator.getMessage("ERR_OPEN_WSDL"));
                        return;
                    }
                    URI uri = new URI(wsdl);
                    if ("http".equalsIgnoreCase(uri.getScheme())) {
                        OpenWSDLEditorUtil.openHttpFileInEditor((URI)uri);
                    } else {
                        OpenWSDLEditorUtil.openFileInEditor((URI)uri);
                    }
                    return;
                }
            } else {
                String wsdl = info.getProperty("_portable_wsdl_");
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(wsdl));
            }
            IDE.openEditor((IWorkbenchPage)this.page, (IFile)file);
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)Activator.getMessage("ERR_OPEN_TITLE2"), (String)e.getMessage());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }
}

