/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.samples.addressbook;

import com.ibm.ast.ws.internal.service.policy.ui.utils.ImportEntry;
import com.ibm.ast.ws.internal.service.policy.ui.utils.ZipUtils;
import com.ibm.ast.ws.jaxws.samples.SetWasServerTargetOperation;
import com.ibm.ast.ws.service.policy.ui.ServiceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.internal.adaptor.URLConverterImpl;
import org.eclipse.wst.ws.internal.common.BundleUtils;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.osgi.framework.Bundle;

public class AddressBookSAMLServerTargetingOperation
extends SetWasServerTargetOperation {
    @Override
    protected void execute(IProgressMonitor monitor) {
        super.execute(monitor);
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy wasServiceCategory = platform.getServicePolicy("com.ibm.ast.ws.service.policy.ui.policyset.category70");
        String uniqueName = "SAML11 Bearer WSHTTPS default";
        for (IServicePolicy policy : wasServiceCategory.getChildren()) {
            if (!policy.getDescriptor().getLongName().equals(uniqueName)) continue;
            return;
        }
        URLConverterImpl converter = new URLConverterImpl();
        Bundle bundle = Platform.getBundle((String)"com.ibm.ast.ws.service.policy.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File rootFile = new File(stateLocation.toString());
        try {
            URL fileURL = converter.toFileURL(BundleUtils.getURLFromBundle((String)"com.ibm.ast.ws.jaxws.samples", (String)"/install/SAML11 Bearer WSHTTPS default.zip"));
            String path = fileURL.getPath();
            ZipFile zipFile = new ZipFile(path);
            HashMap policySetsTable = new HashMap();
            ZipUtils.getPolicyEntries((ZipFile)zipFile, policySetsTable);
            ImportEntry policySet = (ImportEntry)policySetsTable.get("SAML11 Bearer WSHTTPS default");
            ZipUtils.getPolicySetInfo((ZipFile)zipFile, (ImportEntry)policySet);
            ZipEntry zipEntry = policySet.getPolicySetEntry();
            Path currentPath = new Path(this.getZipName(zipEntry));
            IPath newPathPath = new Path(wasServiceCategory.getId()).append(ServiceUtils.getNewPath((IPath)currentPath, (String)uniqueName));
            String newPathString = newPathPath.toString();
            File newFile = new File(rootFile, newPathString);
            IServicePolicy policySetPolicy = this.createModelPolicy(platform, wasServiceCategory, uniqueName, newPathString, true);
            ZipUtils.writeEntry((ZipFile)zipFile, (ZipEntry)policySet.getPolicySetEntry(), (File)newFile);
            for (ZipEntry policyType : policySet.getPolicyTypes()) {
                Path policyPath = new Path(this.getZipName(policyType));
                IPath newPolicyPathPath = new Path(wasServiceCategory.getId()).append(ServiceUtils.getNewPath((IPath)policyPath, (String)uniqueName));
                String newPolicyPath = newPolicyPathPath.toString();
                File newPolicyFile = new File(rootFile, newPolicyPath);
                String policyName = policyPath.segment(3);
                ZipUtils.writeEntry((ZipFile)zipFile, (ZipEntry)policyType, (File)newPolicyFile);
                this.createModelPolicy(platform, policySetPolicy, policyName, newPolicyPath, false);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return;
        }
        platform.commitChanges();
    }

    private IServicePolicy createModelPolicy(ServicePolicyPlatform platform, IServicePolicy parent, String name, String path, boolean isPolicySet) {
        String idName = isPolicySet ? "qos.policyset" : "policytype";
        String id = "com.ibm.ast.ws.local." + idName + ".id1";
        IServicePolicy newPolicy = platform.createServicePolicy(parent, id, "org.eclipse.wst.service.policy.booleanEnum", "org.eclipse.wst.false");
        IDescriptor descriptor = newPolicy.getDescriptor();
        IPolicyState policyState = newPolicy.getPolicyState();
        descriptor.setShortName(name);
        descriptor.setIconBundleId("com.ibm.ast.ws.service.policy.ui");
        descriptor.setIconPath(isPolicySet ? "icons/obj16/localPolicySet.gif" : "icons/obj16/policytype_obj.gif");
        policyState.putValue("policyPath", "local:/" + path);
        return newPolicy;
    }

    private String getZipName(ZipEntry zipentry) {
        String name = zipentry.getName();
        if (name.indexOf(92) != -1) {
            name = name.replaceAll("\\\\", "/");
        }
        return name;
    }

    public AddressBookSAMLServerTargetingOperation() {
        super(new String[]{"SAMLBearer_AddressBookEAR"});
    }
}

