/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.validation.wsdl;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.validation.WSIBPValidatorConstants;
import com.ibm.xwt.wsdl.validation.wsdl.AbstractWSDLValidator;
import com.ibm.xwt.wsdl.validation.wsdl.IDiagnosticProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.w3c.dom.Element;

public class WSIBasicProfile20WSDLValidator
extends AbstractWSDLValidator {
    public static final String SOAP11_NS = "http://schemas.xmlsoap.org/wsdl/soap/";

    public void configure(Map options) {
        WSIBPValidatorConstants.configure(options, (IDiagnosticProvider)this);
    }

    public void validateBinding(Binding binding) {
    }

    public void validateBindingFault(BindingFault bindingFault) {
    }

    public void validateBindingInput(BindingInput bindingInput) {
    }

    public void validateBindingOutput(BindingOutput bindingOutput) {
    }

    public void validateDefinitions(Definition definition) {
        this.checkURInamespaces(definition);
    }

    public void validateImport(Import wsdlImport) {
    }

    public void validatePortType(PortType portType) {
    }

    public void validateTypes(Types types) {
    }

    protected String getMessage(String messageID, Object[] params) {
        return Messages.bind((String)messageID, (Object[])params);
    }

    protected String getMessagePrefix() {
        return "WS-I BP 2.0: ";
    }

    private void checkURInamespaces(Definition definition) {
        Element definitionElement = definition.getElement();
        Map namespaceMap = definition.getNamespaces();
        Collection namespaceURIs = namespaceMap.values();
        Iterator i = namespaceURIs.iterator();
        while (i.hasNext()) {
            String uri = i.next().toString().trim().toLowerCase();
            if (!uri.startsWith(SOAP11_NS)) continue;
            this.addDiagnostic((WSDLElement)definition, "WSI_BP20_SOAP11", Messages.WSI_BP20_SOAP11, new Object[]{uri}, definitionElement);
        }
    }
}

