/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.validation.wsdl;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.validation.WASValidatorConstants;
import com.ibm.xwt.wsdl.validation.soap.SOAPExtensionsValidator;
import com.ibm.xwt.wsdl.validation.wsdl.IDiagnosticProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFault;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticSeverity;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;

public class WASJaxwsSOAPExtensionsValidator
extends SOAPExtensionsValidator {
    private static final String HTTP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    boolean shouldValidate;

    public void configure(Map options) {
        WASValidatorConstants.configure(options, (IDiagnosticProvider)this);
        this.shouldValidate = WASValidatorConstants.shouldValidate(options);
    }

    public void validate(ExtensibilityElement extensibilityElement) {
        if (this.shouldValidate) {
            super.validate(extensibilityElement);
        }
    }

    protected String getMessage(String messageID, Object[] params) {
        return Messages.bind((String)messageID, (Object[])params);
    }

    protected String getMessagePrefix() {
        return "QoS(JAX-WS): ";
    }

    protected void validateSOAPAddress(SOAPAddress address) {
    }

    protected void validateSOAPBinding(SOAPBinding binding) {
    }

    protected void validateSOAPBody(SOAPBody body) {
        this.checkEncodingUse(body);
    }

    protected void validateSOAPFault(SOAPFault fault) {
    }

    protected void validateSOAPOperation(SOAPOperation operation) {
    }

    private void checkEncodingUse(SOAPBody body) {
        String use = body.getUse();
        if (use != null && use.equalsIgnoreCase("encoded")) {
            this.addDiagnostic((WSDLElement)body, WSDLDiagnosticSeverity.ERROR_LITERAL, "SOAP_ENCODED", Messages.SOAP_ENCODED, null, body.getElement());
        }
    }

    private String getSOAPBindingStyle(SOAPBinding soapBinding) {
        String bindingStyle = soapBinding.getStyle();
        bindingStyle = bindingStyle == null ? "document" : bindingStyle;
        return bindingStyle;
    }

    private SOAPBody getSoapBody(ExtensibleElement extensibleElement) {
        if (extensibleElement == null) {
            return null;
        }
        List extensibilityElements = extensibleElement.getExtensibilityElements();
        if (extensibilityElements.isEmpty()) {
            return null;
        }
        for (ExtensibilityElement extensibilityElement : extensibilityElements) {
            if (!(extensibilityElement instanceof SOAPBody)) continue;
            return (SOAPBody)extensibilityElement;
        }
        return null;
    }

    private SOAPOperation getSOAPOperation(BindingOperation bindingOperation) {
        List extensibilityElements = bindingOperation.getExtensibilityElements();
        if (extensibilityElements.isEmpty()) {
            return null;
        }
        for (ExtensibilityElement extensibilityElement : extensibilityElements) {
            if (!(extensibilityElement instanceof SOAPOperation)) continue;
            return (SOAPOperation)extensibilityElement;
        }
        return null;
    }

    private SOAPBinding getSOAPBinding(Binding binding) {
        List extensibilityElements = binding.getExtensibilityElements();
        if (extensibilityElements.isEmpty()) {
            return null;
        }
        for (ExtensibilityElement extensibilityElement : extensibilityElements) {
            if (!(extensibilityElement instanceof SOAPBinding)) continue;
            return (SOAPBinding)extensibilityElement;
        }
        return null;
    }

    private boolean isDocumentLiteral(SOAPBody body) {
        BindingOperation bindingOperation = (BindingOperation)body.eContainer().eContainer();
        Binding binding = (Binding)bindingOperation.getContainer();
        SOAPBinding soapBinding = this.getSOAPBinding(binding);
        return this.isStyleAndLiteral(soapBinding, "document");
    }

    private boolean isLiteral(SOAPBody soapBody) {
        if (soapBody == null) {
            return false;
        }
        String use = soapBody.getUse();
        return "literal".equals(use);
    }

    private boolean isRPCLiteral(SOAPBody body) {
        BindingOperation bindingOperation = (BindingOperation)body.eContainer().eContainer();
        Binding binding = (Binding)bindingOperation.getContainer();
        SOAPBinding soapBinding = this.getSOAPBinding(binding);
        return this.isStyleAndLiteral(soapBinding, "rpc");
    }

    private boolean isXSDComponentDefined(XSDConcreteComponent concreteComponent) {
        return concreteComponent != null && concreteComponent.getSchema() != null;
    }

    private boolean validParts(Map messageParts, SOAPBody soapBody) {
        String partName;
        ArrayList<String> soapBodyParts = new ArrayList<String>();
        Element element = soapBody.getElement();
        if (element != null && element.hasAttribute("parts")) {
            String partNames = element.getAttribute("parts");
            StringTokenizer parser = new StringTokenizer(partNames, " ");
            while (parser.hasMoreTokens()) {
                partName = parser.nextToken();
                soapBodyParts.add(partName);
            }
        }
        int soapBodyPartsCount = soapBodyParts.size();
        int inputMessagePartsCount = messageParts.size();
        if (soapBodyPartsCount == 0 && inputMessagePartsCount == 1) {
            return true;
        }
        partName = (String)soapBodyParts.get(0);
        Part messagePart = (Part)messageParts.get(partName);
        return messagePart != null;
    }

    private boolean isStyleAndLiteral(SOAPOperation soapOperation, String style) {
        BindingOperation bindingOperation = (BindingOperation)soapOperation.getContainer();
        Binding binding = (Binding)bindingOperation.getContainer();
        SOAPBinding soapBinding = this.getSOAPBinding(binding);
        return this.isStyleAndLiteral(soapBinding, style);
    }

    private boolean isStyleAndLiteral(SOAPBinding soapBinding, String style) {
        String soapBindingStyle = this.getSOAPBindingStyle(soapBinding);
        if (!soapBindingStyle.equals(style)) {
            return false;
        }
        Binding binding = (Binding)soapBinding.getContainer();
        List bindingOperations = binding.getBindingOperations();
        Iterator iterator = bindingOperations.iterator();
        boolean isDocument = true;
        boolean isLiteral = true;
        while (iterator.hasNext()) {
            String soapOperationStyle;
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            BindingInput input = bindingOperation.getEBindingInput();
            SOAPBody soapBody = this.getSoapBody((ExtensibleElement)input);
            if (!this.isLiteral(soapBody)) {
                isLiteral = false;
                break;
            }
            BindingOutput output = bindingOperation.getEBindingOutput();
            soapBody = this.getSoapBody((ExtensibleElement)output);
            if (!this.isLiteral(soapBody)) {
                isLiteral = false;
                break;
            }
            EList faults = bindingOperation.getEBindingFaults();
            for (BindingFault bindingFault : faults) {
                soapBody = this.getSoapBody((ExtensibleElement)bindingFault);
                if (this.isLiteral(soapBody)) continue;
                isLiteral = false;
                break;
            }
            if (!isLiteral) break;
            SOAPOperation soapOperation = this.getSOAPOperation(bindingOperation);
            if (soapOperation == null || style.equals(soapOperationStyle = soapOperation.getStyle()) || soapOperationStyle == null && style.equals(soapBindingStyle)) continue;
            isDocument = false;
            break;
        }
        return isDocument && isLiteral;
    }
}

