/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.emitter.command.WsImportCommand;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsimportNonUIThreadCommand
extends AbstractDataModelOperation {
    WsImportCommand wsimportCmd;
    String wsdlURI;
    String outputSrcLocation;
    String targetPackage;
    String[] bindingFiles;
    boolean asyncMapping;
    String asyncMappingFile;
    boolean disableWrapperStyle;
    String disableWrapperStyleFile;
    boolean copyWsdl;
    String wsdlLocation;
    String wsdlLocationURL;
    boolean wsimportExtension;
    IProject project;
    boolean useStubRuntimeForCodeGen;
    String serverInstanceId;
    String serverFactoryId;
    String targetVersion;
    private List<JAXWSWebServiceService> services;

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
    }

    public WsimportNonUIThreadCommand() {
    }

    public WsimportNonUIThreadCommand(String id) {
        this();
        this.setID(id);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        this.wsimportCmd = new WsImportCommand();
        RunCmdInNonUIThread runnable = new RunCmdInNonUIThread((AbstractDataModelOperation)this.wsimportCmd, info);
        this.initializeWsImportCmd();
        IStatus retStatus = Status.OK_STATUS;
        try {
            if (Display.getCurrent() != null) {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)runnable);
                retStatus = runnable.getStatus();
            } else {
                retStatus = this.wsimportCmd.execute(monitor, info);
            }
            if (!retStatus.isOK()) {
                super.getEnvironment().getStatusHandler().report(retStatus);
                if (retStatus.getSeverity() == 4) {
                    return retStatus;
                }
            }
            Hashtable servicePortsMapping = this.wsimportCmd.getServicePortsMapping();
            for (QName serviceQName : servicePortsMapping.keySet()) {
                JAXWSWebServiceService service = this.findService(serviceQName);
                for (QName portQName : (List)servicePortsMapping.get(serviceQName)) {
                    String sei = (String)this.wsimportCmd.getPortSEIMapping().get(portQName);
                    JAXWSWebServiceBinding binding = this.findBindingWithPort(service, portQName);
                    if (binding == null) continue;
                    binding.setSei(sei);
                }
            }
            this.removeBindingsWithNoSEI();
            if (this.copyWsdl) {
                if (!retStatus.isOK()) {
                    super.getEnvironment().getStatusHandler().report(retStatus);
                }
                return this.modifyServiceFiles();
            }
        }
        catch (Exception e) {
            retStatus = StatusUtils.errorStatus((Throwable)e);
        }
        return retStatus;
    }

    private JAXWSWebServiceService findService(QName serviceQName) {
        for (JAXWSWebServiceService service : this.services) {
            if (!service.getServiceName().equals(serviceQName)) continue;
            return service;
        }
        return new JAXWSWebServiceService(serviceQName);
    }

    private JAXWSWebServiceBinding findBindingWithPort(JAXWSWebServiceService service, QName portQName) {
        for (JAXWSWebServiceBinding binding : service.getBindings()) {
            for (JAXWSWebServicePort port : binding.getPorts()) {
                if (!port.getPortName().getLocalPart().equals(portQName.getLocalPart())) continue;
                return binding;
            }
        }
        return null;
    }

    private void removeBindingsWithNoSEI() {
        for (JAXWSWebServiceService service : this.services) {
            List<JAXWSWebServiceBinding> bindings = service.getBindings();
            int i = 0;
            while (i < bindings.size()) {
                JAXWSWebServiceBinding binding = bindings.get(i);
                if (binding.getSei() == null) {
                    bindings.remove(binding);
                    --i;
                }
                ++i;
            }
        }
    }

    private IStatus modifyServiceFiles() {
        Hashtable<QName, String> serviceClassNameMapping = this.getServiceClassNameMapping();
        Enumeration<String> serviceClassNames = serviceClassNameMapping.elements();
        StringBuffer serviceFileName = new StringBuffer();
        StringBuffer modifiedContents = new StringBuffer();
        String newWsdlLocationURL = new StringBuffer("\"").append(this.wsdlLocationURL).append("\"").toString();
        String lineSeparator = System.getProperty("line.separator");
        while (serviceClassNames.hasMoreElements()) {
            File serviceFile;
            block27: {
                IStatus retStatus;
                String serviceClassName = serviceClassNames.nextElement();
                serviceFileName.setLength(0);
                modifiedContents.setLength(0);
                serviceFileName.append(serviceClassName.replace('.', File.separatorChar)).append(".java");
                serviceFile = new File(this.outputSrcLocation, serviceFileName.toString());
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(serviceFile));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        String trimmedS = s.trim();
                        if (trimmedS.startsWith("URL baseUrl;") || trimmedS.startsWith("baseUrl = ")) continue;
                        if (trimmedS.startsWith("url = new URL")) {
                            modifiedContents.append("            url = ").append(serviceClassName).append(".class.getResource(").append(newWsdlLocationURL).append(");").append(lineSeparator);
                            modifiedContents.append("            if (url == null) throw new MalformedURLException(\"").append(this.wsdlLocationURL).append(" does not exist in the module.\");").append(lineSeparator);
                            continue;
                        }
                        modifiedContents.append(s).append(lineSeparator);
                    }
                }
                catch (FileNotFoundException e) {
                    retStatus = StatusUtils.errorStatus((String)"FileNotFoundException in WsimportNonUIThreadCommand.modifyServiceFiles()", (Throwable)e);
                    Activator.getDefault().getLog().log(retStatus);
                    IStatus iStatus = retStatus;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return iStatus;
                }
                catch (IOException e) {
                    IStatus iStatus;
                    block26: {
                        try {
                            retStatus = StatusUtils.errorStatus((String)"IOException in WsimportNonUIThreadCommand.modifyServiceFiles()", (Throwable)e);
                            Activator.getDefault().getLog().log(retStatus);
                            iStatus = retStatus;
                            if (br == null) break block26;
                        }
                        catch (Throwable throwable) {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return iStatus;
                }
                if (br == null) break block27;
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(serviceFile);
                    pw.print(modifiedContents.toString());
                }
                catch (FileNotFoundException e) {
                    IStatus retStatus = StatusUtils.errorStatus((String)"FileNotFoundException in WsimportNonUIThreadCommand.modifyServiceFiles()", (Throwable)e);
                    Activator.getDefault().getLog().log(retStatus);
                    IStatus iStatus = retStatus;
                    if (pw != null) {
                        pw.close();
                    }
                    return iStatus;
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private void initializeWsImportCmd() {
        this.wsimportCmd.setWsdlURI(this.wsdlURI);
        this.wsimportCmd.setOutputSrcLocation(this.outputSrcLocation);
        this.wsimportCmd.setTargetPackage(this.targetPackage);
        this.wsimportCmd.setBindingFiles(this.bindingFiles);
        this.wsimportCmd.setAsyncMapping(this.asyncMapping);
        this.wsimportCmd.setAsyncMappingFile(this.asyncMappingFile);
        this.wsimportCmd.setDisableWrapperStyle(this.disableWrapperStyle);
        this.wsimportCmd.setDisableWrapperStyleFile(this.disableWrapperStyleFile);
        this.wsimportCmd.setCopyWSDL(this.copyWsdl);
        this.wsimportCmd.setWsdlLocation(this.wsdlLocation);
        this.wsimportCmd.setWsimportExtension(this.wsimportExtension);
        this.wsimportCmd.setEnvironment(super.getEnvironment());
        this.wsimportCmd.setProject(this.project);
        this.wsimportCmd.setUseStubRuntimeForCodeGen(this.useStubRuntimeForCodeGen);
        this.wsimportCmd.setServerFactoryId(this.serverFactoryId);
        this.wsimportCmd.setServerInstanceId(this.serverInstanceId);
        this.wsimportCmd.setTargetVersion(this.targetVersion);
    }

    public String getWsdlLocation() {
        return this.wsimportCmd.getWsdlLocation();
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setOutputSrcLocation(String outputSrcLocation) {
        this.outputSrcLocation = outputSrcLocation;
    }

    public Hashtable<QName, List<QName>> getServicePortsMapping() {
        return this.wsimportCmd.getServicePortsMapping();
    }

    public Hashtable<QName, String> getPortSEIMapping() {
        return this.wsimportCmd.getPortSEIMapping();
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setBindingFiles(String[] bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setAsyncMapping(boolean asyncMapping) {
        this.asyncMapping = asyncMapping;
    }

    public void setAsyncMappingFile(String asyncMappingFile) {
        this.asyncMappingFile = asyncMappingFile;
    }

    public void setDisableWrapperStyle(boolean disableWrapperStyle) {
        this.disableWrapperStyle = disableWrapperStyle;
    }

    public void setDisableWrapperStyleFile(String disableWrapperStyleFile) {
        this.disableWrapperStyleFile = disableWrapperStyleFile;
    }

    public Hashtable<QName, String> getServiceClassNameMapping() {
        return this.wsimportCmd.getServiceClassNameMapping();
    }

    public HashSet<String> getMethodParameterClasses() {
        return this.wsimportCmd.getMethodParameterClasses();
    }

    public void setCopyWSDL(boolean copyWsdl) {
        this.copyWsdl = copyWsdl;
    }

    public void setWsdlLocationURL(String wsdlLocationURL) {
        this.wsdlLocationURL = wsdlLocationURL;
    }

    public Boolean getCopyWSDL() {
        return this.wsimportCmd.getCopyWSDL();
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setWsimportExtension(boolean wsimportExtension) {
        this.wsimportExtension = wsimportExtension;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setUseStubRuntimeForCodeGen(boolean useStubRuntimeForCodeGen) {
        this.useStubRuntimeForCodeGen = useStubRuntimeForCodeGen;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = "".equals(targetVersion) ? null : targetVersion;
    }

    public List<JAXWSWebServiceService> getServices() {
        return this.services;
    }

    private class RunCmdInNonUIThread
    implements IRunnableWithProgress {
        private AbstractDataModelOperation cmd;
        private IAdaptable adaptable;
        private IStatus status = Status.OK_STATUS;

        RunCmdInNonUIThread(AbstractDataModelOperation cmd, IAdaptable info) {
            this.cmd = cmd;
            this.adaptable = info;
        }

        public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
            try {
                this.status = this.cmd.execute(shellMonitor, this.adaptable);
            }
            catch (Exception exception) {}
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

