/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ValidateJ2EEAppClientCommand
extends AbstractDataModelOperation {
    private IProject clientProject;
    private IProject clientEarProject;
    private Boolean installClient;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        if (this.installClient != null && !this.installClient.booleanValue()) {
            return Status.OK_STATUS;
        }
        if (!J2EEUtil.isAppClientProject((IProject)this.clientProject)) {
            return Status.OK_STATUS;
        }
        if (this.clientEarProject == null || !this.clientEarProject.exists()) {
            IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERR_ONLY_APPCLIENT_IN_EAR);
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        EARArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)this.clientEarProject);
            if (artifactEdit == null) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERR_ONLY_APPCLIENT_IN_EAR);
                env.getStatusHandler().reportError(errorStatus);
                IStatus iStatus = errorStatus;
                return iStatus;
            }
            boolean appClientOnly = true;
            IVirtualReference[] refList = J2EEProjectUtilities.getJ2EEModuleReferences((IVirtualComponent)artifactEdit.getComponent());
            int i = 0;
            while (i < refList.length) {
                IVirtualComponent ic = refList[i].getReferencedComponent();
                if (J2EEUtil.isJavaConnectorComponent((IVirtualComponent)ic) || J2EEUtil.isEJBComponent((IVirtualComponent)ic) || J2EEUtil.isWebComponent((IVirtualComponent)ic)) {
                    appClientOnly = false;
                    break;
                }
                ++i;
            }
            if (appClientOnly) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.MSG_ERR_ONLY_APPCLIENT_IN_EAR);
                env.getStatusHandler().reportError(errorStatus);
                IStatus iStatus = errorStatus;
                return iStatus;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject = clientProject;
    }

    public void setClientEarProject(IProject clientEarProject) {
        this.clientEarProject = clientEarProject;
    }

    public void setInstallClient(Boolean installClient) {
        this.installClient = installClient;
    }
}

