/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.util.J2EEUtil;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import com.ibm.etools.j2ee.ejb.creation.operations.CreateSessionBeanDataModelProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ValidateClientEJBJarXMLCommand
extends AbstractDataModelOperation {
    private IProject clientProject;
    private final String NEW_LINE = System.getProperty("line.separator");

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (!J2EEUtil.isEJBProject((IProject)this.clientProject)) {
            return Status.OK_STATUS;
        }
        boolean needToCreateDefaultSessionBean = false;
        IEnvironment env = super.getEnvironment();
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.clientProject);
        Object model = provider.getModelObject();
        if (model instanceof EJBJar) {
            EnterpriseBeans beans = ((EJBJar)model).getEnterpriseBeans();
            if (beans == null) {
                needToCreateDefaultSessionBean = true;
            }
        } else {
            org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = (org.eclipse.jst.j2ee.ejb.EJBJar)model;
            EList ejbs = ejbJar.getEnterpriseBeans();
            if (ejbs.size() == 0) {
                needToCreateDefaultSessionBean = true;
            }
        }
        if (needToCreateDefaultSessionBean) {
            this.createDefaultSessionBean(env);
        }
        return Status.OK_STATUS;
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject = clientProject;
    }

    private IStatus createDefaultSessionBean(IEnvironment env) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.clientProject);
        Object model = provider.getModelObject();
        if (model instanceof EJBJar) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos);
                pw.write("package ejbs;");
                pw.write(String.valueOf(this.NEW_LINE) + this.NEW_LINE);
                pw.write("import javax.ejb.Stateless;");
                pw.write(String.valueOf(this.NEW_LINE) + this.NEW_LINE);
                pw.write("@Stateless");
                pw.write(this.NEW_LINE);
                pw.write("public class DefaultSession {");
                pw.write(String.valueOf(this.NEW_LINE) + this.NEW_LINE);
                pw.write("    public DefaultSession() {");
                pw.write(this.NEW_LINE);
                pw.write("    }");
                pw.write(String.valueOf(this.NEW_LINE) + this.NEW_LINE);
                pw.write("}");
                pw.write(this.NEW_LINE);
                pw.close();
                baos.close();
                StringBuffer sb = new StringBuffer("ejbs/DefaultSession");
                sb.append(".java");
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                FileResourceUtils.createFile((ResourceContext)((BaseEclipseEnvironment)env).getResourceContext(), (IPath)J2EEUtil.getJavaSourceLocation((IProject)this.clientProject).append((IPath)new Path(sb.toString())), (InputStream)bais, (IProgressMonitor)new NullProgressMonitor(), (IStatusHandler)super.getEnvironment().getStatusHandler());
            }
            catch (Exception exception) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERR_GENERAL, (Object)"The default session bean is not generated successfully."));
                env.getStatusHandler().reportError(errorStatus);
                return errorStatus;
            }
        }
        try {
            IDataModel m = DataModelFactory.createDataModel((IDataModelProvider)new CreateSessionBeanDataModelProvider());
            m.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.clientProject.getName());
            m.setProperty("ICreateEnterpriseBeanDataModelProperties.beanName", (Object)"DefaultSession");
            m.setProperty("ICreateEnterpriseBeanDataModelProperties.defaultPackageName", (Object)"ejbs");
            m.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            IStatus errorStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERR_GENERAL, (Object)"The default session bean is not generated successfully."));
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }
}

