/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceBinding;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServicePort;
import com.ibm.ast.ws.jaxws.creation.command.JAXWSWebServiceService;
import com.ibm.ast.ws.jaxws.emitter.util.JavaUtil;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebapplicationFactoryImpl;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateWEBXMLOperation
extends AbstractDataModelOperation {
    private IProject serviceProject;
    protected Hashtable<String, String> customizedImplName = null;
    protected List<JAXWSWebServiceService> services;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        for (JAXWSWebServiceService service : this.services) {
            if (service.getBindings().size() <= 1 && !service.isMultiport()) continue;
            this.addServletEntriesForMultiplePorts(service);
        }
        return Status.OK_STATUS;
    }

    private void addServletEntriesForMultiplePorts(JAXWSWebServiceService service) {
        for (JAXWSWebServiceBinding binding : service.getBindings()) {
            for (JAXWSWebServicePort port : binding.getPorts()) {
                String seiQualifiedClassName = binding.getSei();
                String packageName = JavaUtil.getPackageNameFromClassName((String)seiQualifiedClassName);
                String implBeanClassName = String.valueOf(packageName) + '.' + this.calculateImplClassName(binding.getBindingName().getLocalPart());
                this.addServlet(this.serviceProject, implBeanClassName, implBeanClassName, "services/" + port.getPortName().getLocalPart());
            }
        }
    }

    protected void addServlet(IProject webProject, String servletName, String servletClass, String servletMappingName) {
        this.addServlet(webProject, servletName, servletClass, servletMappingName, true);
    }

    protected void addServlet(IProject webProject, String servletName, String servletClass, String servletMappingName, boolean loadOnStartup) {
        block14: {
            WebArtifactEdit webEdit = null;
            try {
                try {
                    WebApp webapp = null;
                    webEdit = WebArtifactEdit.getWebArtifactEditForWrite((IProject)webProject);
                    if (webEdit == null) break block14;
                    webapp = (WebApp)webEdit.getDeploymentDescriptorRoot();
                    boolean foundServlet = false;
                    Servlet foundServletInstance = null;
                    EList theServlets = webapp.getServlets();
                    int i = 0;
                    while (i < theServlets.size()) {
                        Servlet aServlet = (Servlet)theServlets.get(i);
                        if (aServlet.getServletName().equals(servletName)) {
                            foundServlet = true;
                            foundServletInstance = aServlet;
                            break;
                        }
                        ++i;
                    }
                    if (foundServlet) {
                        boolean foundServletMapping = false;
                        EList servletMappings = webapp.getServletMappings();
                        int i2 = 0;
                        while (i2 < servletMappings.size()) {
                            ServletMapping servletMapping = (ServletMapping)servletMappings.get(i2);
                            if (servletMapping.getServlet() != null && servletMapping.getServlet().equals(foundServletInstance) && servletMapping.getUrlPattern() != null && servletMapping.getUrlPattern().equals(servletMappingName)) {
                                foundServletMapping = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!foundServletMapping) {
                            WebapplicationFactoryImpl factory = new WebapplicationFactoryImpl();
                            ServletMapping servletMapping1 = factory.createServletMapping();
                            servletMapping1.setServlet(foundServletInstance);
                            servletMapping1.setUrlPattern(servletMappingName);
                            webapp.getServletMappings().add((Object)servletMapping1);
                            webEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                        }
                        break block14;
                    }
                    WebapplicationFactoryImpl factory = new WebapplicationFactoryImpl();
                    Servlet servlet = factory.createServlet();
                    ServletType servletType = factory.createServletType();
                    ServletMapping servletMapping1 = factory.createServletMapping();
                    servletType.setClassName(servletClass);
                    servlet.setServletName(servletName);
                    if (loadOnStartup) {
                        servlet.setLoadOnStartup(new Integer(1));
                    }
                    servlet.setWebType((WebType)servletType);
                    servletMapping1.setServlet(servlet);
                    servletMapping1.setUrlPattern(servletMappingName);
                    webapp.getServlets().add((Object)servlet);
                    webapp.getServletMappings().add((Object)servletMapping1);
                    webEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                }
            }
            finally {
                if (webEdit != null) {
                    webEdit.dispose();
                }
            }
        }
    }

    public static String getDefaultImplClassName(String className) {
        if (className != null) {
            return String.valueOf(className) + "Impl";
        }
        return className;
    }

    private String calculateImplClassName(String portName) {
        if (this.customizedImplName != null && this.customizedImplName.get(portName) != null) {
            return this.customizedImplName.get(portName);
        }
        return UpdateWEBXMLOperation.getDefaultImplClassName(portName);
    }

    public void setProject(IProject project) {
        this.serviceProject = project;
    }

    public void setServices(List<JAXWSWebServiceService> services) {
        this.services = services;
    }

    public void setCustomizedImplNames(Hashtable<String, String> customizedImplName) {
        this.customizedImplName = customizedImplName;
    }
}

