/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ast.ws.jaxws.creation.command;

import com.ibm.ast.ws.jaxws.creation.context.CodeGenerationContext;
import com.ibm.ast.ws.jaxws.creation.plugin.Activator;
import com.ibm.ast.ws.jaxws.creation.ui.messages.Messages;
import com.ibm.ast.ws.jaxws.emitter.command.WsGenCommand;
import com.ibm.ast.ws.jaxws.emitter.util.StatusUtils;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.util.IAnnotation;
import org.eclipse.jdt.core.util.IAnnotationComponent;
import org.eclipse.jdt.core.util.IAnnotationComponentValue;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IRuntimeVisibleAnnotationsAttribute;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class ParseImplBeanCommand
extends AbstractDataModelOperation {
    private final String JAVAX_JWS_WEBSERVICE = "javax.jws.WebService";
    private final String JAVAX_JWS_SOAP_SOAPBINDING = "javax.jws.soap.SOAPBinding";
    private final String JAVAX_XML_WS_BINDINGTYPE = "javax.xml.ws.BindingType";
    private WebServiceInfo serviceInfo;
    private IProject project;
    private String javaBeanName;
    private boolean isImplBeanAnnotated;
    private String bindingTypeImplBean;
    private String serviceNameImplBean;
    private String portNameImplBean;
    private String tnsImplBean;
    private String wsdlLocImplBean;
    private CodeGenerationContext.JAVA2WSDL_MAPPING mappingStyleImplBean;

    public ParseImplBeanCommand(WebServiceInfo info) {
        this.serviceInfo = info;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        this.javaBeanName = this.serviceInfo.getImplURL();
        try {
            IType javaType = javaProject.findType(this.javaBeanName);
            IStatus status = this.checkType(javaType);
            if (!status.isOK()) {
                return status;
            }
            if (javaType.isBinary()) {
                this.processBinary(javaType);
            } else {
                this.processSource(javaType);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errStatus = StatusUtils.errorStatus((Throwable)e);
            Activator.getDefault().getLog().log(errStatus);
            return errStatus;
        }
    }

    private IStatus checkType(IType javaType) {
        try {
            IMethod[] methods;
            boolean hasConstructor = false;
            boolean hasPublicDefaultCtor = false;
            IMethod[] iMethodArray = methods = javaType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    hasConstructor = true;
                    int flags = method.getFlags();
                    if (Flags.isPublic((int)flags) && method.getNumberOfParameters() == 0) {
                        hasPublicDefaultCtor = true;
                        break;
                    }
                }
                ++n2;
            }
            if (hasConstructor && !hasPublicDefaultCtor) {
                return StatusUtils.errorStatus((String)NLS.bind((String)Messages.MSG_ERROR_NO_PUBLIC_DEFAULT_CTOR, (Object)javaType.getFullyQualifiedName()));
            }
        }
        catch (JavaModelException javaModelException) {}
        return Status.OK_STATUS;
    }

    private void processBinary(IType javaType) {
        IClassFileAttribute[] attrs;
        this.isImplBeanAnnotated = false;
        this.bindingTypeImplBean = null;
        this.serviceNameImplBean = null;
        this.portNameImplBean = null;
        this.tnsImplBean = null;
        this.mappingStyleImplBean = CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_WRAPPED;
        IClassFile classFile = javaType.getClassFile();
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((IClassFile)classFile, (int)65503);
        IClassFileAttribute[] iClassFileAttributeArray = attrs = reader.getAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFileAttribute attr = iClassFileAttributeArray[n2];
            if (attr instanceof IRuntimeVisibleAnnotationsAttribute) {
                IAnnotation[] annotations;
                IRuntimeVisibleAnnotationsAttribute annData = (IRuntimeVisibleAnnotationsAttribute)attr;
                IAnnotation[] iAnnotationArray = annotations = annData.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotationComponentValue value;
                    String attrName;
                    IAnnotationComponent component;
                    int n5;
                    int n6;
                    IAnnotationComponent[] iAnnotationComponentArray;
                    IAnnotationComponent[] components;
                    IAnnotation annotation = iAnnotationArray[n4];
                    String typeName = this.getTypeNameFromBytecode(annotation.getTypeName());
                    if ("javax.jws.WebService".equals(typeName)) {
                        this.isImplBeanAnnotated = true;
                        iAnnotationComponentArray = components = annotation.getComponents();
                        n6 = components.length;
                        n5 = 0;
                        while (n5 < n6) {
                            component = iAnnotationComponentArray[n5];
                            attrName = String.valueOf(component.getComponentName());
                            if (attrName.equals("serviceName")) {
                                value = component.getComponentValue();
                                this.serviceNameImplBean = String.valueOf(value.getConstantValue().getUtf8Value());
                            }
                            if (attrName.equals("portName")) {
                                value = component.getComponentValue();
                                this.portNameImplBean = String.valueOf(value.getConstantValue().getUtf8Value());
                            }
                            if (attrName.equals("targetNameSpace")) {
                                value = component.getComponentValue();
                                this.tnsImplBean = String.valueOf(value.getConstantValue().getUtf8Value());
                            }
                            if (attrName.equals("wsdlLocation")) {
                                value = component.getComponentValue();
                                String str = String.valueOf(value.getConstantValue().getUtf8Value());
                                this.wsdlLocImplBean = str.trim();
                            }
                            ++n5;
                        }
                    }
                    if ("javax.xml.ws.BindingType".equals(typeName)) {
                        iAnnotationComponentArray = components = annotation.getComponents();
                        n6 = components.length;
                        n5 = 0;
                        while (n5 < n6) {
                            component = iAnnotationComponentArray[n5];
                            attrName = String.valueOf(component.getComponentName());
                            if (attrName.equals("value")) {
                                value = component.getComponentValue();
                                this.bindingTypeImplBean = String.valueOf(value.getConstantValue().getUtf8Value());
                            }
                            ++n5;
                        }
                    }
                    if ("javax.jws.soap.SOAPBinding".equals(typeName)) {
                        components = annotation.getComponents();
                        String style = null;
                        String use = null;
                        String parameterStyle = null;
                        IAnnotationComponent[] iAnnotationComponentArray2 = components;
                        int n7 = components.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            IAnnotationComponentValue value2;
                            IAnnotationComponent component2 = iAnnotationComponentArray2[n8];
                            String attrName2 = String.valueOf(component2.getComponentName());
                            if (attrName2.equals("style")) {
                                value2 = component2.getComponentValue();
                                style = String.valueOf(value2.getEnumConstantName());
                            }
                            if (attrName2.equals("parameterStyle")) {
                                value2 = component2.getComponentValue();
                                parameterStyle = String.valueOf(value2.getEnumConstantName());
                            }
                            if (attrName2.equals("use")) {
                                value2 = component2.getComponentValue();
                                use = String.valueOf(value2.getEnumConstantName());
                            }
                            ++n8;
                        }
                        this.mappingStyleImplBean = this.determineMappingStyle(style, use, parameterStyle);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private String getTypeNameFromBytecode(char[] typeNameBytecode) {
        int i = 0;
        while (i < typeNameBytecode.length) {
            if (typeNameBytecode[i] == '/') {
                typeNameBytecode[i] = 46;
            }
            ++i;
        }
        char[] packageName = Signature.getSignatureQualifier((char[])typeNameBytecode);
        char[] className = Signature.getSignatureSimpleName((char[])typeNameBytecode);
        StringBuffer typeName = new StringBuffer();
        if (packageName.length > 0) {
            typeName.append(packageName).append('.');
        }
        typeName.append(className);
        return typeName.toString();
    }

    private void processSource(IType javaType) {
        this.isImplBeanAnnotated = false;
        this.bindingTypeImplBean = null;
        this.serviceNameImplBean = null;
        this.portNameImplBean = null;
        this.tnsImplBean = null;
        ICompilationUnit icu = javaType.getCompilationUnit();
        CompilationUnit cu = this.parseForCompilationUnit(icu);
        List cuTypes = cu.types();
        for (Object cuTypeObject : cuTypes) {
            IAnnotationBinding[] annotationBindings;
            TypeDeclaration typeDecl;
            if (!(cuTypeObject instanceof TypeDeclaration) || !(typeDecl = (TypeDeclaration)cuTypeObject).getName().getIdentifier().equals(javaType.getElementName())) continue;
            ITypeBinding typeBinding = typeDecl.resolveBinding();
            IAnnotationBinding[] iAnnotationBindingArray = annotationBindings = typeBinding.getAnnotations();
            int n = annotationBindings.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding attr;
                int n3;
                int n4;
                IMemberValuePairBinding[] iMemberValuePairBindingArray;
                IMemberValuePairBinding[] attrs;
                IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                if ("javax.jws.WebService".equals(annotationBinding.getAnnotationType().getQualifiedName())) {
                    this.isImplBeanAnnotated = true;
                    iMemberValuePairBindingArray = attrs = annotationBinding.getDeclaredMemberValuePairs();
                    n4 = attrs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        attr = iMemberValuePairBindingArray[n3];
                        if (attr.getName().equals("serviceName")) {
                            this.serviceNameImplBean = (String)attr.getValue();
                        }
                        if (attr.getName().equals("portName")) {
                            this.portNameImplBean = (String)attr.getValue();
                        }
                        if (attr.getName().equals("targetNamespace")) {
                            this.tnsImplBean = (String)attr.getValue();
                        }
                        if (attr.getName().equals("wsdlLocation")) {
                            this.wsdlLocImplBean = (String)attr.getValue();
                        }
                        ++n3;
                    }
                }
                if ("javax.xml.ws.BindingType".equals(annotationBinding.getAnnotationType().getQualifiedName())) {
                    iMemberValuePairBindingArray = attrs = annotationBinding.getDeclaredMemberValuePairs();
                    n4 = attrs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        attr = iMemberValuePairBindingArray[n3];
                        if (attr.getName().equals("value")) {
                            this.bindingTypeImplBean = (String)attr.getValue();
                        }
                        ++n3;
                    }
                }
                if ("javax.jws.soap.SOAPBinding".equals(annotationBinding.getAnnotationType().getQualifiedName())) {
                    IMemberValuePairBinding[] attrs2;
                    IVariableBinding style = null;
                    IVariableBinding use = null;
                    IVariableBinding parameterStyle = null;
                    IMemberValuePairBinding[] iMemberValuePairBindingArray2 = attrs2 = annotationBinding.getDeclaredMemberValuePairs();
                    int n5 = attrs2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMemberValuePairBinding attr2 = iMemberValuePairBindingArray2[n6];
                        if (attr2.getName().equals("style")) {
                            style = (IVariableBinding)attr2.getValue();
                        }
                        if (attr2.getName().equals("use")) {
                            use = (IVariableBinding)attr2.getValue();
                        }
                        if (attr2.getName().equals("parameterStyle")) {
                            parameterStyle = (IVariableBinding)attr2.getValue();
                        }
                        ++n6;
                    }
                    this.mappingStyleImplBean = this.determineMappingStyle(style, use, parameterStyle);
                }
                ++n2;
            }
        }
    }

    private CompilationUnit parseForCompilationUnit(ICompilationUnit icu) {
        ASTParser parser_ = ASTParser.newParser((int)3);
        parser_.setSource(icu);
        parser_.setResolveBindings(true);
        return (CompilationUnit)parser_.createAST(null);
    }

    private CodeGenerationContext.JAVA2WSDL_MAPPING determineMappingStyle(IVariableBinding style, IVariableBinding use, IVariableBinding parameterStyle) {
        if (style != null && style.getName().equals("RPC")) {
            return CodeGenerationContext.JAVA2WSDL_MAPPING.RPC;
        }
        if (parameterStyle != null && parameterStyle.getName().equals("BARE")) {
            return CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_BARE;
        }
        return CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_WRAPPED;
    }

    private CodeGenerationContext.JAVA2WSDL_MAPPING determineMappingStyle(String style, String use, String parameterStyle) {
        if (style != null && style.equals("RPC")) {
            return CodeGenerationContext.JAVA2WSDL_MAPPING.RPC;
        }
        if (parameterStyle != null || parameterStyle.equals("BARE")) {
            return CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_BARE;
        }
        return CodeGenerationContext.JAVA2WSDL_MAPPING.DOCUMENT_WRAPPED;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public String getJavaBeanName() {
        return this.javaBeanName;
    }

    public Boolean getIsImplBeanAnnotated() {
        return new Boolean(this.isImplBeanAnnotated);
    }

    public WsGenCommand.BINDING_TYPE getBindingTypeImplBean() {
        if (this.bindingTypeImplBean == null) {
            return WsGenCommand.BINDING_TYPE.SOAP11HTTP;
        }
        if (this.bindingTypeImplBean.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            return WsGenCommand.BINDING_TYPE.SOAP12HTTP;
        }
        if (this.bindingTypeImplBean.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true")) {
            return WsGenCommand.BINDING_TYPE.SOAP12HTTP_MTOM;
        }
        if (this.bindingTypeImplBean.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true")) {
            return WsGenCommand.BINDING_TYPE.SOAP11HTTP_MTOM;
        }
        return WsGenCommand.BINDING_TYPE.SOAP11HTTP;
    }

    public String getServiceNameImplBean() {
        return this.serviceNameImplBean;
    }

    public String getPortNameImplBean() {
        return this.portNameImplBean;
    }

    public String getTnsImplBean() {
        return this.tnsImplBean;
    }

    public String getWsdlLocImplBean() {
        return this.wsdlLocImplBean;
    }

    public CodeGenerationContext.JAVA2WSDL_MAPPING getMappingStyleImplBean() {
        return this.mappingStyleImplBean;
    }
}

